/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.mixin.accessor.LightningBoltAccessor;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class ReikarlilyBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_RESIDUAL_HEAT = "residualHeat";
    private static final String TAG_SPAWN_LIGHTNING_COOLDOWN = "spawnLightningCooldown";
    private static final int RANGE = 4;
    public static final int MAX_MANA = 12000;
    public static final int COOLDOWN = 3600;
    public static final int PRODUCE_MANA = 12000;
    public static final int RESIDUAL_HEAT_AFTER_PRODUCE = 1500;
    public static final int RESIDUAL_HEAT_PRODUCE_MANA = 45;
    public static final int SPAWN_LIGHTNING_COOLDOWN = 3600;
    private static final int INITIAL_SPAWN_LIGHTNING_COOLDOWN = 3600;
    private int cooldown;
    private int residualHeat;
    private int spawnLightningCooldown;

    public ReikarlilyBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.REIKARLILY, pos, state);
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        this.setSpawnLightningCooldown(3600 + this.m_58904_().m_213780_().m_188503_(400));
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
        if (this.getResidualHeat() > 0) {
            this.addMana(this.getResidualHeatProduceMana());
            this.setResidualHeat(this.getResidualHeat() - 1);
        }
        if (this.getSpawnLightningCooldown() > 0) {
            this.setSpawnLightningCooldown(this.getSpawnLightningCooldown() - 1);
        }
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
            return;
        }
        if (this.getSpawnLightningCooldown() <= 0 && this.trySpawnLightningBolt()) {
            this.setSpawnLightningCooldown(this.getAfterSpawnLightningCooldown());
        }
        if (this.resolveActiveProduce()) {
            this.setCooldown(this.getAfterWorkCooldown());
            this.setResidualHeat(this.getResidualHeatAfterProduce());
            this.addMana(this.getProduceMana());
        }
    }

    public boolean trySpawnLightningBolt() {
        if (!this.m_58904_().m_46758_(this.getEffectivePos())) {
            return false;
        }
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_58904_());
        double xOffset = (this.m_58904_().m_213780_().m_188500_() - 0.5) * 0.5;
        double zOffset = (this.m_58904_().m_213780_().m_188500_() - 0.5) * 0.5;
        lightningBolt.m_6027_((double)this.getEffectivePos().m_123341_() + xOffset, (double)(this.getEffectivePos().m_123342_() + 1), (double)this.getEffectivePos().m_123343_() + zOffset);
        this.m_58904_().m_7967_((Entity)lightningBolt);
        return true;
    }

    public boolean resolveActiveProduce() {
        boolean produce = false;
        List lightnings = this.m_58904_().m_45976_(LightningBolt.class, new AABB(this.getEffectivePos()).m_82400_(4.0));
        for (LightningBolt lightning : lightnings) {
            if (this.getMana() >= this.getMaxMana() || ((LightningBoltAccessor)lightning).isVisualOnly() || !lightning.m_6084_()) continue;
            lightning.m_20874_(true);
            produce = true;
            break;
        }
        return produce;
    }

    public int getAfterWorkCooldown() {
        return ExtraBotanyConfig.common().reikarlilyProduceCooldown();
    }

    public int getAfterSpawnLightningCooldown() {
        return ExtraBotanyConfig.common().reikarlilySpawnLightningCooldown();
    }

    public int getProduceMana() {
        return ExtraBotanyConfig.common().reikarlilyProduceMana();
    }

    public int getResidualHeatAfterProduce() {
        return ExtraBotanyConfig.common().reikarlilyPassiveGenerateTime();
    }

    public int getResidualHeatProduceMana() {
        return ExtraBotanyConfig.common().reikarlilyPassiveGenerateMana();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().reikarlilyMaxMana();
    }

    public int getColor() {
        return 205;
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.getCooldown());
        cmp.m_128405_(TAG_RESIDUAL_HEAT, this.getResidualHeat());
        cmp.m_128405_(TAG_SPAWN_LIGHTNING_COOLDOWN, this.getSpawnLightningCooldown());
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setCooldown(cmp.m_128451_(TAG_COOLDOWN));
        this.setResidualHeat(cmp.m_128451_(TAG_RESIDUAL_HEAT));
        this.setSpawnLightningCooldown(cmp.m_128451_(TAG_SPAWN_LIGHTNING_COOLDOWN));
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)4);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getResidualHeat() {
        return this.residualHeat;
    }

    public void setResidualHeat(int heat) {
        this.residualHeat = heat;
    }

    public int getSpawnLightningCooldown() {
        return this.spawnLightningCooldown;
    }

    public void setSpawnLightningCooldown(int cooldown) {
        this.spawnLightningCooldown = cooldown;
    }
}

