/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.lounode.eventwrapper.EventsWrapper;
import io.github.lounode.eventwrapper.event.PlayLevelSoundEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class ResoncundBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_SOUND_HEARD = "soundHeard";
    private static final int RANGE = 4;
    private static final int CACHE_SIZE = 32;
    private static final int MAX_PRODUCE = 500;
    private static final int MIN_PRODUCE = 0;
    public static final int MAX_MANA = 1200;
    public static final int MANA_LOSS_PER_HEARD = 50;
    private final LoadingCache<SoundEvent, Integer> SOUND_HEARD = CacheBuilder.newBuilder().maximumSize((long)this.getCacheSize()).expireAfterAccess(30L, TimeUnit.SECONDS).build(CacheLoader.from(() -> 0));

    public ResoncundBlockEntity(BlockPos pos, BlockState blockState) {
        super(ExtrabotanyFlowerBlocks.RESONCUND, pos, blockState);
        EventsWrapper.register((Object)((Object)this));
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
    }

    public void onSoundHeard(SoundEvent soundEvent) {
        int count = (Integer)this.SOUND_HEARD.getUnchecked((Object)soundEvent);
        if (count > 0x7FFFFFFE) {
            count = 0;
        }
        int produce = this.getMaxProduce();
        produce -= this.getSoundHeard().get(soundEvent) * this.getLossPerHeard();
        produce = Math.max(this.getMinProduce(), produce);
        this.addMana(produce);
        this.SOUND_HEARD.put((Object)soundEvent, (Object)(count + 1));
    }

    public int getLossPerHeard() {
        return ExtraBotanyConfig.common().resoncundLossPerHeard();
    }

    public int getMinProduce() {
        return 0;
    }

    public int getMaxProduce() {
        return 500;
    }

    public int getCacheSize() {
        return 32;
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().resoncundMaxMana();
    }

    public int getColor() {
        return 16076207;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)4);
    }

    public Map<SoundEvent, Integer> getSoundHeard() {
        return this.SOUND_HEARD.asMap();
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        CompoundTag sounds = new CompoundTag();
        for (Map.Entry<SoundEvent, Integer> entry : this.getSoundHeard().entrySet()) {
            SoundEvent sound = entry.getKey();
            int heards = entry.getValue();
            sounds.m_128405_(sound.m_11660_().toString(), heards);
        }
        cmp.m_128365_(TAG_SOUND_HEARD, (Tag)sounds);
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        CompoundTag sounds = cmp.m_128469_(TAG_SOUND_HEARD);
        ConcurrentHashMap soundHeard = new ConcurrentHashMap();
        for (String key : sounds.m_128431_()) {
            if (soundHeard.size() >= this.getCacheSize()) break;
            ResourceLocation res = ResourceLocation.m_135820_((String)key);
            int heards = sounds.m_128451_(key);
            if (heards < 0) continue;
            BuiltInRegistries.f_256894_.m_6612_(res).ifPresent(soundEvent -> soundHeard.put(soundEvent, heards));
        }
        this.SOUND_HEARD.invalidateAll();
        this.SOUND_HEARD.putAll(soundHeard);
    }

    @SubscribeEventWrapper
    public void onPlayLevelSound(PlayLevelSoundEventWrapper.AtPosition event) {
        if (this.m_58904_() == null) {
            return;
        }
        if (this.m_58904_().m_5776_()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (this.m_58901_()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (event.getSound() == null) {
            return;
        }
        AABB aabb = new AABB(this.getEffectivePos()).m_82400_(4.0);
        if (aabb.m_82390_(event.getPosition())) {
            this.onSoundHeard((SoundEvent)event.getSound().m_203334_());
        }
    }

    @SubscribeEventWrapper
    public void onPlayLevelSound(PlayLevelSoundEventWrapper.AtEntity event) {
        if (this.m_58904_() == null) {
            return;
        }
        if (this.m_58904_().m_5776_()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (this.m_58901_()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (event.getSound() == null) {
            return;
        }
        AABB aabb = new AABB(this.getEffectivePos()).m_82400_(4.0);
        if (aabb.m_82390_(event.getEntity().m_20182_())) {
            this.onSoundHeard((SoundEvent)event.getSound().m_203334_());
        }
    }
}

