/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.recipe.StonesiaRecipe;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class StonesiaBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final int RANGE = 1;
    public static final int MAX_MANA = 3200;
    public static final int COOLDOWN = 40;
    private int cooldown;

    public StonesiaBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.STONESIA, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
            return;
        }
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        BlockPos eatPos = this.getRadomBlockPos();
        int mana = this.getManaFormBlock(this.m_58904_().m_8055_(eatPos));
        if (mana > 0) {
            this.setCooldown(this.getAfterWorkCooldown());
            this.m_58904_().m_46961_(eatPos, false);
            this.addMana(mana);
            this.sync();
            this.m_58904_().m_5594_(null, this.getEffectivePos(), SoundEvents.f_11911_, SoundSource.BLOCKS, 0.01f, 0.5f + (float)Math.random() * 0.5f);
        }
    }

    public int getManaFormBlock(BlockState state) {
        for (Recipe recipe : ExtraBotanyRecipeTypes.getRecipes(this.m_58904_(), ExtraBotanyRecipeTypes.STONESIA_RECIPE_TYPE).values()) {
            StonesiaRecipe recipe2;
            if (!(recipe instanceof StonesiaRecipe) || !(recipe2 = (StonesiaRecipe)recipe).getInput().test(state)) continue;
            return recipe2.getManaOutput();
        }
        return 0;
    }

    public BlockPos getRadomBlockPos() {
        BlockPos result = null;
        while (result == null || result.equals((Object)this.getEffectivePos())) {
            result = (BlockPos)BlockPos.m_235641_((RandomSource)this.m_58904_().m_213780_(), (int)1, (int)(this.getEffectivePos().m_123341_() - 1), (int)this.getEffectivePos().m_123342_(), (int)(this.getEffectivePos().m_123343_() - 1), (int)(this.getEffectivePos().m_123341_() + 1), (int)(this.getEffectivePos().m_123342_() + 1), (int)(this.getEffectivePos().m_123343_() + 1)).iterator().next();
        }
        return result;
    }

    public int getAfterWorkCooldown() {
        return ExtraBotanyConfig.common().stonesiaCooldown();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().stonesiaMaxMana();
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getColor() {
        return 0x778899;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)1);
    }

    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.setCooldown(cmp.m_128451_(TAG_COOLDOWN));
    }

    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128405_(TAG_COOLDOWN, this.getCooldown());
    }
}

