/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.data.AdvancementProvider;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.helper.PlayerHelper;

public class TinkleBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_TIME = "time";
    public static final int MAX_MANA = 1000;
    private static final int RANGE = 8;
    private static final int COOLDOWN = 20;
    private static final int PRODUCE_REQUIRE = 10;
    public static final int PRODUCE_MANA = 100;
    private int time;

    public TinkleBlockEntity(BlockPos pos, BlockState state) {
        super(ExtrabotanyFlowerBlocks.TINKLE, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().m_5776_()) {
            return;
        }
        if (this.ticksExisted % 20 != 0) {
            return;
        }
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        List<Player> players = this.m_58904_().m_45976_(Player.class, this.getCheckAABB()).stream().filter(PlayerHelper::isTruePlayer).toList();
        for (Player player : players) {
            double vx = player.m_20185_() - player.f_19790_;
            double vy = player.m_20186_() - player.f_19791_;
            double vz = player.m_20189_() - player.f_19792_;
            double vel = Math.max(player.m_20184_().m_82556_(), Math.sqrt(vx * vx + vy * vy + vz * vz));
            if (player.m_21023_(MobEffects.f_19596_)) {
                vel *= (double)1.2f;
            }
            int timeAdd = Mth.m_14045_((int)((int)(vel * 100.0)), (int)0, (int)8);
            this.time += timeAdd;
            if (this.time < 10) continue;
            this.addMana(this.getProduceMana());
            player.m_36399_(0.02f);
            PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/project_diva_desu"), (String)AdvancementProvider.CODE_TRIGGE);
            this.time = 0;
            this.sync();
        }
    }

    public int getProduceMana() {
        return ExtraBotanyConfig.common().tinkleProduceMana();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().tinkleMaxMana();
    }

    public int getColor() {
        return 0xCCFF00;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((BlockPos)this.getEffectivePos(), (int)8);
    }

    public AABB getCheckAABB() {
        return new AABB(this.getEffectivePos()).m_82400_(8.0);
    }
}

