/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.api.recipe.EntityIngredient;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;

public class EntityTypeIngredient
implements EntityIngredient {
    protected final ImmutableSet<EntityType<?>> entityTypes;

    public EntityTypeIngredient(Collection<EntityType<?>> entityTypes) {
        this.entityTypes = ImmutableSet.copyOf(entityTypes);
    }

    @Override
    public boolean test(EntityType<?> entityType) {
        return this.entityTypes.contains(entityType);
    }

    @Override
    public EntityType<?> pick(RandomSource random) {
        return (EntityType)this.entityTypes.asList().get(random.m_188503_(this.entityTypes.size()));
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "entities");
        JsonArray array = new JsonArray();
        for (EntityType type : this.entityTypes) {
            array.add(BuiltInRegistries.f_256780_.m_7981_((Object)type).toString());
        }
        object.add("entities", (JsonElement)array);
        return object;
    }

    @Override
    public void write(FriendlyByteBuf buffer) {
        List<EntityType<?>> entities = this.getEntities();
        buffer.m_130130_(0);
        buffer.m_130130_(entities.size());
        for (EntityType<?> type : entities) {
            buffer.m_130130_(BuiltInRegistries.f_256780_.m_7447_(type));
        }
    }

    @Override
    public List<EntityType<?>> getDisplayed() {
        return this.entityTypes.stream().toList();
    }

    public List<EntityType<?>> getEntities() {
        return this.entityTypes.asList();
    }

    public String toString() {
        return "EntityTypeIngredient{" + String.valueOf(this.entityTypes) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entityTypes.equals(((EntityTypeIngredient)o).entityTypes);
    }

    public int hashCode() {
        return Objects.hash(this.entityTypes);
    }
}

