/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.crafting;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PedestalsRecipe
implements PedestalRecipe {
    private final ResourceLocation id;
    private final ItemStack output;
    private final Ingredient smashTools;
    private final Ingredient input;
    private final int strike;
    private final int exp;

    public PedestalsRecipe(ResourceLocation id, ItemStack output, Ingredient smashTools, Ingredient input, int strike, int exp) {
        this.id = id;
        this.output = output;
        this.input = input;
        this.smashTools = smashTools;
        this.strike = strike;
        this.exp = exp;
    }

    public boolean m_5818_(Container container, Level world) {
        ItemStack inputStack = container.m_8020_(0);
        return this.input.test(inputStack);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.output;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Override
    public Ingredient getSmashTools() {
        return this.smashTools;
    }

    @Override
    public Ingredient getInput() {
        return this.input;
    }

    @Override
    public ItemStack getOutput() {
        return this.output;
    }

    @Override
    public int getStrike() {
        return this.strike;
    }

    @Override
    public int getExp() {
        return this.exp;
    }

    @NotNull
    public RecipeType<? extends PedestalRecipe> m_6671_() {
        return ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE;
    }

    public RecipeSerializer<?> m_7707_() {
        return ExtraBotanyRecipeTypes.PEDESTAL_SMASH_SERIALIZER;
    }

    public static class Serializer
    implements RecipeSerializer<PedestalsRecipe> {
        @NotNull
        public PedestalsRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"output"));
            Ingredient input = Ingredient.m_43917_((JsonElement)json.get("input"));
            Ingredient smashTools = Ingredient.m_43917_((JsonElement)json.get("smash_tools"));
            int strike = json.get("strike").getAsInt();
            int exp = json.get("exp").getAsInt();
            return new PedestalsRecipe(id, output, smashTools, input, strike, exp);
        }

        @Nullable
        public PedestalsRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
            Ingredient smashTools = Ingredient.m_43940_((FriendlyByteBuf)buf);
            Ingredient input = Ingredient.m_43940_((FriendlyByteBuf)buf);
            ItemStack output = buf.m_130267_();
            int strike = buf.readInt();
            int exp = buf.readInt();
            return new PedestalsRecipe(id, output, smashTools, input, strike, exp);
        }

        public void toNetwork(@NotNull FriendlyByteBuf buf, @NotNull PedestalsRecipe recipe) {
            recipe.smashTools.m_43923_(buf);
            recipe.input.m_43923_(buf);
            buf.m_130055_(recipe.output);
            buf.writeInt(recipe.strike);
            buf.writeInt(recipe.exp);
        }
    }
}

