/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity;

import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.MagicLandMineEntity;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import vazkii.botania.client.fx.WispParticleData;

public abstract class SkullLandMineEntity
extends MagicLandMineEntity {
    private static final ResourceLocation DEFAULT_SKULL = ResourceLocationHelper.prefix("textures/entity/skull_missile/skull_missile.png");
    public static final float LANDMINE_WIDTH = 5.0f;

    public SkullLandMineEntity(EntityType<? extends SkullLandMineEntity> type, Level level) {
        super(type, level);
    }

    @Override
    protected void particle() {
        float range = 2.5f;
        float r = 0.2f;
        float g = 0.0f;
        float b = 0.2f;
        for (int i = 0; i < 6; ++i) {
            WispParticleData data = WispParticleData.wisp((float)0.4f, (float)r, (float)g, (float)b, (float)1.0f);
            this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_() - (double)range + Math.random() * (double)range * 2.0, this.m_20186_(), this.m_20189_() - (double)range + Math.random() * (double)range * 2.0, 0.0, (double)0.015f, 0.0);
        }
    }

    @Override
    public List<? extends LivingEntity> getVictims(Class<? extends LivingEntity> entityClass) {
        return this.m_9236_().m_45976_(entityClass, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82400_(2.5));
    }

    public ResourceLocation getTexture() {
        return DEFAULT_SKULL;
    }

    public static class Disarm
    extends SkullLandMineEntity {
        public static final ResourceLocation SKULL = ResourceLocationHelper.prefix("textures/entity/skull_landmine/green.png");

        public Disarm(EntityType<? extends Disarm> type, Level level) {
            super((EntityType<? extends SkullLandMineEntity>)type, level);
        }

        public Disarm(Level level, Entity owner) {
            super((EntityType<? extends SkullLandMineEntity>)ExtraBotanyEntityType.SKULL_LANDMINE_GREEN, level);
            this.setOwner(owner);
        }

        @Override
        public void explode() {
            super.explode();
            if (ExtraBotanyConfig.common().disableGaiaDisArm()) {
                return;
            }
            List<Player> players = this.getVictimPlayers();
            for (Player player : players) {
                if (player.m_5833_() || player.m_7500_()) continue;
                ItemStack itemStack = player.m_21120_(InteractionHand.MAIN_HAND).m_41777_();
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                player.m_7197_(itemStack, false, true);
            }
        }

        @Override
        public ResourceLocation getTexture() {
            return SKULL;
        }

        @Override
        protected void particle() {
            float range = 2.5f;
            float r = 0.2f;
            float g = 0.6f;
            float b = 0.2f;
            for (int i = 0; i < 6; ++i) {
                WispParticleData data = WispParticleData.wisp((float)0.4f, (float)r, (float)g, (float)b, (float)0.5f);
                this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_() - (double)range + Math.random() * (double)range * 2.0, this.m_20186_(), this.m_20189_() - (double)range + Math.random() * (double)range * 2.0, 0.0, (double)0.015f, 0.0);
            }
        }
    }

    public static class Danger
    extends SkullLandMineEntity {
        public static final ResourceLocation SKULL = ResourceLocationHelper.prefix("textures/entity/skull_landmine/red.png");

        public Danger(EntityType<? extends Danger> type, Level level) {
            super((EntityType<? extends SkullLandMineEntity>)type, level);
        }

        public Danger(Level level, Entity owner) {
            super((EntityType<? extends SkullLandMineEntity>)ExtraBotanyEntityType.SKULL_LANDMINE_RED, level);
            this.setOwner(owner);
        }

        @Override
        public ResourceLocation getTexture() {
            return SKULL;
        }

        @Override
        protected void particle() {
            float range = 2.5f;
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            for (int i = 0; i < 6; ++i) {
                WispParticleData data = WispParticleData.wisp((float)0.4f, (float)r, (float)g, (float)b, (float)0.5f);
                this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_() - (double)range + Math.random() * (double)range * 2.0, this.m_20186_(), this.m_20189_() - (double)range + Math.random() * (double)range * 2.0, 0.0, (double)0.015f, 0.0);
            }
        }
    }

    public static class Default
    extends SkullLandMineEntity {
        public static final ResourceLocation SKULL = ResourceLocationHelper.prefix("textures/entity/skull_landmine/blue.png");

        public Default(EntityType<? extends Default> type, Level level) {
            super((EntityType<? extends SkullLandMineEntity>)type, level);
        }

        public Default(Level level, Entity owner) {
            super((EntityType<? extends SkullLandMineEntity>)ExtraBotanyEntityType.SKULL_LANDMINE_BLUE, level);
            this.setOwner(owner);
        }

        @Override
        public ResourceLocation getTexture() {
            return SKULL;
        }

        @Override
        protected void particle() {
            float range = 2.5f;
            float r = 0.2f;
            float g = 0.0f;
            float b = 0.6f;
            for (int i = 0; i < 6; ++i) {
                WispParticleData data = WispParticleData.wisp((float)0.4f, (float)r, (float)g, (float)b, (float)0.5f);
                this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_() - (double)range + Math.random() * (double)range * 2.0, this.m_20186_(), this.m_20189_() - (double)range + Math.random() * (double)range * 2.0, 0.0, (double)0.015f, 0.0);
            }
        }
    }
}

