/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Dynamic;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaCleanPlayerUnstableEffects;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaEmerging;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSmashBlocksAround;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnLandMine;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnMissile;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnMob;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnPixies;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaTeleport;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.schedule.Activity;

public class GaiaAI {
    public static final int EMERGE_TIME = 160;
    protected static final int TELEPORT_DELAY_INITIAL = 30;
    protected static final int TELEPORT_DELAY = 35;
    protected static final float TELEPORT_RANGE = 12.0f;
    protected static final int LANDMINE_COUNTS = 6;
    protected static final int PIXIES_PRE_SPAWN_MAX = 6;
    protected static final float MOB_SPAWN_THRESHOLD = 0.2f;
    public static final int MOB_SPAWN_START_TICKS = 20;
    public static final int MOB_SPAWN_END_TICKS = 80;
    protected static final int MOB_SPAWN_BASE_TICKS = 800;
    public static final int MOB_SPAWN_TICKS = 900;
    public static final int MOB_SPAWN_WAVES = 10;
    public static final int MOB_SPAWN_WAVE_TIME = 80;
    protected static final List<SensorType<? extends Sensor<? super Gaia>>> SENSOR_TYPES = List.of(SensorType.f_26812_, SensorType.f_26814_);
    protected static final List<MemoryModuleType<?>> MEMORY_TYPES = List.of(MemoryModuleType.f_148204_, MemoryModuleType.f_217786_, MemoryModuleType.f_26370_, MemoryModuleType.f_26371_, ExtraBotanyMemoryType.TELEPORT_RANGE, ExtraBotanyMemoryType.TELEPORT_DELAY, ExtraBotanyMemoryType.TELEPORT_DELAY_BASE, ExtraBotanyMemoryType.LANDMINE_COUNT, ExtraBotanyMemoryType.PIXIES_MAX, ExtraBotanyMemoryType.MOB_SPAWN_TICKS, MemoryModuleType.f_26367_, MemoryModuleType.f_26368_, MemoryModuleType.f_148206_, MemoryModuleType.f_26381_);

    public static void updateActivity(Gaia gaia) {
        boolean isNotEmerging = !gaia.m_6274_().m_21954_(Activity.f_219852_);
        boolean lowHealth = gaia.m_21223_() / gaia.m_21233_() <= 0.2f;
        boolean hasSpawnTicks = gaia.m_6274_().m_21874_(ExtraBotanyMemoryType.MOB_SPAWN_TICKS);
        if (isNotEmerging && lowHealth && hasSpawnTicks) {
            gaia.m_6274_().m_21889_(Activity.f_37985_);
        } else {
            gaia.m_6274_().m_21926_((List)ImmutableList.of((Object)Activity.f_219852_, (Object)Activity.f_37988_));
        }
    }

    protected static Brain<?> makeBrain(Gaia gaia, Dynamic<?> ops) {
        Brain.Provider provider = Brain.m_21923_(MEMORY_TYPES, SENSOR_TYPES);
        Brain brain = provider.m_22073_(ops);
        GaiaAI.initCoreActivity((Brain<? extends Gaia>)brain);
        GaiaAI.initSpawnActivity((Brain<? extends Gaia>)brain, 160);
        GaiaAI.initMobSpawnActivity((Brain<? extends Gaia>)brain, 900);
        GaiaAI.initFightActivity((Brain<? extends Gaia>)brain);
        brain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        brain.m_21944_(Activity.f_219852_);
        brain.m_21962_();
        return brain;
    }

    protected static void initMemories(Gaia gaia, ServerLevel level, BlockPos pos) {
        GaiaTeleport.initMemories(gaia.m_6274_(), 12.0f, 35, 30);
        GaiaSpawnLandMine.initMemories(gaia.m_6274_(), 6);
        GaiaSpawnPixies.initMemories(gaia.m_6274_(), 6);
        gaia.m_6274_().m_21882_(ExtraBotanyMemoryType.MOB_SPAWN_TICKS, (Object)900, 900L);
    }

    protected static void initCoreActivity(Brain<? extends Gaia> brain) {
        brain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new Swim(0.8f)));
    }

    protected static void initSpawnActivity(Brain<? extends Gaia> brain, int emergeTime) {
        brain.m_21895_(Activity.f_219852_, 1, ImmutableList.of(new GaiaEmerging(emergeTime)), MemoryModuleType.f_217786_);
    }

    private static void initFightActivity(Brain<? extends Gaia> brain) {
        brain.m_21891_(Activity.f_37988_, 10, ImmutableList.of(new GaiaTeleport(), new GaiaSpawnMissile(), new GaiaSpawnLandMine(), new GaiaSpawnPixies(), new GaiaSmashBlocksAround(), new GaiaCleanPlayerUnstableEffects()));
    }

    private static void initMobSpawnActivity(Brain<? extends Gaia> brain, int spawnTicks) {
        brain.m_21895_(Activity.f_37985_, 5, ImmutableList.of(new GaiaSpawnMob(spawnTicks)), ExtraBotanyMemoryType.MOB_SPAWN_TICKS);
    }
}

