/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ServerLevelAccessor;
import vazkii.botania.common.entity.PixieEntity;

public class GaiaSpawnPixies<E extends Gaia>
extends Behavior<E> {
    public GaiaSpawnPixies() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26367_, (Object)MemoryStatus.VALUE_PRESENT, ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)MemoryStatus.VALUE_PRESENT, ExtraBotanyMemoryType.PIXIES_MAX, (Object)MemoryStatus.VALUE_PRESENT));
    }

    public static void initMemories(Brain<? extends Gaia> brain, int pixiesMax) {
        brain.m_21879_(ExtraBotanyMemoryType.PIXIES_MAX, (Object)pixiesMax);
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E gaia) {
        return this.getTeleportDelay((Gaia)((Object)gaia)) == 0;
    }

    protected void start(ServerLevel level, E gaia, long gameTime) {
        this.spawnPixies((Gaia)((Object)gaia));
    }

    protected void spawnPixies(Gaia gaia) {
        List<Player> players = this.getPlayers(gaia);
        for (int runTime = 0; runTime < players.size(); ++runTime) {
            int spawnCount = 1;
            if (gaia.f_20916_ > 0) {
                spawnCount = gaia.m_9236_().f_46441_.m_188503_(this.getPixiesMaxPerSpawn(gaia));
            }
            for (int i = 1; i <= spawnCount; ++i) {
                PixieEntity pixie = new PixieEntity(gaia.m_9236_());
                pixie.setProps((LivingEntity)players.get(gaia.m_217043_().m_188503_(players.size())), (LivingEntity)gaia, 1, 8.0f);
                pixie.m_6034_(gaia.m_20185_() + (double)(gaia.m_20205_() / 2.0f), gaia.m_20186_() + 2.0, gaia.m_20189_() + (double)(gaia.m_20205_() / 2.0f));
                pixie.m_6518_((ServerLevelAccessor)gaia.m_9236_(), gaia.m_9236_().m_6436_(pixie.m_20183_()), MobSpawnType.MOB_SUMMONED, null, null);
                gaia.m_9236_().m_7967_((Entity)pixie);
            }
        }
    }

    protected int getTeleportDelay(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.TELEPORT_DELAY).orElse(35);
    }

    protected List<Player> getPlayers(Gaia gaia) {
        return gaia.m_6274_().m_21952_(MemoryModuleType.f_26367_).orElse(new ArrayList());
    }

    protected int getPixiesMaxPerSpawn(Gaia gaia) {
        return gaia.m_6274_().m_21952_(ExtraBotanyMemoryType.PIXIES_MAX).orElse(1);
    }
}

