/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item;

import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.common.helper.ItemNBTHelper;

public class DasRheingoldItem
extends Item {
    private static final String TAG_SOULBIND_UUID = "soulbindUUID";

    public DasRheingoldItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6880_(ItemStack stack, Player player, LivingEntity interactionTarget, InteractionHand usedHand) {
        if (!(interactionTarget instanceof Player)) {
            return InteractionResult.PASS;
        }
        Player bindPlayer = (Player)interactionTarget;
        if (bindPlayer.m_6144_()) {
            return InteractionResult.PASS;
        }
        ItemStack out = stack.m_255036_(1);
        this.bindToUUID(out, bindPlayer.m_20148_());
        this.getSoulbindUUID(out);
        out.m_41714_((Component)Component.m_237115_((String)"item.extrabotany.das_rheingold.bind"));
        if (!player.m_36356_(out)) {
            return InteractionResult.PASS;
        }
        stack.m_41774_(1);
        return InteractionResult.SUCCESS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand usedHand) {
        ItemStack stack = player.m_21120_(usedHand);
        if (this.getSoulbindUUID(stack) == null) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        if (player.m_36341_()) {
            stack.m_41787_();
            ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltipComponents, TooltipFlag isAdvanced) {
        super.m_7373_(stack, level, tooltipComponents, isAdvanced);
        if (this.getSoulbindUUID(stack) != null) {
            tooltipComponents.add((Component)Component.m_237110_((String)"tooltip.extrabotany.bind", (Object[])new Object[]{this.getSoulbindUUID(stack)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    public void bindToUUID(ItemStack stack, UUID uuid) {
        ItemNBTHelper.setString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)uuid.toString());
    }

    @Nullable
    public UUID getSoulbindUUID(ItemStack stack) {
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)TAG_SOULBIND_UUID)) {
            try {
                return UUID.fromString(ItemNBTHelper.getString((ItemStack)stack, (String)TAG_SOULBIND_UUID, (String)""));
            }
            catch (IllegalArgumentException ex) {
                ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_SOULBIND_UUID);
            }
        }
        return null;
    }
}

