/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.armor.goblin_slayer;

import com.google.common.base.Suppliers;
import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.IPhotonium;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.equipment.armor.starry_idol.StarryIdolArmorItem;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.mana.ManaItemHandler;

public class GoblinSlayerArmorItem
extends StarryIdolArmorItem
implements IPhotonium {
    public static final Supplier<ItemStack[]> ARMOR_SET = Suppliers.memoize(() -> new ItemStack[]{new ItemStack((ItemLike)ExtraBotanyItems.goblinSlayerHelmet), new ItemStack((ItemLike)ExtraBotanyItems.goblinSlayerChestplate), new ItemStack((ItemLike)ExtraBotanyItems.goblinSlayerLeggings), new ItemStack((ItemLike)ExtraBotanyItems.goblinSlayerBoots)});

    public GoblinSlayerArmorItem(ArmorItem.Type type, Item.Properties properties) {
        this(ExtraBotanyAPI.instance().getGoblinSlayerArmorMaterial(), type, properties);
    }

    public GoblinSlayerArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Override
    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        this.photoniumTick(stack, world, entity, slot, selected);
    }

    @Override
    public void photoniumTick(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity living = (LivingEntity)entity;
        if (living.m_6844_(this.f_265916_.m_266308_()) != stack) {
            return;
        }
        if (living.f_19797_ % 60 == 0) {
            return;
        }
        if (living instanceof Player) {
            Player player = (Player)living;
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getPhotoniumBuffMana(), true)) {
                return;
            }
        }
        if (this.isDay(level) && this.isOutCave(level, entity.m_20183_())) {
            living.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, 1));
        }
    }

    @Override
    public boolean isOutCave(Level level, BlockPos pos) {
        return true;
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlot slot) {
        return "extrabotany:textures/models/armor/goblin_slayer.png";
    }

    @Override
    public MutableComponent getArmorSetName() {
        return Component.m_237115_((String)"extrabotany.armorset.goblin_slayer.name");
    }

    @Override
    public void addArmorSetDescription(ItemStack stack, List<Component> list, boolean hasArmorSet) {
        list.add((Component)Component.m_237115_((String)"extrabotany.armorset.goblin_slayer.desc0").m_130940_(hasArmorSet ? ChatFormatting.DARK_RED : ChatFormatting.GRAY));
    }

    @Override
    public boolean hasArmorSetItem(Player player, EquipmentSlot slot) {
        if (player == null || player.m_150109_() == null || player.m_150109_().f_35975_ == null) {
            return false;
        }
        ItemStack stack = player.m_6844_(slot);
        if (stack.m_41619_()) {
            return false;
        }
        return switch (slot) {
            case EquipmentSlot.HEAD -> stack.m_150930_(ExtraBotanyItems.goblinSlayerHelmet);
            case EquipmentSlot.CHEST -> stack.m_150930_(ExtraBotanyItems.goblinSlayerChestplate);
            case EquipmentSlot.LEGS -> stack.m_150930_(ExtraBotanyItems.goblinSlayerLeggings);
            case EquipmentSlot.FEET -> stack.m_150930_(ExtraBotanyItems.goblinSlayerBoots);
            default -> false;
        };
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return ARMOR_SET.get();
    }

    public static boolean isGoblin(Entity entity) {
        return entity.m_6095_().m_204039_(ExtraBotanyTags.Entities.GOBLINS);
    }
}

