/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.bauble;

import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class CurseRingItem
extends BaubleItem {
    private static final int RANGE = 6;
    private static final int CURSE_COST = 50;
    private static final int CURSE_COOLDOWN = 30;

    public CurseRingItem(Item.Properties props) {
        super(props);
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
        super.onWornTick(stack, entity);
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)entity;
        if (serverPlayer.f_19797_ % this.getCurseCooldown() != 0) {
            return;
        }
        List<LivingEntity> entities = serverPlayer.m_9236_().m_45976_(LivingEntity.class, serverPlayer.m_20191_().m_82400_((double)this.getRange())).stream().filter(e -> e != entity).toList();
        for (LivingEntity victim : entities) {
            if (!CurseRingItem.isLookingAt(entity, victim) || !ManaItemHandler.INSTANCE.requestManaExactForTool(stack, (Player)serverPlayer, this.getCurseCost(), true)) continue;
            this.curseEntity(victim, (LivingEntity)serverPlayer);
        }
    }

    public void curseEntity(LivingEntity victim, LivingEntity source) {
        victim.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 60, 1));
        victim.m_7292_(new MobEffectInstance(MobEffects.f_19590_, 60, 1));
    }

    private static boolean isLookingAt(LivingEntity from, LivingEntity toCheck) {
        Vec3 vec3 = from.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(toCheck.m_20185_() - from.m_20185_(), toCheck.m_20188_() - from.m_20188_(), toCheck.m_20189_() - from.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - 0.025 / d0 && from.m_142582_((Entity)toCheck);
    }

    public int getCurseCooldown() {
        return 30;
    }

    public int getCurseCost() {
        return 50;
    }

    public int getRange() {
        return 6;
    }
}

