/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.bauble;

import io.github.lounode.eventwrapper.event.entity.player.PlayerInteractEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.item.NatureEnergyItem;
import io.github.lounode.extrabotany.common.entity.gaia.GaiaIII;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

@EventBusSubscriberWrapper
public class NatureOrbItem
extends BaubleItem
implements CustomCreativeTabContents {
    public static final long MAX_ENERGY = 500000L;
    public static final int SPAWN_GAIAIII_COST = 200000;
    public static final int TIER_1_ENERGY = 100000;
    public static final int TIER_2_ENERGY = 200000;
    public static final int TIER_3_ENERGY = 300000;
    public static final int TIER_4_ENERGY = 400000;
    public static final int MANA_GENERATE_ADDITION_PER_TIER = 1;
    public static final int HEAL_DELAY = 60;
    public static final float HEAL_AMOUNT = 1.0f;
    public static final int REMOVE_HARMFUL_POTION_DELAY = 40;
    public static final int REMOVE_HARMFUL_POTION_COST = 200;
    private static final String TAG_ENERGY = "NatureEnergy";

    public NatureOrbItem(Item.Properties properties) {
        super(properties);
    }

    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)this);
        ItemStack fullPower = new ItemStack((ItemLike)this);
        NatureOrbItem.setEnergy(fullPower, 500000L);
        output.m_246342_(fullPower);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockPos pos = context.m_8083_();
        Level level = context.m_43725_();
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof BeaconBlockEntity) {
            return InteractionResult.CONSUME;
        }
        return super.m_6225_(context);
    }

    @SubscribeEventWrapper
    public static void onPlayerInteract(PlayerInteractEventWrapper.RightClickBlock event) {
        Item item;
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        ItemStack handItem = event.getItemStack();
        ItemStack equipItem = EquipmentHandler.findOrEmpty((Item)ExtraBotanyItems.natureOrb, (LivingEntity)player);
        InteractionHand hand = event.getHand();
        Level level = player.m_9236_();
        BlockEntity tile = level.m_7702_(pos);
        if (!player.m_6144_()) {
            return;
        }
        ItemStack finalItem = handItem;
        if (handItem.m_41619_() && hand == InteractionHand.OFF_HAND) {
            finalItem = equipItem;
        }
        if (tile instanceof BeaconBlockEntity && (item = finalItem.m_41720_()) instanceof NatureOrbItem) {
            NatureOrbItem orb = (NatureOrbItem)item;
            NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(finalItem);
            if (natureItem == null || natureItem.getEnergy() < (long)orb.getSpawnGaiaCost()) {
                return;
            }
            if (GaiaIII.spawn(player, finalItem, level, pos)) {
                if (!level.m_5776_()) {
                    natureItem.addEnergy(-orb.getSpawnGaiaCost());
                    event.setCanceled(true);
                }
                player.m_6674_(hand);
            }
        }
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        if (natureItem == null) {
            return;
        }
        if (NatureOrbItem.getTier(stack) >= 1) {
            ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
        }
        if (NatureOrbItem.getTier(stack) >= 2) {
            ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
        }
        if (NatureOrbItem.getTier(stack) >= 3) {
            ManaItemHandler.instance().dispatchManaExact(stack, player, 1, true);
            if (player.f_19797_ % 60 == 0) {
                player.m_5634_(1.0f);
            }
        }
        if (NatureOrbItem.getTier(stack) >= 4) {
            if (player.f_19797_ % 40 != 0) {
                return;
            }
            int removeCount = NatureOrbItem.clearHarmfulPotion((LivingEntity)player);
            if (removeCount > 0) {
                natureItem.addEnergy(-200L * (long)removeCount);
            }
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.extrabotany.nature_orb.tier1").m_130940_(NatureOrbItem.getTier(stack) >= 1 ? ChatFormatting.AQUA : ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.extrabotany.nature_orb.tier2").m_130940_(NatureOrbItem.getTier(stack) >= 3 ? ChatFormatting.RED : ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.extrabotany.nature_orb.tier3").m_130940_(NatureOrbItem.getTier(stack) >= 4 ? ChatFormatting.GREEN : ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237110_((String)"tooltip.extrabotany.nature_orb.energy", (Object[])new Object[]{natureItem.getEnergy() + "/" + natureItem.getMaxEnergy()}).m_130940_(ChatFormatting.GRAY));
    }

    public static int getTier(ItemStack stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        if (natureItem == null) {
            return -1;
        }
        long energy = natureItem.getEnergy();
        if (energy > 400000L) {
            return 4;
        }
        if (energy > 300000L) {
            return 3;
        }
        if (energy > 200000L) {
            return 2;
        }
        if (energy > 100000L) {
            return 1;
        }
        return 0;
    }

    public static int clearHarmfulPotion(LivingEntity entity) {
        List<MobEffectInstance> effects = entity.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).toList();
        effects.forEach(e -> entity.m_21195_(e.m_19544_()));
        return effects.size();
    }

    public int getSpawnGaiaCost() {
        return 200000;
    }

    protected static void setEnergy(ItemStack stack, long energy) {
        if (energy > 0L) {
            ItemNBTHelper.setLong((ItemStack)stack, (String)TAG_ENERGY, (long)energy);
        } else {
            ItemNBTHelper.removeEntry((ItemStack)stack, (String)TAG_ENERGY);
        }
    }

    public int m_142159_(ItemStack stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        return Mth.m_14169_((float)((float)natureItem.getEnergy() / (float)natureItem.getMaxEnergy() / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int m_142158_(ItemStack stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        return Math.round(13.0f * ((float)natureItem.getEnergy() / (float)natureItem.getMaxEnergy()));
    }

    public boolean m_142522_(ItemStack stack) {
        NatureEnergyItem natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(stack);
        return natureItem.getEnergy() < natureItem.getMaxEnergy();
    }

    public static class NatureEnergyImpl
    implements NatureEnergyItem {
        private final ItemStack stack;

        public NatureEnergyImpl(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public long getEnergy() {
            return ItemNBTHelper.getLong((ItemStack)this.stack, (String)NatureOrbItem.TAG_ENERGY, (long)0L) * (long)this.stack.m_41613_();
        }

        @Override
        public long getMaxEnergy() {
            return 500000L * (long)this.stack.m_41613_();
        }

        @Override
        public boolean addEnergy(long energy) {
            long current = this.getEnergy() / (long)this.stack.m_41613_();
            long maxSingle = this.getMaxEnergy() / (long)this.stack.m_41613_();
            long newEnergy = energy > 0L && current > maxSingle - energy ? maxSingle : (energy < 0L && current < -energy ? 0L : current + energy);
            newEnergy = Math.min(newEnergy, maxSingle);
            newEnergy = Math.max(newEnergy, 0L);
            NatureOrbItem.setEnergy(this.stack, newEnergy);
            return newEnergy != current;
        }
    }
}

