/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.bauble;

import io.github.lounode.eventwrapper.event.entity.player.PlayerInteractEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.util.PlayerUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.api.recipe.PureDaisyRecipe;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;

public class PureDaisyPendantItem
extends BaubleItem {
    public static int TRANSFORM_MANA = 50;

    public PureDaisyPendantItem(Item.Properties props) {
        super(props);
    }

    @EventBusSubscriberWrapper
    public static class EventHandler {
        @SubscribeEventWrapper
        public static void onPlayerInteract(PlayerInteractEventWrapper.RightClickBlock event) {
            Player player = event.getEntity();
            if (!(player instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (!serverPlayer.m_21205_().m_41619_()) {
                return;
            }
            BlockPos pos = event.getPos();
            Level level = event.getLevel();
            BlockState state = level.m_8055_(pos);
            ItemStack stack = EquipmentHandler.findOrEmpty(s -> s.m_41720_() instanceof PureDaisyPendantItem, (LivingEntity)serverPlayer);
            if (stack.m_41619_()) {
                return;
            }
            BlockState output = EventHandler.getDaisyRecipe(level, state);
            if (output == null) {
                return;
            }
            if (output.m_60713_(state.m_60734_())) {
                return;
            }
            if (!ManaItemHandler.instance().requestManaExactForTool(stack, (Player)serverPlayer, TRANSFORM_MANA, true)) {
                return;
            }
            if (PlayerUtil.tryBreakBlock((Player)serverPlayer, ItemStack.f_41583_, level, pos)) {
                level.m_46597_(pos, output.m_60734_().m_152465_(state));
                level.m_46796_(2001, pos, Block.m_49956_((BlockState)output));
                level.m_142346_(null, GameEvent.f_157792_, pos);
            }
        }

        @Nullable
        private static BlockState getDaisyRecipe(Level level, BlockState input) {
            for (Recipe r : BotaniaRecipeTypes.getRecipes((Level)level, (RecipeType)BotaniaRecipeTypes.PURE_DAISY_TYPE).values()) {
                PureDaisyRecipe recipe;
                if (!(r instanceof PureDaisyRecipe) || !(recipe = (PureDaisyRecipe)r).getInput().test(input)) continue;
                return recipe.getOutputState();
            }
            return null;
        }
    }
}

