/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.shield;

import io.github.lounode.eventwrapper.event.entity.living.ShieldBlockEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import java.util.function.Consumer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.SortableTool;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.equipment.CustomDamageItem;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ManasteelShieldItem
extends ShieldItem
implements CustomDamageItem,
SortableTool {
    private static final int MANA_PER_DAMAGE = 60;
    private final Tier tier;

    public ManasteelShieldItem(Item.Properties properties, Tier tier) {
        super(properties.m_41499_((int)((float)tier.m_6609_() * 1.5f)));
        this.tier = tier;
    }

    public ManasteelShieldItem(Item.Properties properties) {
        this(properties, BotaniaAPI.instance().getManasteelItemTier());
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            if (stack.m_41773_() > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaPerDamage(), true)) {
                stack.m_41721_(stack.m_41773_() - 1);
            }
        }
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int manaPerDamage = ((ManasteelShieldItem)stack.m_41720_()).getManaPerDamage();
        return ToolCommons.damageItemIfPossible((ItemStack)stack, (int)amount, entity, (int)manaPerDamage);
    }

    public void onShieldBlock(ItemStack stack, LivingEntity blocker, DamageSource source, float damage) {
    }

    public int getManaPerDamage() {
        return 60;
    }

    public Tier getTier() {
        return this.tier;
    }

    public int m_6473_() {
        return this.getTier().m_6601_();
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return this.getTier().m_6282_().test(repair) || super.m_6832_(toRepair, repair);
    }

    public int getSortingPriority(ItemStack stack, BlockState state) {
        return ToolCommons.getToolPriority((ItemStack)stack);
    }

    @EventBusSubscriberWrapper
    public static class EventHandler {
        @SubscribeEventWrapper
        public static void onShieldBlockDamage(ShieldBlockEventWrapper event) {
            LivingEntity livingEntity = event.getEntity();
            if (!(livingEntity instanceof Player)) {
                return;
            }
            Player player = (Player)livingEntity;
            ItemStack stack = player.m_21211_();
            Item item = stack.m_41720_();
            if (item instanceof ManasteelShieldItem) {
                ManasteelShieldItem shieldItem = (ManasteelShieldItem)item;
                shieldItem.onShieldBlock(stack, event.getEntity(), event.getDamageSource(), event.getBlockedDamage());
            }
        }
    }
}

