/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.equipment.tool.hammer;

import io.github.lounode.extrabotany.common.item.equipment.tool.hammer.ManasteelHammerItem;
import java.util.function.Predicate;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class GaiaHammerItem
extends ManasteelHammerItem {
    private static final int MANA_PER_DAMAGE = 200;
    private static final float HEAVY_SMASH_SOUND_FALL_DISTANCE_THRESHOLD = 5.0f;
    public static final float KNOCKBACK_RANGE = 3.5f;
    private static final float KNOCKBACK_POWER = 1.3f;

    public GaiaHammerItem(Tier tier, int attackDamageModifier, float attackSpeedModifier, Item.Properties properties) {
        super(tier, attackDamageModifier, attackSpeedModifier, properties);
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!GaiaHammerItem.shouldDealAdditionalDamage(attacker)) {
            return super.m_7579_(stack, target, attacker);
        }
        Level level = attacker.m_9236_();
        attacker.m_20256_(attacker.m_20184_().m_193103_(Direction.Axis.Y, (double)0.01f));
        if (attacker instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)attacker;
            player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
        }
        if (target.m_20096_()) {
            SoundEvent soundEvent = SoundEvents.f_11668_;
            level.m_6263_(null, attacker.m_20185_(), attacker.m_20186_(), attacker.m_20189_(), soundEvent, attacker.m_5720_(), 1.0f, 1.0f);
        }
        this.knockbackNearbyEntities(level, (Entity)attacker, (Entity)target);
        return super.m_7579_(stack, target, attacker);
    }

    private void knockbackNearbyEntities(Level level, Entity attacker, Entity attacked) {
        if (attacker instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)attacker;
            serverPlayer.m_246865_(new Vec3(0.0, (double)this.getKnockbackPower(), 0.0));
            serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)serverPlayer));
        }
    }

    private static Predicate<LivingEntity> getKnockbackPredicate(Entity attacker, Entity attacked) {
        return entity -> {
            ArmorStand armorStand;
            boolean bl = !entity.m_5833_();
            boolean bl2 = entity != attacked;
            boolean bl3 = !attacker.m_7307_((Entity)entity);
            boolean bl4 = true;
            boolean bl5 = true;
            if (entity instanceof ArmorStand && (armorStand = (ArmorStand)entity).m_31677_()) {
                bl5 = false;
            }
            boolean bl6 = attacked.m_20280_((Entity)entity) <= Math.pow(3.5, 2.0);
            return bl && bl2 && bl3 && bl4 && bl5 && bl6;
        };
    }

    private void explode(Level level, Entity attacker, Entity attacked) {
    }

    private double getKnockback(Entity attacker, LivingEntity attacked, Vec3 distance) {
        return ((double)this.getKnockbackRange() - distance.m_82553_()) * (double)this.getKnockbackPower() * (double)(attacker.f_19789_ > this.getHeavySmashSoundFallDistanceThreshold() ? 2 : 1) * (1.0 - attacked.m_21133_(Attributes.f_22278_));
    }

    public float getKnockbackPower() {
        return 1.3f;
    }

    public float getKnockbackRange() {
        return 3.5f;
    }

    public float getHeavySmashSoundFallDistanceThreshold() {
        return 5.0f;
    }

    @Override
    public int getManaPerDamage() {
        return 200;
    }

    public static boolean shouldDealAdditionalDamage(LivingEntity attacker) {
        return (double)attacker.f_19789_ > 1.5 && !attacker.m_21255_();
    }
}

