/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic;

import io.github.lounode.extrabotany.api.entity.EntityNbtHelper;
import io.github.lounode.extrabotany.common.entity.MagicArrowEntity;
import io.github.lounode.extrabotany.common.item.enchantment.ICustomEnchantable;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.entity.ManaBurstEntity;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.equipment.tool.bow.LivingwoodBowItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.xplat.XplatAbstractions;

public class FailnaughtItem
extends LivingwoodBowItem
implements LensEffectItem,
ICustomEnchantable {
    private static final float ADVANCEMENT_REQUIRE = 100.0f;
    private static final float ATTACK_BOX_RADIUS = 2.0f;
    private static final int HIT_ENTITY_COST = 50;
    public static final float MINIMUM_SHOOT_PROCESS = 0.1f;
    public static final float[] TIER_PROCESS = new float[]{0.0f, 0.0f, 0.35f, 0.7f, 0.9f};
    public static final int[] MANA_PER_USE_MAX = new int[]{0, 350, 500, 650, 800};
    private static final List<Enchantment> SUPPORT_ENCHANTMENTS = Arrays.asList(Enchantments.f_44988_, Enchantments.f_44989_, Enchantments.f_44990_, Enchantments.f_44959_, Enchantments.f_44960_, Enchantments.f_44963_);
    private static final float DEFAULT_CHARGE_SPEED = 0.25f;
    private static final float QUICK_CHARGE_BONUS_PER_LEVEL = 0.1f;

    public FailnaughtItem(Item.Properties props) {
        super(props);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        int multiShoutLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemstack);
        float chargeProgress = this.getChargeProcess(itemstack, (LivingEntity)player);
        boolean flag = false;
        Relic relic = XplatAbstractions.INSTANCE.findRelic(itemstack);
        if (relic != null && relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExactForTool(itemstack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), false)) {
            flag = true;
        }
        if (!player.m_150110_().f_35937_ && !flag) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity livingEntity, int timeLeft) {
        if (world.m_5776_()) {
            return;
        }
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            float chargeProgress = this.getChargeProcess(stack, (LivingEntity)player);
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)stack);
            if (quickChargeLevel > 0) {
                ManaItemHandler.instance().requestManaExactForTool(stack, player, 100 * quickChargeLevel, true);
            }
            if (chargeProgress < 0.1f) {
                return;
            }
            int multiShoutLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)stack);
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null && relic.isRightPlayer(player) && (player.m_150110_().f_35937_ || ManaItemHandler.instance().requestManaExactForTool(stack, player, this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1), true))) {
                int manaInBurst = this.getManaForUse(chargeProgress) * (multiShoutLevel > 1 ? 3 : 1);
                float spreadAngle = 10.0f;
                for (int i = 0; i < (multiShoutLevel > 0 ? 3 : 1); ++i) {
                    ManaBurstEntity burst = this.getBurst(player, stack, manaInBurst, this.getTier(chargeProgress));
                    if (multiShoutLevel > 0 && i > 0) {
                        float angle = (i == 1 ? -spreadAngle : spreadAngle) * ((float)Math.PI / 180);
                        burst.m_20256_(burst.m_20184_().m_82524_(angle));
                    }
                    player.m_9236_().m_7967_((Entity)burst);
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), ExtraBotanySounds.FAILNAUGHT_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    public ManaBurstEntity getBurst(Player player, ItemStack stack, int mana, int tier) {
        MagicArrowEntity burst = new MagicArrowEntity(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(mana);
        burst.setStartingMana(mana);
        burst.setManaLossPerTick((float)MANA_PER_USE_MAX[tier] / 87.5f);
        burst.setGravity(0.0f);
        burst.m_20256_(burst.m_20184_().m_82490_((double)motionModifier));
        burst.setSourceLens(stack.m_41777_());
        float chargeProcess = this.getChargeProcess(stack, (LivingEntity)player);
        float tierProcess = this.getProcessInTier(chargeProcess);
        float baseDamage = 10.0f;
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
        if (powerLevel > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 50 * powerLevel, true)) {
            baseDamage = baseDamage + 0.5f + 0.5f * (float)powerLevel;
        }
        float damage = baseDamage * ((float)tier * tierProcess);
        burst.setDamage(damage);
        return burst;
    }

    public void apply(ItemStack stack, BurstProperties props, Level level) {
    }

    public boolean collideBurst(ManaBurst burst, HitResult pos, boolean isManaBlock, boolean shouldKill, ItemStack stack) {
        return shouldKill;
    }

    public void updateBurst(ManaBurst burst, ItemStack stack) {
        Player player;
        Entity thrower;
        ThrowableProjectile entity;
        block9: {
            block8: {
                entity = burst.entity();
                if (entity.m_9236_().m_5776_()) {
                    return;
                }
                thrower = entity.m_19749_();
                if (!(thrower instanceof Player)) break block8;
                player = (Player)thrower;
                if (thrower.m_6084_()) break block9;
            }
            entity.m_146870_();
            return;
        }
        AABB axis = new AABB(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.f_19790_, entity.f_19791_, entity.f_19792_).m_82400_(2.0);
        List<LivingEntity> entities = entity.m_9236_().m_45976_(LivingEntity.class, axis).stream().filter(e -> e != thrower).filter(e -> {
            Player other;
            return !(e instanceof Player && !player.m_7099_(other = (Player)e));
        }).filter(e -> e.f_20916_ == 0).toList();
        float chargeProcess = this.getChargeProcess(stack, (LivingEntity)player);
        int tier = this.getTier(chargeProcess);
        float tierProcess = this.getProcessInTier(chargeProcess);
        for (LivingEntity living : entities) {
            float fz;
            float fx;
            float horizontalDistanceSq;
            Skeleton skeleton;
            int mana = burst.getMana();
            if (mana < 50) {
                return;
            }
            burst.setMana(mana - 50);
            float damage = EntityNbtHelper.getNBT((Entity)entity).m_128457_("Damage");
            DamageSource source = player.m_269291_().m_269075_(player);
            living.m_6469_(source, damage);
            int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)stack);
            if (punchLevel > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 20 * punchLevel, true)) {
                living.m_147240_((double)((float)punchLevel * 0.5f), entity.m_20185_() - living.m_20185_(), entity.m_20189_() - living.m_20189_());
            }
            if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)stack) > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, 10, true)) {
                living.m_20254_(100);
            }
            if (!(living instanceof Skeleton) || (skeleton = (Skeleton)living).m_6084_() || !((horizontalDistanceSq = Mth.m_14116_((float)((fx = (float)(player.m_20185_() - living.m_20185_())) * fx + (fz = (float)(player.m_20189_() - living.m_20189_())) * fz))) > 100.0f)) continue;
            PlayerHelper.grantCriterion((ServerPlayer)((ServerPlayer)player), (ResourceLocation)ResourceLocationHelper.prefix("main/hundred_block_pierce"), (String)"code_triggered");
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public float chargeVelocityMultiplier(ItemStack itemStack, LivingEntity livingEntity) {
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            int quickChargeLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack);
            if (ManaItemHandler.instance().requestManaExactForTool(itemStack, player, 100 * quickChargeLevel, false)) {
                return 0.25f + 0.1f * (float)quickChargeLevel;
            }
        }
        return 0.25f;
    }

    public boolean doParticles(ManaBurst burst, ItemStack stack) {
        return true;
    }

    public float getChargeProcess(ItemStack stack, LivingEntity entity) {
        return Mth.m_14036_((float)((float)(this.m_8105_(stack) - entity.m_21212_()) * this.chargeVelocityMultiplier(stack, entity) / 20.0f), (float)0.0f, (float)1.0f);
    }

    public int getTier(float chargeProcess) {
        if ((chargeProcess = Mth.m_14036_((float)chargeProcess, (float)0.0f, (float)1.0f)) < TIER_PROCESS[2]) {
            return 1;
        }
        if (chargeProcess < TIER_PROCESS[3]) {
            return 2;
        }
        if (chargeProcess < TIER_PROCESS[4]) {
            return 3;
        }
        return 4;
    }

    public float getProcessInTier(float chargeProcess) {
        return switch (this.getTier(chargeProcess)) {
            case 1 -> chargeProcess / TIER_PROCESS[2];
            case 2 -> (chargeProcess - TIER_PROCESS[2]) / (TIER_PROCESS[3] - TIER_PROCESS[2]);
            case 3 -> (chargeProcess - TIER_PROCESS[3]) / (TIER_PROCESS[4] - TIER_PROCESS[3]);
            case 4 -> (chargeProcess - TIER_PROCESS[4]) / (1.0f - TIER_PROCESS[4]);
            default -> 0.0f;
        };
    }

    public int getManaForUse(float chargeProcess) {
        chargeProcess = Mth.m_14036_((float)chargeProcess, (float)0.0f, (float)1.0f);
        int tier = this.getTier(chargeProcess);
        float tierProcess = this.getProcessInTier(chargeProcess);
        return switch (tier) {
            case 1 -> (int)((float)MANA_PER_USE_MAX[1] * tierProcess);
            case 2 -> (int)((float)MANA_PER_USE_MAX[1] + (float)(MANA_PER_USE_MAX[2] - MANA_PER_USE_MAX[1]) * tierProcess);
            case 3 -> (int)((float)MANA_PER_USE_MAX[2] + (float)(MANA_PER_USE_MAX[3] - MANA_PER_USE_MAX[2]) * tierProcess);
            case 4 -> (int)((float)MANA_PER_USE_MAX[3] + (float)(MANA_PER_USE_MAX[4] - MANA_PER_USE_MAX[3]) * tierProcess);
            default -> 0;
        };
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return 0;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
    }

    public boolean m_6832_(ItemStack bow, ItemStack material) {
        return false;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.extrabotany.failnaught").m_130940_(ChatFormatting.GRAY).m_130940_(ChatFormatting.ITALIC));
        tooltip.add((Component)Component.m_237113_((String)""));
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltip);
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null);
    }

    public boolean m_8120_(ItemStack pStack) {
        return true;
    }

    public int m_6473_() {
        return 30;
    }

    @Override
    public boolean canEnchant(ItemStack stack, Enchantment enchantment) {
        return SUPPORT_ENCHANTMENTS.contains(enchantment);
    }

    @Override
    public boolean canEnchantOnTable(ItemStack stack, Enchantment enchantment) {
        return SUPPORT_ENCHANTMENTS.contains(enchantment);
    }
}

