/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.item.relic.voidcore;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lounode.eventwrapper.event.entity.living.LivingAttackEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingDamageEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.LivingHurtEventWrapper;
import io.github.lounode.eventwrapper.event.entity.living.MobEffectEventWrapper;
import io.github.lounode.eventwrapper.event.entity.player.PlayerEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.CoreOfTheVoidVariant;
import io.github.lounode.extrabotany.common.ExtraBotanyDamageTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Flandre;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Herrscher;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Jim;
import io.github.lounode.extrabotany.common.item.relic.voidcore.variants.Steampunk;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.XplatAbstractions;

@EventBusSubscriberWrapper
public class CoreOfTheVoidItem
extends BaubleItem
implements CustomCreativeTabContents {
    private static final String TAG_VARIANT = "variant";
    private static final int FLY_COST = 100;
    private static final int CURE_COST = 200;
    private static final int BACKFIRE_THRESHOLD = 100;
    private static final float BACKFIRE_DAMAGE = 2.0f;
    private static final List<String> playersWithFlight = Collections.synchronizedList(new ArrayList());

    public CoreOfTheVoidItem(Item.Properties properties) {
        super(properties);
        ExtraBotanyAPI.instance().registerCOVVariant(new Herrscher());
        ExtraBotanyAPI.instance().registerCOVVariant(new Flandre());
        ExtraBotanyAPI.instance().registerCOVVariant(new Jim());
        ExtraBotanyAPI.instance().registerCOVVariant(new Steampunk());
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register((Item)this, (AccessoryRenderer)new Renderer()));
    }

    public void addToCreativeTab(Item me, CreativeModeTab.Output output) {
        Map<String, CoreOfTheVoidVariant> variants = ExtraBotanyAPI.instance().getCOVVariants();
        for (CoreOfTheVoidVariant variant : variants.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            ItemNBTHelper.setString((ItemStack)stack, (String)TAG_VARIANT, (String)variant.getId());
            output.m_246342_(stack);
        }
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        RelicImpl.addDefaultTooltip((ItemStack)stack, tooltip);
        tooltip.add((Component)Component.m_237115_((String)("extrabotany.wings." + CoreOfTheVoidItem.getVariant(stack))));
    }

    @SubscribeEventWrapper
    public static void updatePlayerFlyStatus(LivingEventWrapper.LivingTickEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack tiara = EquipmentHandler.findOrEmpty((Item)ExtraBotanyItems.coreOfTheVoid, (LivingEntity)player);
        if (playersWithFlight.contains(CoreOfTheVoidItem.playerStr(player))) {
            if (CoreOfTheVoidItem.shouldPlayerHaveFlight(player)) {
                player.m_150110_().f_35936_ = true;
                if (player.m_150110_().f_35935_ && !player.m_9236_().f_46443_ && !player.m_7500_() && !player.m_5833_()) {
                    ManaItemHandler.instance().requestManaExact(tiara, player, CoreOfTheVoidItem.getFlyCost(), true);
                }
            } else {
                if (!player.m_5833_() && !player.m_150110_().f_35937_) {
                    player.m_150110_().f_35936_ = false;
                    player.m_150110_().f_35935_ = false;
                    player.m_150110_().f_35934_ = false;
                }
                playersWithFlight.remove(CoreOfTheVoidItem.playerStr(player));
            }
        } else if (CoreOfTheVoidItem.shouldPlayerHaveFlight(player)) {
            playersWithFlight.add(CoreOfTheVoidItem.playerStr(player));
            player.m_150110_().f_35936_ = true;
        }
    }

    public void onWornTick(ItemStack stack, LivingEntity entity) {
        if (entity.m_9236_().m_5776_()) {
            return;
        }
        if (CoreOfTheVoidItem.shouldBackFire(stack, entity) && entity.f_19797_ % 10 == 0) {
            if (entity.m_6469_(this.damageSource(entity.m_9236_().m_9598_()), this.getBackfireDamage()) && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_6330_(ExtraBotanySounds.PLAYER_BACKFIRE, SoundSource.PLAYERS, 1.0f, SoundEventUtil.randomPitch(player.m_9236_()));
            }
            return;
        }
        this.tryRemoveHarmfulPotion(stack, entity);
    }

    @SubscribeEventWrapper
    public static void playerLoggedOut(PlayerEventWrapper.PlayerLoggedOutEvent event) {
        String username = event.getEntity().m_36316_().getName();
        playersWithFlight.remove(username + ":false");
        playersWithFlight.remove(username + ":true");
    }

    private static boolean shouldPlayerHaveFlight(Player player) {
        ItemStack armor = EquipmentHandler.findOrEmpty((Item)ExtraBotanyItems.coreOfTheVoid, (LivingEntity)player);
        if (!armor.m_41619_()) {
            Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
            return relic != null && relic.isRightPlayer(player) && ManaItemHandler.instance().requestManaExact(armor, player, CoreOfTheVoidItem.getFlyCost(), false);
        }
        return false;
    }

    private static String playerStr(Player player) {
        return player.m_36316_().getName() + ":" + player.m_9236_().f_46443_;
    }

    public static boolean shouldBackFire(ItemStack stack, LivingEntity entity) {
        Player player;
        return entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_() && !ManaItemHandler.instance().requestManaExactForTool(stack, player, CoreOfTheVoidItem.getBackfireThreshold(), false);
    }

    public static int getFlyCost() {
        return 100;
    }

    public static int getCureCost() {
        return 200;
    }

    public static int getBackfireThreshold() {
        return 100;
    }

    public float getBackfireDamage() {
        return 2.0f;
    }

    public static String getVariant(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)TAG_VARIANT, (String)"herrscher");
    }

    public DamageSource damageSource(RegistryAccess access) {
        return ExtraBotanyDamageTypes.Sources.backfireDamage(access);
    }

    public boolean hasRender(ItemStack stack, LivingEntity living) {
        return super.hasRender(stack, living) && living instanceof Player;
    }

    public static Relic makeRelic(ItemStack stack) {
        return new RelicImpl(stack, null);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity instanceof Player) {
            Player player = (Player)entity;
            Relic relic = XplatAbstractions.INSTANCE.findRelic(stack);
            if (relic != null) {
                relic.tickBinding(player);
            }
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public Multimap<Attribute, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22279_, (Object)new AttributeModifier(CoreOfTheVoidItem.getBaubleUUID((ItemStack)stack), "Core of The Void", (double)0.1f, AttributeModifier.Operation.ADDITION));
        attributes.put((Object)Attributes.f_22280_, (Object)new AttributeModifier(CoreOfTheVoidItem.getBaubleUUID((ItemStack)stack), "Core of The Void", (double)0.6f, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    @SubscribeEventWrapper
    public static void onLivingAttack(LivingAttackEventWrapper event) {
        Player player;
        LivingEntity owner = event.getEntity();
        ItemStack armor = EquipmentHandler.findOrEmpty((Item)ExtraBotanyItems.coreOfTheVoid, (LivingEntity)owner);
        if (armor.m_41619_()) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
        if (relic == null || !(owner instanceof Player) || !relic.isRightPlayer(player = (Player)owner) || CoreOfTheVoidItem.shouldBackFire(armor, (LivingEntity)player)) {
            return;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEventWrapper
    public static void onLivingHurt(LivingHurtEventWrapper event) {
        Player player;
        LivingEntity owner = event.getEntity();
        ItemStack armor = EquipmentHandler.findOrEmpty((Item)ExtraBotanyItems.coreOfTheVoid, (LivingEntity)owner);
        if (armor.m_41619_()) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
        if (relic == null || !(owner instanceof Player) || !relic.isRightPlayer(player = (Player)owner) || CoreOfTheVoidItem.shouldBackFire(armor, (LivingEntity)player)) {
            return;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEventWrapper
    public static void onLivingDamage(LivingDamageEventWrapper event) {
        Player player;
        LivingEntity owner = event.getEntity();
        ItemStack armor = EquipmentHandler.findOrEmpty((Item)ExtraBotanyItems.coreOfTheVoid, (LivingEntity)owner);
        if (armor.m_41619_()) {
            return;
        }
        Relic relic = XplatAbstractions.INSTANCE.findRelic(armor);
        if (relic == null || !(owner instanceof Player) || !relic.isRightPlayer(player = (Player)owner) || CoreOfTheVoidItem.shouldBackFire(armor, (LivingEntity)player)) {
            return;
        }
        if (event.getSource().m_269533_(DamageTypeTags.f_268524_)) {
            event.setCanceled(true);
        }
    }

    protected void tryRemoveHarmfulPotion(ItemStack stack, LivingEntity entity) {
        List<MobEffectInstance> effects = entity.m_21220_().stream().filter(effect -> effect.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).toList();
        if (!effects.isEmpty() && entity instanceof Player) {
            Player player = (Player)entity;
            if (ManaItemHandler.instance().requestManaExactForTool(stack, player, CoreOfTheVoidItem.getCureCost(), true)) {
                effects.forEach(e -> entity.m_21195_(e.m_19544_()));
            }
        }
    }

    @SubscribeEventWrapper
    public static void onEffectAdd(MobEffectEventWrapper.Applicable event) {
        Player player;
        Relic relic;
        LivingEntity owner = event.getEntity();
        ItemStack armor = EquipmentHandler.findOrEmpty((Item)ExtraBotanyItems.coreOfTheVoid, (LivingEntity)owner);
        if (!armor.m_41619_() && event.getEffectInstance().m_19544_().m_19483_() == MobEffectCategory.HARMFUL && (relic = XplatAbstractions.INSTANCE.findRelic(armor)) != null && owner instanceof Player && relic.isRightPlayer(player = (Player)owner) && ManaItemHandler.instance().requestManaExact(armor, player, CoreOfTheVoidItem.getCureCost(), true)) {
            event.setResult(EventWrapper.Result.DENY);
        }
    }

    public static class Renderer
    implements AccessoryRenderer {
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            String variantID = CoreOfTheVoidItem.getVariant(stack);
            if (!ExtraBotanyAPI.instance().getCOVVariants().containsKey(variantID)) {
                return;
            }
            CoreOfTheVoidVariant variant = ExtraBotanyAPI.instance().getCOVVariants().get(variantID);
            variant.render(bipedModel, stack, living, ms, buffers, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }
}

