/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data;

import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.VoidArchivesVariant;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Camera;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Excalibur;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Failnaught;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.FruitOfGrisaia;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.InfiniteWine;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.models.model.DelegatedModel;
import net.minecraft.data.models.model.ModelLocationUtils;
import net.minecraft.data.models.model.ModelTemplate;
import net.minecraft.data.models.model.ModelTemplates;
import net.minecraft.data.models.model.TextureMapping;
import net.minecraft.data.models.model.TextureSlot;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.block.decor.FloatingFlowerBlock;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.data.util.ModelWithOverrides;
import vazkii.botania.data.util.OverrideHolder;
import vazkii.botania.mixin.TextureSlotAccessor;

public class ItemModelProvider
implements DataProvider {
    private static final TextureSlot LAYER1 = TextureSlotAccessor.make((String)"layer1");
    private static final TextureSlot LAYER2 = TextureSlotAccessor.make((String)"layer2");
    private static final TextureSlot LAYER3 = TextureSlotAccessor.make((String)"layer3");
    private static final ModelTemplate GENERATED_0 = new ModelTemplate(Optional.of(ResourceLocation.m_135820_((String)"item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_});
    private static final ModelTemplate GENERATED_1 = new ModelTemplate(Optional.of(ResourceLocation.m_135820_((String)"item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1});
    private static final ModelTemplate GENERATED_2 = new ModelTemplate(Optional.of(ResourceLocation.m_135820_((String)"item/generated")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1, LAYER2});
    private static final ModelTemplate HANDHELD_0 = new ModelTemplate(Optional.of(ResourceLocation.m_135820_((String)"item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_});
    private static final ModelTemplate HANDHELD_1 = new ModelTemplate(Optional.of(ResourceLocation.m_135820_((String)"item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1});
    private static final ModelTemplate HANDHELD_3 = new ModelTemplate(Optional.of(ResourceLocation.m_135820_((String)"item/handheld")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_, LAYER1, LAYER2, LAYER3});
    private static final ModelTemplate WALL_INVENTORY = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125872_, TextureSlot.f_125871_, TextureSlot.f_125884_});
    private static final ModelTemplate WALL_INVENTORY_CHECKERED = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/wall_inventory_checkered")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125876_, TextureSlot.f_125875_});
    private static final TextureSlot OUTSIDE = TextureSlotAccessor.make((String)"outside");
    private static final TextureSlot CORE = TextureSlotAccessor.make((String)"core");
    private static final ModelTemplate SPREADER = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("block/shapes/spreader_item")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125875_, TextureSlot.f_125874_, TextureSlot.f_176491_, OUTSIDE, CORE});
    private static final ModelWithOverrides GENERATED_OVERRIDES = new ModelWithOverrides(ResourceLocation.m_135820_((String)"item/generated"), new TextureSlot[]{TextureSlot.f_125863_});
    private static final ModelWithOverrides GENERATED_OVERRIDES_1 = new ModelWithOverrides(ResourceLocation.m_135820_((String)"item/generated"), new TextureSlot[]{TextureSlot.f_125863_, LAYER1});
    private static final ModelWithOverrides HANDHELD_OVERRIDES = new ModelWithOverrides(ResourceLocation.m_135820_((String)"item/handheld"), new TextureSlot[]{TextureSlot.f_125863_});
    private static final ModelWithOverrides HANDHELD_OVERRIDES_2 = new ModelWithOverrides(ResourceLocation.m_135820_((String)"item/handheld"), new TextureSlot[]{TextureSlot.f_125863_, LAYER1, LAYER2});
    private final PackOutput packOutput;

    public ItemModelProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        Set<Item> items = BuiltInRegistries.f_257033_.m_123024_().filter(i -> "extrabotany".equals(BuiltInRegistries.f_257033_.m_7981_(i).m_135827_())).collect(Collectors.toSet());
        HashMap map = new HashMap();
        this.registerItemBlocks(vazkii.botania.data.ItemModelProvider.takeAll(items, i -> i instanceof BlockItem).stream().map(i -> (BlockItem)i).collect(Collectors.toSet()), map::put);
        ItemModelProvider.registerItemOverrides(items, map::put);
        ItemModelProvider.registerItems(items, map::put);
        PackOutput.PathProvider modelPathProvider = this.packOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "models");
        ArrayList<CompletableFuture> output = new ArrayList<CompletableFuture>();
        for (Map.Entry e : map.entrySet()) {
            ResourceLocation id = (ResourceLocation)e.getKey();
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)((JsonElement)((Supplier)e.getValue()).get()), (Path)modelPathProvider.m_245731_(id)));
        }
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    private void registerItemBlocks(Set<BlockItem> itemBlocks, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        itemBlocks.removeIf(i -> {
            ResourceLocation id = BuiltInRegistries.f_256975_.m_7981_((Object)i.m_40614_());
            return id.m_135827_().equals("extrabotany") && i.m_40614_() instanceof FloatingFlowerBlock;
        });
        Predicate<BlockItem> defaultGenerated = i -> {
            Block b = i.m_40614_();
            return EXplatAbstractions.INSTANCE.isSpecialFlowerBlock(b);
        };
        vazkii.botania.data.ItemModelProvider.takeAll(itemBlocks, defaultGenerated).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125738_((Block)i.m_40614_()), consumer));
        itemBlocks.forEach(i -> consumer.accept(ModelLocationUtils.m_125571_((Item)i), (Supplier<JsonElement>)new DelegatedModel(ModelLocationUtils.m_125576_((Block)i.m_40614_()))));
    }

    private static void registerItems(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        items.remove(ExtraBotanyItems.failnaught);
        vazkii.botania.data.ItemModelProvider.takeAll(items, (Object[])new Item[]{ExtraBotanyItems.manasteelHammer, ExtraBotanyItems.elementiumHammer, ExtraBotanyItems.gaiaHammer, ExtraBotanyItems.photoniumHammer, ExtraBotanyItems.shadowiumHammer, ExtraBotanyItems.aerialiteHammer, ExtraBotanyItems.walkingCane, ExtraBotanyItems.magicFinger, ExtraBotanyItems.manaReader}).forEach(i -> ModelTemplates.f_125659_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), consumer));
        vazkii.botania.data.ItemModelProvider.takeAll(items, i -> true).forEach(i -> ModelTemplates.f_125658_.m_125612_(ModelLocationUtils.m_125571_((Item)i), TextureMapping.m_125766_((Item)i), consumer));
    }

    private static void registerItemOverrides(Set<Item> items, BiConsumer<ResourceLocation, Supplier<JsonElement>> consumer) {
        Item[] shields;
        OverrideHolder manaCocktailOverrides = new OverrideHolder();
        for (int i = 1; i <= 7; ++i) {
            ResourceLocation overrideModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.manaCocktail, (String)("_" + i));
            GENERATED_1.m_125612_(overrideModel, TextureMapping.m_125766_((Item)ExtraBotanyItems.manaCocktail).m_125758_(LAYER1, overrideModel), consumer);
            manaCocktailOverrides.add(overrideModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)((double)i * 0.01))});
        }
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.manaCocktail), TextureMapping.m_125766_((Item)ExtraBotanyItems.manaCocktail).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ExtraBotanyItems.manaCocktail, (String)"_0")), manaCocktailOverrides, consumer);
        items.remove(ExtraBotanyItems.manaCocktail);
        OverrideHolder infiniteWineOverrides = new OverrideHolder();
        for (int i = 1; i <= 12; ++i) {
            int modelSuffix = i;
            if (i == 1 || i == 2 || i == 3) {
                modelSuffix = 3;
            } else if (i == 4 || i == 5) {
                modelSuffix = 5;
            } else if (i == 6 || i == 7) {
                modelSuffix = 7;
            } else if (i == 8 || i == 9) {
                modelSuffix = 9;
            } else if (i == 10 || i == 11) {
                modelSuffix = 11;
            }
            ResourceLocation overrideModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.infiniteWine, (String)("_" + modelSuffix));
            if (i != modelSuffix) continue;
            if (i != 12) {
                GENERATED_1.m_125612_(overrideModel, TextureMapping.m_125766_((Item)ExtraBotanyItems.infiniteWine).m_125758_(LAYER1, overrideModel), consumer);
            } else {
                GENERATED_0.m_125612_(overrideModel, TextureMapping.m_125766_((Item)ExtraBotanyItems.infiniteWine), consumer);
            }
            infiniteWineOverrides.add(overrideModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("swigs_taken"), (Object)((double)i * 0.01))});
        }
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.infiniteWine), TextureMapping.m_125766_((Item)ExtraBotanyItems.infiniteWine).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ExtraBotanyItems.infiniteWine, (String)"_0")), infiniteWineOverrides, consumer);
        items.remove(ExtraBotanyItems.infiniteWine);
        OverrideHolder holyWaterGrenadeOverrides = new OverrideHolder();
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.holyWaterGrenade), TextureMapping.m_125766_((Item)ExtraBotanyItems.holyWaterGrenade).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ExtraBotanyItems.holyWaterGrenade, (String)"_cover")), holyWaterGrenadeOverrides, consumer);
        items.remove(ExtraBotanyItems.holyWaterGrenade);
        OverrideHolder voidArchivesOverrides = new OverrideHolder();
        int index = 1;
        for (Map.Entry<String, VoidArchivesVariant> variant : ExtraBotanyAPI.instance().getVoidArchivesVariants().entrySet()) {
            String key = variant.getKey();
            ResourceLocation overrideModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.voidArchives, (String)("_" + key));
            if (key.equals(VoidArchivesVariant.DEFAULT.getId())) continue;
            if (key.equals(Excalibur.INSTANCE.getId())) {
                HANDHELD_0.m_125612_(overrideModel, TextureMapping.m_125766_((Item)ExtraBotanyItems.excalibur), consumer);
            }
            if (key.equals(FruitOfGrisaia.INSTANCE.getId())) {
                GENERATED_0.m_125612_(overrideModel, TextureMapping.m_125766_((Item)BotaniaItems.infiniteFruit), consumer);
            }
            if (key.equals(Camera.INSTANCE.getId())) {
                GENERATED_0.m_125612_(overrideModel, TextureMapping.m_125766_((Item)ExtraBotanyItems.camera), consumer);
            }
            if (key.equals(Failnaught.INSTANCE.getId())) {
                overrideModel = ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.failnaught);
            }
            if (key.equals(InfiniteWine.INSTANCE.getId())) {
                GENERATED_1.m_125612_(overrideModel, TextureMapping.m_125766_((Item)ExtraBotanyItems.infiniteWine).m_125758_(LAYER1, ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.infiniteWine, (String)"_0")), consumer);
            }
            voidArchivesOverrides.add(overrideModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("variant"), (Object)((double)index * 0.01))});
            ++index;
        }
        GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.voidArchives), TextureMapping.m_125766_((Item)ExtraBotanyItems.voidArchives), voidArchivesOverrides, consumer);
        items.remove(ExtraBotanyItems.voidArchives);
        ResourceLocation terrHammerEnabledModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.terrasteelHammer, (String)"_active");
        ModelTemplates.f_125659_.m_125612_(terrHammerEnabledModel, TextureMapping.m_125820_((ResourceLocation)terrHammerEnabledModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.terrasteelHammer), TextureMapping.m_125766_((Item)ExtraBotanyItems.terrasteelHammer), new OverrideHolder().add(terrHammerEnabledModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)}), consumer);
        items.remove(ExtraBotanyItems.terrasteelHammer);
        ResourceLocation orichalcosHammerEnabledModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.orichalcosHammer, (String)"_active");
        ModelTemplates.f_125659_.m_125612_(orichalcosHammerEnabledModel, TextureMapping.m_125820_((ResourceLocation)orichalcosHammerEnabledModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.orichalcosHammer), TextureMapping.m_125766_((Item)ExtraBotanyItems.orichalcosHammer), new OverrideHolder().add(orichalcosHammerEnabledModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)}), consumer);
        items.remove(ExtraBotanyItems.orichalcosHammer);
        ResourceLocation rheinHammerEnabledModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.rheinHammer, (String)"_active");
        ModelTemplates.f_125659_.m_125612_(rheinHammerEnabledModel, TextureMapping.m_125820_((ResourceLocation)rheinHammerEnabledModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.rheinHammer), TextureMapping.m_125766_((Item)ExtraBotanyItems.rheinHammer), new OverrideHolder().add(rheinHammerEnabledModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("active"), (Object)1.0)}), consumer);
        items.remove(ExtraBotanyItems.rheinHammer);
        GENERATED_OVERRIDES_1.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.holyWaterGrenade), TextureMapping.m_125766_((Item)ExtraBotanyItems.holyWaterGrenade).m_125758_(LAYER1, TextureMapping.m_125745_((Item)ExtraBotanyItems.holyWaterGrenade, (String)"_cover")), holyWaterGrenadeOverrides, consumer);
        items.remove(ExtraBotanyItems.holyWaterGrenade);
        ResourceLocation senketsuModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.sanguinePleiadesCombatMaidSuit, (String)"_senketsu");
        GENERATED_0.m_125612_(senketsuModel, TextureMapping.m_125820_((ResourceLocation)senketsuModel), consumer);
        GENERATED_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.sanguinePleiadesCombatMaidSuit), TextureMapping.m_125766_((Item)ExtraBotanyItems.sanguinePleiadesCombatMaidSuit), new OverrideHolder().add(senketsuModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("senketsu"), (Object)1.0)}), consumer);
        items.remove(ExtraBotanyItems.sanguinePleiadesCombatMaidSuit);
        ResourceLocation saberModel = ModelLocationUtils.m_125573_((Item)ExtraBotanyItems.excalibur, (String)"_saber");
        ModelTemplates.f_125659_.m_125612_(saberModel, TextureMapping.m_125820_((ResourceLocation)saberModel), consumer);
        HANDHELD_OVERRIDES.create(ModelLocationUtils.m_125571_((Item)ExtraBotanyItems.excalibur), TextureMapping.m_125766_((Item)ExtraBotanyItems.excalibur), new OverrideHolder().add(saberModel, new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("saber"), (Object)1.0)}), consumer);
        items.remove(ExtraBotanyItems.excalibur);
        for (Item shield : shields = new Item[]{ExtraBotanyItems.manasteelShield, ExtraBotanyItems.elementiumShield, ExtraBotanyItems.terrasteelShield, ExtraBotanyItems.achillesShield}) {
            ResourceLocation shieldModel = ModelLocationUtils.m_125571_((Item)shield);
            ModelWithOverrides shieldModelTemplate = new ModelWithOverrides(ResourceLocationHelper.prefix("item/template/shield"), new TextureSlot[]{TextureSlot.f_125863_});
            ModelTemplate blockingModelTemplate = new ModelTemplate(Optional.of(ResourceLocationHelper.prefix("item/template/shield_blocking")), Optional.empty(), new TextureSlot[]{TextureSlot.f_125863_});
            OverrideHolder overrides = new OverrideHolder();
            if (shield == ExtraBotanyItems.achillesShield) {
                HANDHELD_0.m_125612_(shieldModel.m_266382_("_released"), TextureMapping.m_125820_((ResourceLocation)shieldModel.m_266382_("_released")), consumer);
                overrides.add(shieldModel.m_266382_("_blocking"), new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("blocking"), (Object)1.0), Pair.of((Object)ResourceLocationHelper.prefix("released"), (Object)0.0)});
                overrides.add(shieldModel.m_266382_("_released"), new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("blocking"), (Object)0.0), Pair.of((Object)ResourceLocationHelper.prefix("released"), (Object)1.0)});
            } else {
                overrides.add(shieldModel.m_266382_("_blocking"), new Pair[]{Pair.of((Object)ResourceLocationHelper.prefix("blocking"), (Object)1.0)});
            }
            shieldModelTemplate.create(shieldModel, TextureMapping.m_125766_((Item)shield), overrides, consumer);
            blockingModelTemplate.m_125612_(shieldModel.m_266382_("_blocking"), TextureMapping.m_125766_((Item)shield), consumer);
            items.remove(shield);
        }
    }

    @NotNull
    public String m_6055_() {
        return "ExtraBotany item models";
    }
}

