/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.loot;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.DamageSourceCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public abstract class EntityLootSubProviderFix
implements LootTableSubProvider {
    protected static final EntityPredicate.Builder ENTITY_ON_FIRE = EntityPredicate.Builder.m_36633_().m_36642_(EntityFlagsPredicate.Builder.m_33713_().m_33714_(Boolean.valueOf(true)).m_33716_());
    private static final Set<EntityType<?>> SPECIAL_LOOT_TABLE_TYPES = ImmutableSet.of((Object)EntityType.f_20532_, (Object)EntityType.f_20529_, (Object)EntityType.f_20460_, (Object)EntityType.f_20528_, (Object)EntityType.f_20492_);
    private final FeatureFlagSet allowed;
    private final FeatureFlagSet required;
    private final Map<EntityType<?>, Map<ResourceLocation, LootTable.Builder>> map = Maps.newHashMap();

    protected EntityLootSubProviderFix(FeatureFlagSet enabledFeatures) {
        this(enabledFeatures, enabledFeatures);
    }

    protected EntityLootSubProviderFix(FeatureFlagSet allowed, FeatureFlagSet required) {
        this.allowed = allowed;
        this.required = required;
    }

    protected static LootTable.Builder createSheepTable(ItemLike woolItem) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)woolItem))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootTableReference.m_79776_((ResourceLocation)EntityType.f_20520_.m_20677_())));
    }

    protected abstract Stream<EntityType<?>> getKnownEntityTypes();

    public abstract void generate();

    public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> output) {
        this.generate();
        HashSet set = Sets.newHashSet();
        this.getKnownEntityTypes().forEach(entitytype -> {
            ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_(entitytype);
            if (entitytype.m_245993_(this.allowed)) {
                if (EntityLootSubProviderFix.canHaveLootTable(entitytype)) {
                    Map<ResourceLocation, LootTable.Builder> map = this.map.remove(entitytype);
                    ResourceLocation resourcelocation = entitytype.m_20677_();
                    if (!(resourcelocation.equals((Object)BuiltInLootTables.f_78712_) || !entitytype.m_245993_(this.required) || map != null && map.containsKey(resourcelocation))) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Missing loottable '%s' for '%s'", resourcelocation, key));
                    }
                    if (map != null) {
                        map.forEach((p_250376_, p_250972_) -> {
                            if (!set.add(p_250376_)) {
                                throw new IllegalStateException(String.format(Locale.ROOT, "Duplicate loottable '%s' for '%s'", p_250376_, key));
                            }
                            output.accept((ResourceLocation)p_250376_, (LootTable.Builder)p_250972_);
                        });
                    }
                } else {
                    Map<ResourceLocation, LootTable.Builder> map1 = this.map.remove(entitytype);
                    if (map1 != null) {
                        throw new IllegalStateException(String.format(Locale.ROOT, "Weird loottables '%s' for '%s', not a LivingEntity so should not have loot", map1.keySet().stream().map(ResourceLocation::toString).collect(Collectors.joining(",")), key));
                    }
                }
            }
        });
        if (!this.map.isEmpty()) {
            throw new IllegalStateException("Created loot tables for entities not supported by datapack: " + String.valueOf(this.map.keySet()));
        }
    }

    private static boolean canHaveLootTable(EntityType<?> entityType) {
        return SPECIAL_LOOT_TABLE_TYPES.contains(entityType) || entityType.m_20674_() != MobCategory.MISC;
    }

    protected LootItemCondition.Builder killedByFrog() {
        return DamageSourceCondition.m_81589_((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.m_25471_().m_148231_(EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_217012_)));
    }

    protected LootItemCondition.Builder killedByFrogVariant(FrogVariant frogVariant) {
        return DamageSourceCondition.m_81589_((DamageSourcePredicate.Builder)DamageSourcePredicate.Builder.m_25471_().m_148231_(EntityPredicate.Builder.m_36633_().m_36636_(EntityType.f_217012_).m_218800_(EntitySubPredicate.m_218833_((FrogVariant)frogVariant))));
    }

    protected void add(EntityType<?> entityType, LootTable.Builder builder) {
        this.add(entityType, entityType.m_20677_(), builder);
    }

    protected void add(EntityType<?> entityType, ResourceLocation lootTableLocation, LootTable.Builder builder) {
        this.map.computeIfAbsent(entityType, p_251466_ -> new HashMap()).put(lootTableLocation, builder);
    }
}

