/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.data.recipes;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import org.jetbrains.annotations.NotNull;

public abstract class ExtraBotanyRecipeProvider
implements DataProvider {
    private final PackOutput.PathProvider recipePathProvider;
    private final PackOutput.PathProvider advancementPathProvider;

    public ExtraBotanyRecipeProvider(PackOutput packOutput) {
        this.recipePathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "recipes");
        this.advancementPathProvider = packOutput.m_245269_(PackOutput.Target.DATA_PACK, "advancements");
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput cache) {
        HashSet checkDuplicates = Sets.newHashSet();
        ArrayList output = new ArrayList();
        this.buildRecipes(recipe -> {
            if (!checkDuplicates.add(recipe.m_6445_())) {
                throw new IllegalStateException("Duplicate recipe " + String.valueOf(recipe.m_6445_()));
            }
            output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)recipe.m_125966_(), (Path)this.recipePathProvider.m_245731_(recipe.m_6445_())));
            JsonObject advancement = recipe.m_5860_();
            if (advancement != null) {
                output.add(DataProvider.m_253162_((CachedOutput)cache, (JsonElement)advancement, (Path)this.advancementPathProvider.m_245731_(recipe.m_6448_())));
            }
        });
        return CompletableFuture.allOf((CompletableFuture[])output.toArray(CompletableFuture[]::new));
    }

    protected abstract void buildRecipes(Consumer<FinishedRecipe> var1);
}

