/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.forge;

import com.google.common.base.Suppliers;
import com.mojang.logging.LogUtils;
import io.github.lounode.extrabotany.api.ExtraBotaniaRegistries;
import io.github.lounode.extrabotany.api.ExtrabotanyForgeCapabilities;
import io.github.lounode.extrabotany.api.item.NatureEnergyItem;
import io.github.lounode.extrabotany.common.advancements.ExtrabotanyCriteriaTriggers;
import io.github.lounode.extrabotany.common.block.ExtraBotanyBlocks;
import io.github.lounode.extrabotany.common.block.block_entity.ExtraBotanyBlockEntities;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyBrews;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyMobEffects;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.impl.WindImpl;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.brew.InfiniteWineItem;
import io.github.lounode.extrabotany.common.item.equipment.bauble.NatureOrbItem;
import io.github.lounode.extrabotany.common.item.equipment.tool.hammer.RheinHammerItem;
import io.github.lounode.extrabotany.common.item.relic.AchillesShieldItem;
import io.github.lounode.extrabotany.common.item.relic.CameraItem;
import io.github.lounode.extrabotany.common.item.relic.ExcaliburItem;
import io.github.lounode.extrabotany.common.item.relic.FailnaughtItem;
import io.github.lounode.extrabotany.common.item.relic.MasterBandOfManaItem;
import io.github.lounode.extrabotany.common.item.relic.PandorasBoxItem;
import io.github.lounode.extrabotany.common.item.relic.void_archives.VoidArchivesItem;
import io.github.lounode.extrabotany.common.item.relic.voidcore.CoreOfTheVoidItem;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.loot.RewardBagManager;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.forge.ForgeExtrabotanyConfig;
import io.github.lounode.extrabotany.forge.network.ForgePacketHandler;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import vazkii.botania.api.BotaniaForgeCapabilities;
import vazkii.botania.api.BotaniaRegistries;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.forge.CapabilityUtil;
import vazkii.botania.forge.integration.curios.CurioIntegration;

@Mod(value="extrabotany")
public class ForgeCommonInitializer {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final Supplier<Map<Item, Function<ItemStack, NatureEnergyItem>>> NATURE_ENERGY_ITEM = Suppliers.memoize(() -> Map.of(ExtraBotanyItems.natureOrb, NatureOrbItem.NatureEnergyImpl::new));
    private static final Supplier<Map<Item, Function<ItemStack, ManaItem>>> MANA_ITEM = Suppliers.memoize(() -> Map.of(ExtraBotanyItems.manaRingMaster, MasterBandOfManaItem.ExtendManaItemImpl::new));
    private static final Supplier<Map<Item, Function<ItemStack, Relic>>> RELIC = Suppliers.memoize(() -> Map.of(ExtraBotanyItems.manaRingMaster, MasterBandOfManaItem::makeRelic, ExtraBotanyItems.camera, CameraItem::makeRelic, ExtraBotanyItems.failnaught, FailnaughtItem::makeRelic, ExtraBotanyItems.excalibur, ExcaliburItem::makeRelic, ExtraBotanyItems.coreOfTheVoid, CoreOfTheVoidItem::makeRelic, ExtraBotanyItems.pandorasBox, PandorasBoxItem::makeRelic, ExtraBotanyItems.infiniteWine, InfiniteWineItem::makeRelic, ExtraBotanyItems.voidArchives, VoidArchivesItem::makeRelic, ExtraBotanyItems.rheinHammer, RheinHammerItem::makeRelic, ExtraBotanyItems.achillesShield, AchillesShieldItem::makeRelic));
    private final Set<Item> itemsToAddToCreativeTab = new LinkedHashSet<Item>();

    public ForgeCommonInitializer() {
        ModLoadingContext context = ModLoadingContext.get();
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        this.coreInit(context);
        this.registryInit(modBus);
        modBus.addListener(this::commonSetup);
    }

    public void commonSetup(FMLCommonSetupEvent evt) {
        ForgePacketHandler.init();
        this.registerEvents();
        evt.enqueueWork(() -> {
            BiConsumer<ResourceLocation, Supplier<? extends Block>> consumer = (resourceLocation, blockSupplier) -> ((FlowerPotBlock)Blocks.f_50276_).addPlant(resourceLocation, blockSupplier);
            ExtraBotanyBlocks.registerFlowerPotPlants(consumer);
            ExtrabotanyFlowerBlocks.registerFlowerPotPlants(consumer);
        });
        if (ModList.get().isLoaded("tconstruc")) {
            // empty if block
        }
    }

    private void coreInit(ModLoadingContext context) {
        ForgeExtrabotanyConfig.setup(context);
    }

    private void registryInit(IEventBus modEventBus) {
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256840_, ExtraBotanySounds::init);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256747_, ExtraBotanyBlocks::registerBlocks);
        this.bindForItems(modEventBus, ExtraBotanyBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256922_, ExtraBotanyBlockEntities::registerTiles);
        this.bindForItems(modEventBus, ExtraBotanyItems::registerItems);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256747_, ExtrabotanyFlowerBlocks::registerBlocks);
        this.bindForItems(modEventBus, ExtrabotanyFlowerBlocks::registerItemBlocks);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256922_, ExtrabotanyFlowerBlocks::registerTEs);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256764_, ExtraBotanyItems::registerRecipeSerializers);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256954_, ExtraBotanyRecipeTypes::submitRecipeTypes);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256764_, ExtraBotanyRecipeTypes::submitRecipeSerializers);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256939_, ExtraBotanyEntityType::registerEntities);
        modEventBus.addListener(e -> ExtraBotanyEntityType.registerAttributes((type, builder) -> e.put(type, builder.m_22265_())));
        ForgeCommonInitializer.bind(modEventBus, Registries.f_257023_, ExtraBotanyMemoryType::registerMemories);
        ForgeCommonInitializer.bind(modEventBus, Registries.f_256929_, ExtraBotanyMobEffects::registerPotions);
        ForgeCommonInitializer.bind(modEventBus, BotaniaRegistries.BREWS, ExtraBotanyBrews::submitRegistrations);
        ExtrabotanyCriteriaTriggers.init();
        ForgeCommonInitializer.bind(modEventBus, Registries.f_279569_, consumer -> consumer.accept(CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"itemGroup.extrabotany").m_130938_(style -> style.m_131140_(ChatFormatting.WHITE))).m_257809_().m_257737_(() -> new ItemStack((ItemLike)ExtraBotanyItems.zadkiel)).m_257609_("extrabotany.png").m_257652_(), ExtraBotaniaRegistries.EXTRA_BOTANIA_TAB_KEY.m_135782_()));
        modEventBus.addListener(e -> {
            if (e.getTabKey() == ExtraBotaniaRegistries.EXTRA_BOTANIA_TAB_KEY) {
                for (Item item : this.itemsToAddToCreativeTab) {
                    BlockItem bi;
                    Block patt7469$temp;
                    if (item instanceof CustomCreativeTabContents) {
                        CustomCreativeTabContents cc = (CustomCreativeTabContents)item;
                        cc.addToCreativeTab(item, (CreativeModeTab.Output)e);
                        continue;
                    }
                    if (item instanceof BlockItem && (patt7469$temp = (bi = (BlockItem)item).m_40614_()) instanceof CustomCreativeTabContents) {
                        CustomCreativeTabContents cc = (CustomCreativeTabContents)patt7469$temp;
                        cc.addToCreativeTab(item, (CreativeModeTab.Output)e);
                        continue;
                    }
                    e.m_246326_((ItemLike)item);
                }
            }
        });
    }

    private void registerEvents() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addGenericListener(ItemStack.class, this::attachItemCaps);
        bus.addGenericListener(Level.class, this::attachLevelCaps);
        bus.addListener(event -> WindImpl.EventHandler.onLevelTick(event.level));
        RewardBagManager.registerListener();
    }

    private void attachLevelCaps(AttachCapabilitiesEvent<Level> event) {
    }

    private void attachItemCaps(AttachCapabilitiesEvent<ItemStack> e) {
        Function<ItemStack, Relic> makeRelic;
        Function<ItemStack, NatureEnergyItem> makeNatureEnergyItem;
        Function<ItemStack, ManaItem> makeManaItem;
        EquipmentHandler equipmentHandler;
        ItemStack stack = (ItemStack)e.getObject();
        if (stack.m_41720_() instanceof BaubleItem && (equipmentHandler = EquipmentHandler.instance) instanceof CurioIntegration) {
            CurioIntegration ci = (CurioIntegration)equipmentHandler;
            e.addCapability(ResourceLocationHelper.prefix("curio"), ci.initCapability(stack));
        }
        if ((makeManaItem = MANA_ITEM.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("mana_item"), CapabilityUtil.makeProvider((Capability)BotaniaForgeCapabilities.MANA_ITEM, (Object)makeManaItem.apply(stack)));
        }
        if ((makeNatureEnergyItem = NATURE_ENERGY_ITEM.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("nature_energy_item"), CapabilityUtil.makeProvider(ExtrabotanyForgeCapabilities.NATURE_ENERGY_ITEM, (Object)makeNatureEnergyItem.apply(stack)));
        }
        if ((makeRelic = RELIC.get().get(stack.m_41720_())) != null) {
            e.addCapability(ResourceLocationHelper.prefix("relic"), CapabilityUtil.makeProvider((Capability)BotaniaForgeCapabilities.RELIC, (Object)makeRelic.apply(stack)));
        }
    }

    private static <T> void bind(IEventBus modEventBus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        modEventBus.addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private void bindForItems(IEventBus modEventBus, Consumer<BiConsumer<Item, ResourceLocation>> source) {
        modEventBus.addListener(event -> {
            if (event.getRegistryKey().equals((Object)Registries.f_256913_)) {
                source.accept((t, rl) -> {
                    this.itemsToAddToCreativeTab.add((Item)t);
                    event.register(Registries.f_256913_, rl, () -> t);
                });
            }
        });
    }
}

