/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.forge.data;

import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.forge.data.ForgeBlockTagProvider;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;

public class ForgeItemTagProvider
extends ItemTagsProvider {
    public ForgeItemTagProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> blockTagProvider, ExistingFileHelper helper) {
        super(packOutput, lookupProvider, blockTagProvider, "extrabotany", helper);
    }

    public String m_6055_() {
        return "ExtraBotany item tags (Forge-specific)";
    }

    protected void m_6577_(HolderLookup.Provider provider) {
        this.generateMaterialTags();
        this.generateToolTags();
        this.generateAccessoryTags();
    }

    private void generateMaterialTags() {
        this.m_206424_(ForgeItemTagProvider.forge("ingots/orichalcos")).m_206428_(ExtraBotanyTags.Items.INGOTS_ORICHALCOS);
        this.m_206424_(ForgeItemTagProvider.forge("ingots/photonium")).m_206428_(ExtraBotanyTags.Items.INGOTS_PHOTONIUM);
        this.m_206424_(ForgeItemTagProvider.forge("ingots/shadowium")).m_206428_(ExtraBotanyTags.Items.INGOTS_SHADOWIUM);
        this.m_206424_(ForgeItemTagProvider.forge("ingots/aerialite")).m_206428_(ExtraBotanyTags.Items.INGOTS_AERIALITE);
        this.m_206424_(Tags.Items.INGOTS).m_206428_(ForgeItemTagProvider.forge("ingots/orichalcos")).m_206428_(ForgeItemTagProvider.forge("ingots/photonium")).m_206428_(ForgeItemTagProvider.forge("ingots/shadowium")).m_206428_(ForgeItemTagProvider.forge("ingots/aerialite"));
        this.m_206424_(ForgeItemTagProvider.forge("nuggets/orichalcos")).m_206428_(ExtraBotanyTags.Items.NUGGETS_ORICHALCOS);
        this.m_206424_(ForgeItemTagProvider.forge("nuggets/photonium")).m_206428_(ExtraBotanyTags.Items.NUGGETS_PHOTONIUM);
        this.m_206424_(ForgeItemTagProvider.forge("nuggets/shadowium")).m_206428_(ExtraBotanyTags.Items.NUGGETS_SHADOWIUM);
        this.m_206424_(ForgeItemTagProvider.forge("nuggets/aerialite")).m_206428_(ExtraBotanyTags.Items.NUGGETS_AERIALITE);
        this.m_206424_(Tags.Items.NUGGETS).m_206428_(ForgeItemTagProvider.forge("nuggets/orichalcos")).m_206428_(ForgeItemTagProvider.forge("nuggets/photonium")).m_206428_(ForgeItemTagProvider.forge("nuggets/shadowium")).m_206428_(ForgeItemTagProvider.forge("nuggets/aerialite"));
        this.copyToSameName(ForgeBlockTagProvider.ORICHALCOS);
        this.copyToSameName(ForgeBlockTagProvider.PHOTONIUM);
        this.copyToSameName(ForgeBlockTagProvider.SHADOWIUM);
        this.copyToSameName(ForgeBlockTagProvider.AERIALITE);
        this.m_206424_(Tags.Items.GEMS_QUARTZ).m_255179_((Object[])new Item[]{ExtraBotanyItems.gaiaQuartz, ExtraBotanyItems.elementiumQuartz});
    }

    private void generateAccessoryTags() {
        this.m_206424_(ForgeItemTagProvider.accessory("ring")).m_255179_((Object[])ExtraBotanyItems.RINGS);
        this.m_206424_(ForgeItemTagProvider.accessory("necklace")).m_255245_((Object)ExtraBotanyItems.pureDaisyPendant);
        this.m_206424_(ForgeItemTagProvider.accessory("body")).m_255179_((Object[])ExtraBotanyItems.BODY);
        this.m_206424_(ForgeItemTagProvider.accessory("curio")).m_255179_((Object[])ExtraBotanyItems.ALL_SLOT);
    }

    private void generateToolTags() {
        this.m_206424_(Tags.Items.ARMORS_HELMETS).m_255179_((Object[])new Item[]{ExtraBotanyItems.starryIdolHeadgear, ExtraBotanyItems.pleiadesCombatMaidHeadgear, ExtraBotanyItems.shadowWarriorHelmet, ExtraBotanyItems.goblinSlayerHelmet});
        this.m_206424_(Tags.Items.ARMORS_CHESTPLATES).m_255179_((Object[])new Item[]{ExtraBotanyItems.starryIdolSuit, ExtraBotanyItems.pleiadesCombatMaidSuit, ExtraBotanyItems.sanguinePleiadesCombatMaidSuit, ExtraBotanyItems.shadowWarriorChestplate, ExtraBotanyItems.goblinSlayerChestplate});
        this.m_206424_(Tags.Items.ARMORS_LEGGINGS).m_255179_((Object[])new Item[]{ExtraBotanyItems.starryIdolSkirt, ExtraBotanyItems.pleiadesCombatMaidSkirt, ExtraBotanyItems.shadowWarriorLeggings, ExtraBotanyItems.goblinSlayerLeggings});
        this.m_206424_(Tags.Items.ARMORS_BOOTS).m_255179_((Object[])new Item[]{ExtraBotanyItems.starryIdolBoots, ExtraBotanyItems.pleiadesCombatMaidBoots, ExtraBotanyItems.shadowWarriorBoots, ExtraBotanyItems.goblinSlayerBoots});
        this.m_206424_(Tags.Items.TOOLS_SHIELDS).m_255179_((Object[])ExtraBotanyItems.SHIELDS);
        this.m_206424_(Tags.Items.TOOLS_BOWS).m_255179_((Object[])ExtraBotanyItems.BOWS);
    }

    private static TagKey<Item> accessory(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.m_214293_((String)"curios", (String)name));
    }

    private static TagKey<Item> forge(String name) {
        return ItemTags.create((ResourceLocation)ResourceLocation.m_214293_((String)"forge", (String)name));
    }

    private void copyToSameName(TagKey<Block> source) {
        this.m_206421_(source, ItemTags.create((ResourceLocation)source.f_203868_()));
    }
}

