/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.api.gaia;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2694;
import net.minecraft.class_4538;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class BlockPatternExtend {
    private static final class_2350[] FLAT_DIRECTIONS = new class_2350[]{class_2350.field_11043, class_2350.field_11035, class_2350.field_11039, class_2350.field_11034};
    private final Predicate<class_2694>[][][] pattern;
    private final int depth;
    private final int height;
    private final int width;

    public BlockPatternExtend(Predicate<class_2694>[][][] pattern) {
        this.pattern = pattern;
        this.depth = pattern.length;
        if (this.depth > 0) {
            this.height = pattern[0].length;
            this.width = this.height > 0 ? pattern[0][0].length : 0;
        } else {
            this.height = 0;
            this.width = 0;
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    @VisibleForTesting
    public Predicate<class_2694>[][][] getPattern() {
        return this.pattern;
    }

    @Nullable
    @VisibleForTesting
    public BlockPatternMatchSuccess matches(class_4538 level, class_2338 pos, class_2350 finger, class_2350 thumb) {
        LoadingCache<class_2338, class_2694> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        return this.matches(pos, finger, thumb, loadingcache);
    }

    @Nullable
    private BlockPatternMatchSuccess matches(class_2338 pos, class_2350 finger, class_2350 thumb, LoadingCache<class_2338, class_2694> cache) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.depth; ++k) {
                    if (this.pattern[k][j][i].test((class_2694)cache.getUnchecked((Object)BlockPatternExtend.translateAndRotate(pos, finger, thumb, i, j, k)))) continue;
                    return null;
                }
            }
        }
        return new BlockPatternMatchSuccess(pos, finger, thumb, cache, this.width, this.height, this.depth);
    }

    @VisibleForTesting
    public MatchResult matchesWithFailResult(class_4538 level, class_2338 pos, class_2350 finger, class_2350 thumb) {
        LoadingCache<class_2338, class_2694> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        HashMap<class_2338, Pair<Predicate<class_2694>, class_2694>> failCache = new HashMap<class_2338, Pair<Predicate<class_2694>, class_2694>>();
        return this.matchesWithFailResult(pos, finger, thumb, loadingcache, failCache);
    }

    private MatchResult matchesWithFailResult(class_2338 pos, class_2350 finger, class_2350 thumb, LoadingCache<class_2338, class_2694> cache, Map<class_2338, Pair<Predicate<class_2694>, class_2694>> failCache) {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.height; ++j) {
                for (int k = 0; k < this.depth; ++k) {
                    Predicate<class_2694> predicate = this.pattern[k][j][i];
                    class_2338 checkPos = BlockPatternExtend.translateAndRotate(pos, finger, thumb, i, j, k);
                    class_2694 block = (class_2694)cache.getUnchecked((Object)checkPos);
                    if (predicate.test(block)) continue;
                    failCache.put(checkPos, (Pair<Predicate<class_2694>, class_2694>)Pair.of(predicate, (Object)block));
                }
            }
        }
        if (!failCache.isEmpty()) {
            return new BlockPatternMatchFail(failCache, finger, thumb);
        }
        return new BlockPatternMatchSuccess(pos, finger, thumb, cache, this.width, this.height, this.depth);
    }

    @Nullable
    public BlockPatternMatchSuccess find(class_4538 level, class_2338 pos) {
        LoadingCache<class_2338, class_2694> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        for (class_2338 blockpos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(i - 1, i - 1, i - 1))) {
            for (class_2350 direction : class_2350.values()) {
                for (class_2350 direction1 : class_2350.values()) {
                    BlockPatternMatchSuccess matches;
                    if (direction1 == direction || direction1 == direction.method_10153() || (matches = this.matches(blockpos, direction, direction1, loadingcache)) == null) continue;
                    return matches;
                }
            }
        }
        return null;
    }

    @Deprecated
    public MatchResult findWithFailResult(class_4538 level, class_2338 pos) {
        LoadingCache<class_2338, class_2694> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        ArrayList<BlockPatternMatchFail> fails = new ArrayList<BlockPatternMatchFail>();
        for (class_2338 blockpos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(i - 1, i - 1, i - 1))) {
            for (class_2350 direction : class_2350.values()) {
                for (class_2350 direction1 : class_2350.values()) {
                    if (direction1 == direction || direction1 == direction.method_10153()) continue;
                    HashMap<class_2338, Pair<Predicate<class_2694>, class_2694>> failCache = new HashMap<class_2338, Pair<Predicate<class_2694>, class_2694>>();
                    MatchResult matches = this.matchesWithFailResult(blockpos, direction, direction1, loadingcache, failCache);
                    if (matches instanceof BlockPatternMatchSuccess) {
                        BlockPatternMatchSuccess success = (BlockPatternMatchSuccess)matches;
                        return success;
                    }
                    if (!(matches instanceof BlockPatternMatchFail)) continue;
                    BlockPatternMatchFail fail = (BlockPatternMatchFail)matches;
                    fails.add(fail);
                }
            }
        }
        return fails.stream().min(Comparator.comparingInt(BlockPatternMatchFail::size)).orElse(null);
    }

    @Deprecated
    public MatchResult findFlatWithFailResult(class_4538 level, class_2338 pos) {
        LoadingCache<class_2338, class_2694> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        ArrayList<BlockPatternMatchFail> fails = new ArrayList<BlockPatternMatchFail>();
        for (class_2338 blockpos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(i - 1, i - 1, i - 1))) {
            for (class_2350 direction : FLAT_DIRECTIONS) {
                HashMap<class_2338, Pair<Predicate<class_2694>, class_2694>> failCache = new HashMap<class_2338, Pair<Predicate<class_2694>, class_2694>>();
                MatchResult matches = this.matchesWithFailResult(blockpos, class_2350.field_11033, direction, loadingcache, failCache);
                if (matches instanceof BlockPatternMatchSuccess) {
                    BlockPatternMatchSuccess success = (BlockPatternMatchSuccess)matches;
                    return success;
                }
                if (!(matches instanceof BlockPatternMatchFail)) continue;
                BlockPatternMatchFail fail = (BlockPatternMatchFail)matches;
                fails.add(fail);
            }
        }
        return fails.stream().min(Comparator.comparingInt(BlockPatternMatchFail::size)).orElse(null);
    }

    @Nullable
    public BlockPatternMatchSuccess findFlat(class_4538 level, class_2338 pos) {
        LoadingCache<class_2338, class_2694> loadingcache = BlockPatternExtend.createLevelCache(level, false);
        int i = Math.max(Math.max(this.width, this.height), this.depth);
        for (class_2338 blockpos : class_2338.method_10097((class_2338)pos, (class_2338)pos.method_10069(i - 1, i - 1, i - 1))) {
            for (class_2350 direction : FLAT_DIRECTIONS) {
                BlockPatternMatchSuccess match = this.matches(blockpos, class_2350.field_11033, direction, loadingcache);
                if (match == null) continue;
                return match;
            }
        }
        return null;
    }

    public static LoadingCache<class_2338, class_2694> createLevelCache(class_4538 level, boolean forceLoad) {
        return CacheBuilder.newBuilder().build((CacheLoader)new BlockCacheLoader(level, forceLoad));
    }

    protected static class_2338 translateAndRotate(class_2338 pos, class_2350 finger, class_2350 thumb, int palmOffset, int thumbOffset, int fingerOffset) {
        if (finger != thumb && finger != thumb.method_10153()) {
            class_2382 vec3i = new class_2382(finger.method_10148(), finger.method_10164(), finger.method_10165());
            class_2382 vec3i1 = new class_2382(thumb.method_10148(), thumb.method_10164(), thumb.method_10165());
            class_2382 vec3i2 = vec3i.method_10259(vec3i1);
            return pos.method_10069(vec3i1.method_10263() * -thumbOffset + vec3i2.method_10263() * palmOffset + vec3i.method_10263() * fingerOffset, vec3i1.method_10264() * -thumbOffset + vec3i2.method_10264() * palmOffset + vec3i.method_10264() * fingerOffset, vec3i1.method_10260() * -thumbOffset + vec3i2.method_10260() * palmOffset + vec3i.method_10260() * fingerOffset);
        }
        throw new IllegalArgumentException("Invalid forwards & up combination");
    }

    public static class BlockPatternMatchSuccess
    extends MatchResult {
        private final class_2338 frontTopLeft;
        private final LoadingCache<class_2338, class_2694> cache;
        private final int width;
        private final int height;
        private final int depth;

        public BlockPatternMatchSuccess(class_2338 frontTopLeft, class_2350 forwards, class_2350 up, LoadingCache<class_2338, class_2694> cache, int width, int height, int depth) {
            super(forwards, up);
            this.frontTopLeft = frontTopLeft;
            this.cache = cache;
            this.width = width;
            this.height = height;
            this.depth = depth;
        }

        public class_2338 getFrontTopLeft() {
            return this.frontTopLeft;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDepth() {
            return this.depth;
        }

        public class_2694 getBlock(int palmOffset, int thumbOffset, int fingerOffset) {
            return (class_2694)this.cache.getUnchecked((Object)BlockPatternExtend.translateAndRotate(this.frontTopLeft, this.getForwards(), this.getUp(), palmOffset, thumbOffset, fingerOffset));
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.getUp()).add("forwards", (Object)this.getForwards()).add("frontTopLeft", (Object)this.frontTopLeft).toString();
        }
    }

    public static class MatchResult {
        private final class_2350 forwards;
        private final class_2350 up;

        public MatchResult(class_2350 forwards, class_2350 up) {
            this.forwards = forwards;
            this.up = up;
        }

        public class_2350 getForwards() {
            return this.forwards;
        }

        public class_2350 getUp() {
            return this.up;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("up", (Object)this.getUp()).add("forwards", (Object)this.getForwards()).toString();
        }
    }

    public static class BlockPatternMatchFail
    extends MatchResult {
        private final Map<class_2338, Pair<Predicate<class_2694>, class_2694>> failedBlocks;

        public BlockPatternMatchFail(Map<class_2338, Pair<Predicate<class_2694>, class_2694>> failedBlocks, class_2350 finger, class_2350 thumb) {
            super(finger, thumb);
            this.failedBlocks = failedBlocks;
        }

        public Map<class_2338, Pair<Predicate<class_2694>, class_2694>> getFailedBlocks() {
            return this.failedBlocks;
        }

        public int size() {
            return this.failedBlocks.size();
        }
    }

    static class BlockCacheLoader
    extends CacheLoader<class_2338, class_2694> {
        private final class_4538 level;
        private final boolean loadChunks;

        public BlockCacheLoader(class_4538 level, boolean loadChunks) {
            this.level = level;
            this.loadChunks = loadChunks;
        }

        public class_2694 load(class_2338 pos) {
            return new class_2694(this.level, pos, this.loadChunks);
        }
    }
}

