/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.api.gaia;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtend;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtendBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockTagPredicate;
import io.github.lounode.extrabotany.common.entity.MagicLandMineEntity;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.lib.RegistryHelper;
import io.github.lounode.extrabotany.common.telemetry.ExtraBotanyTelemetry;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2715;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_4208;
import net.minecraft.class_4538;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.entity.MagicLandmineEntity;
import vazkii.botania.common.entity.PixieEntity;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.proxy.Proxy;

public class GaiaArena {
    public static final Codec<GaiaArena> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_4208.field_25066.fieldOf("center").forGetter(GaiaArena::center), (App)Codec.FLOAT.fieldOf("radius").forGetter(GaiaArena::radius), (App)Codec.INT.fieldOf("height").forGetter(GaiaArena::height)).apply((Applicative)instance, GaiaArena::of));
    public static final float ARENA_RANGE = 12.0f;
    public static final int ARENA_HEIGHT = 5;
    private static final class_6862<class_2248> BLACKLIST = BotaniaTags.Blocks.GAIA_BREAK_BLACKLIST;
    public static final List<class_2338> PYLON_LOCATIONS = ImmutableList.of((Object)new class_2338(4, 1, 4), (Object)new class_2338(4, 1, -4), (Object)new class_2338(-4, 1, 4), (Object)new class_2338(-4, 1, -4));
    public static final Predicate<class_2694>[][][] ARENA_PATTERN = BlockPatternExtendBuilder.start().aisle("P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P").aisle("_________", "_________", "_________", "_________", "____B____", "_________", "_________", "_________", "_________").aisle("_________", "_________", "_________", "___III___", "___III___", "___III___", "_________", "_________", "_________").where('_', class_2694.method_11678((Predicate)class_2715.field_12419)).where('B', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10327))).where('I', class_2694.method_11678((Predicate)BlockTagPredicate.forTag((class_6862<class_2248>)class_3481.field_22275))).where('P', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)BotaniaBlocks.gaiaPylon))).createPattern();
    public static final Predicate<class_2694>[][][] PYLONS_PATTERN = BlockPatternExtendBuilder.start().aisle("P_______P", "_________", "_________", "_________", "_________", "_________", "_________", "_________", "P_______P").where('_', class_2694.method_11678((Predicate)class_2715.field_12419)).where('P', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)BotaniaBlocks.gaiaPylon))).createPattern();
    private static List<String> CACHED_BYPASS_CONFIG = new ArrayList<String>();
    private static final List<String> CACHED_BYPASS_MODIDS = new ArrayList<String>();
    private static final List<String> CACHED_BYPASS_ITEMS = new ArrayList<String>();
    private final class_4208 center;
    private final float radius;
    private final int height;

    private GaiaArena(class_4208 center, float radius, int height) {
        this.center = center;
        this.radius = radius;
        this.height = height;
    }

    public static GaiaArena of(class_4208 center, float radius, int height) {
        return new GaiaArena(center, radius, height);
    }

    public static GaiaArena of(class_4208 center) {
        return GaiaArena.of(center, 12.0f, 5);
    }

    public class_4208 center() {
        return this.center;
    }

    public float radius() {
        return this.radius;
    }

    public int height() {
        return this.height;
    }

    public boolean isSameCenter(GaiaArena other) {
        return this.center.equals((Object)other.center);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && this.getClass() == other.getClass()) {
            GaiaArena gaiaArena = (GaiaArena)other;
            return Objects.equals(this.center, gaiaArena.center) && Objects.equals(Float.valueOf(this.radius), Float.valueOf(gaiaArena.radius)) && Objects.equals(this.height, gaiaArena.height);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.center, Float.valueOf(this.radius), this.height);
    }

    public String toString() {
        return "GaiaArena{center=" + String.valueOf(this.center) + ", radius=" + this.radius + ", height=" + this.height + "}";
    }

    public void tick(Gaia gaia) {
        List<class_1657> players;
        if (gaia.method_37908().method_8608()) {
            this.particles(gaia);
        }
        if ((players = this.getPlayersAround(gaia.method_37908())).isEmpty() && !gaia.method_37908().method_18456().isEmpty()) {
            gaia.method_31472();
            ExtraBotanyTelemetry.Event.onGaiaBattleFinish(gaia);
        }
        if (!gaia.method_37908().method_8608()) {
            for (class_1657 player : players) {
                this.keepInsideArena(player);
            }
        }
    }

    public void cleanup(class_1937 level) {
        if (level.method_8608()) {
            return;
        }
        for (class_1657 player : this.getPlayersAround(level)) {
            if (player.method_6112(class_1294.field_5920) == null) continue;
            player.method_6016(class_1294.field_5920);
        }
        for (PixieEntity pixie : level.method_8390(PixieEntity.class, this.getArenaBB(), p -> p.method_5805() && p.getPixieType() == 1)) {
            pixie.method_5990();
            pixie.method_31472();
        }
        for (MagicLandmineEntity landmine : level.method_18467(MagicLandmineEntity.class, this.getArenaBB())) {
            landmine.method_31472();
        }
        for (MagicLandMineEntity mine : level.method_18467(MagicLandMineEntity.class, this.getArenaBB())) {
            mine.method_31472();
        }
    }

    public void keepInsideArena(class_1657 player) {
        if (MathHelper.pointDistanceSpace((double)player.method_23317(), (double)player.method_23318(), (double)player.method_23321(), (double)((double)this.center().method_19446().method_10263() + 0.5), (double)((double)this.center().method_19446().method_10264() + 0.5), (double)((double)this.center().method_19446().method_10260() + 0.5)) >= this.radius()) {
            class_243 sourceVector = new class_243((double)this.center().method_19446().method_10263() + 0.5, (double)this.center().method_19446().method_10264() + 0.5, (double)this.center().method_19446().method_10260() + 0.5);
            class_243 playerVector = VecHelper.fromEntityCenter((class_1297)player);
            class_243 motion = sourceVector.method_1020(playerVector).method_1029();
            player.method_18800(motion.field_1352, 0.2, motion.field_1350);
            player.field_6037 = true;
        }
    }

    public void particles(Gaia gaia) {
        float rad;
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)this.center().method_19446().method_10263() + 0.5 - Math.cos(rad) * (double)this.radius();
            double y = (double)this.center().method_19446().method_10264() + 0.5;
            double z = (double)this.center().method_19446().method_10260() + 0.5 - Math.sin(rad) * (double)this.radius();
            WispParticleData data = WispParticleData.wisp((float)0.5f, (float)r, (float)g, (float)b);
            gaia.method_37908().method_8406((class_2394)data, x, y, z, (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * mv), (double)((float)(Math.random() - 0.5) * m));
        }
        if (gaia.getInvulTime() > 10) {
            class_243 pos = VecHelper.fromEntityCenter((class_1297)gaia).method_1023(0.0, 0.2, 0.0);
            for (class_2338 arr : PYLON_LOCATIONS) {
                class_243 pylonPos = new class_243((double)(this.center().method_19446().method_10263() + arr.method_10263()), (double)(this.center().method_19446().method_10264() + arr.method_10264()), (double)(this.center().method_19446().method_10260() + arr.method_10260()));
                double worldTime = gaia.field_6012;
                rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.field_1352 + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.field_1350 + 0.5 + Math.sin(worldTime) * (double)rad;
                class_243 partPos = new class_243(xp, pylonPos.field_1351, zp);
                class_243 mot = pos.method_1020(partPos).method_1021(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                WispParticleData data = WispParticleData.wisp((float)(0.25f + (float)Math.random() * 0.1f), (float)r, (float)g, (float)b, (float)1.0f);
                gaia.method_37908().method_8406((class_2394)data, partPos.field_1352, partPos.field_1351, partPos.field_1350, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                WispParticleData data1 = WispParticleData.wisp((float)0.4f, (float)r, (float)g, (float)b);
                gaia.method_37908().method_8406((class_2394)data1, partPos.field_1352, partPos.field_1351, partPos.field_1350, (double)((float)mot.field_1352), (double)((float)mot.field_1351), (double)((float)mot.field_1350));
            }
        }
    }

    public boolean checksVanilla(class_1657 player, class_1937 world, class_2338 pos) {
        if (!(world.method_8321(pos) instanceof class_2580) || !PlayerHelper.isTruePlayer((class_1297)player) || this.countGaiaAround(world, GaiaGuardianEntity.class) > 0) {
            return false;
        }
        if (!GaiaArena.checkDifficulty(world)) {
            if (!world.method_8608()) {
                player.method_43496((class_2561)class_2561.method_43471((String)"botaniamisc.peacefulNoob").method_27692(class_124.field_1061));
            }
            return false;
        }
        if (!this.checkPylons(player, world)) {
            return false;
        }
        List<class_2338> invalidArenaBlocks = this.checkArea(world);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.field_9236) {
                GaiaArena.warnInvalidBlocks(world, invalidArenaBlocks);
                this.showRadius(world);
            } else {
                player.method_43496((class_2561)class_2561.method_43471((String)"botaniamisc.badArena").method_27692(class_124.field_1061));
            }
            return false;
        }
        return true;
    }

    public boolean checksModern(class_1657 player, class_1937 world, class_1799 stack) {
        List<class_2338> invalidArenaBlocks;
        if (!(world.method_8321(this.center().method_19446()) instanceof class_2580) || !PlayerHelper.isTruePlayer((class_1297)player) || this.countGaiaAround(world, Gaia.class) + this.countGaiaAround(world, GaiaGuardianEntity.class) > 0) {
            return false;
        }
        if (!GaiaArena.checkDifficulty(world)) {
            if (!world.method_8608()) {
                player.method_43496((class_2561)class_2561.method_43471((String)"botaniamisc.peacefulNoob").method_27692(class_124.field_1061));
            }
            return false;
        }
        if (world.method_8608()) {
            if (!this.checkStructure(world, ARENA_PATTERN)) {
                return false;
            }
        } else {
            BlockPatternExtend.MatchResult result = this.checkStructureNeedsMatchResult(world, ARENA_PATTERN);
            if (result instanceof BlockPatternExtend.BlockPatternMatchFail) {
                BlockPatternExtend.BlockPatternMatchFail fail = (BlockPatternExtend.BlockPatternMatchFail)result;
                if (!world.method_8608()) {
                    List<class_2338> invalidPylonBlocks = fail.getFailedBlocks().keySet().stream().toList();
                    GaiaArena.warnInvalidBlocksServer((class_3222)player, (class_3218)world, invalidPylonBlocks);
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.extrabotany.chat.bad_struct", (Object[])new Object[]{stack.method_7909().method_7848()}).method_27692(class_124.field_1061));
                }
                return false;
            }
        }
        if (!(invalidArenaBlocks = this.checkArea(world)).isEmpty()) {
            if (world.field_9236) {
                GaiaArena.warnInvalidBlocks(world, invalidArenaBlocks);
                this.showRadius(world);
            } else {
                player.method_43496((class_2561)class_2561.method_43471((String)"botaniamisc.badArena").method_27692(class_124.field_1061));
            }
            return false;
        }
        return true;
    }

    public static boolean checkDifficulty(class_1937 world) {
        return world.method_8407() != class_1267.field_5801;
    }

    public boolean checkPylons(class_1657 player, class_1937 world) {
        return GaiaArena.checkPylons(player, world, this.center().method_19446(), PYLON_LOCATIONS);
    }

    public static boolean checkPylons(class_1657 player, class_1937 world, class_2338 beaconPos, List<class_2338> pylonLocations) {
        List<class_2338> invalidPylonBlocks = GaiaArena.getInvalidPylons(world, beaconPos, pylonLocations);
        if (!invalidPylonBlocks.isEmpty()) {
            if (world.method_8608()) {
                GaiaArena.warnInvalidBlocks(world, invalidPylonBlocks);
            } else {
                player.method_43496((class_2561)class_2561.method_43471((String)"botaniamisc.needsCatalysts").method_27692(class_124.field_1061));
            }
            return false;
        }
        return true;
    }

    public boolean checkStructure(class_1937 world, Predicate<class_2694>[][][] pattern) {
        return GaiaArena.checkStructure(world, this.center().method_19446(), pattern);
    }

    public static boolean checkStructure(class_1937 world, class_2338 beaconPos, Predicate<class_2694>[][][] pattern) {
        return new BlockPatternExtend(pattern).findFlat((class_4538)world, beaconPos) != null;
    }

    public BlockPatternExtend.MatchResult checkStructureNeedsMatchResult(class_1937 world, Predicate<class_2694>[][][] pattern) {
        return GaiaArena.checkStructureNeedsMatchResult(world, this.center().method_19446(), pattern);
    }

    public static BlockPatternExtend.MatchResult checkStructureNeedsMatchResult(class_1937 world, class_2338 beaconPos, Predicate<class_2694>[][][] pattern) {
        return new BlockPatternExtend(pattern).findFlatWithFailResult((class_4538)world, beaconPos);
    }

    public List<class_2338> checkArea(class_1937 world) {
        return GaiaArena.checkArena(world, this.center().method_19446(), this.radius(), this.height(), BLACKLIST);
    }

    public static List<class_2338> checkArena(class_1937 world, class_2338 beaconPos, float arenaRange, float arenaHeight, class_6862<class_2248> blackList) {
        return GaiaArena.getInvalidArenaBlocks(world, beaconPos, arenaRange, arenaHeight, blackList);
    }

    public static List<class_2338> getInvalidArenaBlocks(class_1937 world, class_2338 beaconPos, float arenaRange, float arenaHeight, class_6862<class_2248> blackList) {
        ArrayList<class_2338> trippedPositions = new ArrayList<class_2338>();
        int range = (int)Math.ceil(arenaRange);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane((double)x, (double)z, (double)0.0, (double)0.0) > arenaRange) continue;
                boolean hasFloor = false;
                int y = -2;
                while ((float)y <= arenaHeight) {
                    if (x != 0 || y != 0 || z != 0) {
                        boolean isBlockHere;
                        class_2338 pos = beaconPos.method_10069(x, y, z);
                        class_2680 state = world.method_8320(pos);
                        boolean allowBlockHere = y < 0;
                        boolean bl = isBlockHere = !state.method_26220((class_1922)world, pos).method_1110();
                        if (allowBlockHere && isBlockHere) {
                            hasFloor = true;
                        }
                        if (y == 0 && !hasFloor) {
                            trippedPositions.add(pos.method_10074());
                        }
                        if (!allowBlockHere && isBlockHere && !state.method_26164(blackList)) {
                            trippedPositions.add(pos);
                        }
                    }
                    ++y;
                }
            }
        }
        return trippedPositions;
    }

    public boolean checkInventory(class_1937 level) {
        List<class_1657> players = this.getPlayersAround(level);
        for (class_1657 player : players) {
            if (GaiaArena.checkInventoryPass(player)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkInventoryPass(class_1657 player) {
        if (player.method_7337() || ExtraBotanyConfig.common().disableGaiaDisArm()) {
            return true;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (GaiaArena.checkFeasibility(stack)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkFeasibility(class_1799 stack) {
        class_2960 itemLocation;
        String modid;
        if (stack.method_7960()) {
            return true;
        }
        if (CACHED_BYPASS_CONFIG != ExtraBotanyConfig.common().gaiaSpawnUnCheckList()) {
            GaiaArena.updateCache(ExtraBotanyConfig.common().gaiaSpawnUnCheckList());
        }
        if (CACHED_BYPASS_MODIDS.contains(modid = (itemLocation = RegistryHelper.getRegistryName(stack.method_7909())).method_12836())) {
            return true;
        }
        return CACHED_BYPASS_ITEMS.contains(itemLocation.toString());
    }

    public static void updateCache(List<String> newBypassList) {
        CACHED_BYPASS_CONFIG = newBypassList;
        CACHED_BYPASS_MODIDS.clear();
        CACHED_BYPASS_ITEMS.clear();
        for (String s : CACHED_BYPASS_CONFIG) {
            if (!s.contains(":")) {
                CACHED_BYPASS_MODIDS.add(s);
                continue;
            }
            class_2960 itemLocation = class_2960.method_12829((String)s);
            if (itemLocation == null || !class_7923.field_41178.method_10250(itemLocation)) continue;
            CACHED_BYPASS_ITEMS.add(itemLocation.toString());
        }
    }

    public int countGaiaAround(class_1937 world, Class<? extends class_1297> gaiaClass) {
        return world.method_18467(gaiaClass, this.getArenaBB()).size();
    }

    public static int countGaiaAround(class_1937 world, class_2338 center, float radius, Class<? extends class_1297> gaiaClass) {
        return world.method_18467(gaiaClass, GaiaArena.getArenaBB(center, radius)).size();
    }

    @NotNull
    public class_238 getArenaBB() {
        return this.getArenaBB(this.radius());
    }

    @NotNull
    public class_238 getArenaBB(double radius) {
        return GaiaArena.getArenaBB(this.center().method_19446(), radius);
    }

    @NotNull
    public static class_238 getArenaBB(class_2338 center, double radius) {
        return new class_238((double)center.method_10263() + 0.5, (double)center.method_10264() + 0.5, (double)center.method_10260() + 0.5, (double)center.method_10263() + 0.5, (double)center.method_10264() + 0.5, (double)center.method_10260() + 0.5).method_1014(radius);
    }

    public void showRadius(class_1937 world) {
        GaiaArena.showRadius(world, this.center().method_19446(), this.radius());
    }

    public static void showRadius(class_1937 world, class_2338 center, double radius) {
        SparkleParticleData data = SparkleParticleData.sparkle((float)5.0f, (float)1.0f, (float)0.0f, (float)1.0f, (int)120);
        for (int i = 0; i < 360; i += 8) {
            float rad = (float)i * (float)Math.PI / 180.0f;
            double wx = (double)center.method_10263() + 0.5 - Math.cos(rad) * radius;
            double wy = (double)center.method_10264() + 0.5;
            double wz = (double)center.method_10260() + 0.5 - Math.sin(rad) * radius;
            Proxy.INSTANCE.addParticleForceNear(world, (class_2394)data, wx, wy, wz, 0.0, 0.0, 0.0);
        }
    }

    public List<class_1657> getPlayersAround(class_1937 level) {
        return PlayerHelper.getRealPlayersIn((class_1937)level, (class_238)this.getArenaBB((double)this.radius() + 3.0));
    }

    public static void warnInvalidBlocks(class_1937 world, Iterable<class_2338> invalidPositions) {
        WispParticleData data = WispParticleData.wisp((float)0.5f, (float)1.0f, (float)0.2f, (float)0.2f, (float)8.0f, (boolean)false);
        for (class_2338 pos_ : invalidPositions) {
            world.method_8406((class_2394)data, (double)pos_.method_10263() + 0.5, (double)pos_.method_10264() + 0.5, (double)pos_.method_10260() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    public static void warnInvalidBlocksServer(class_3222 player, class_3218 level, Iterable<class_2338> invalidPositions) {
        WispParticleData data = WispParticleData.wisp((float)0.5f, (float)1.0f, (float)0.2f, (float)0.2f, (float)8.0f, (boolean)false);
        for (class_2338 pos_ : invalidPositions) {
            level.method_14166(player, (class_2394)data, false, (double)pos_.method_10263() + 0.5, (double)pos_.method_10264() + 0.5, (double)pos_.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static List<class_2338> getInvalidPylons(class_1937 world, class_2338 beaconPos, List<class_2338> pylonLocations) {
        ArrayList<class_2338> invalidPylonBlocks = new ArrayList<class_2338>();
        for (class_2338 coords : pylonLocations) {
            class_2338 pos_ = beaconPos.method_10081((class_2382)coords);
            class_2680 state = world.method_8320(pos_);
            if (state.method_27852(BotaniaBlocks.gaiaPylon)) continue;
            invalidPylonBlocks.add(pos_);
        }
        return invalidPylonBlocks;
    }
}

