/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.core;

import io.github.lounode.extrabotany.api.ExtraBotanyAPI;
import io.github.lounode.extrabotany.api.item.CoreOfTheVoidVariant;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_2960;
import net.minecraft.class_3300;

public class ExtraBotanyModels {
    public static final ExtraBotanyModels INSTANCE = new ExtraBotanyModels();
    private final Map<class_2960, Function<class_1087, class_1087>> afterBakeModifiers = new HashMap<class_2960, Function<class_1087, class_1087>>();
    private final Map<class_2960, Consumer<class_1087>> modelConsumers = new HashMap<class_2960, Consumer<class_1087>>();
    public boolean registeredModels = false;

    private ExtraBotanyModels() {
        for (CoreOfTheVoidVariant variant : ExtraBotanyAPI.instance().getCOVVariants().values()) {
            variant.onModelInit(this.modelConsumers);
        }
    }

    public void onModelRegister(class_3300 rm, Consumer<class_2960> consumer) {
        this.modelConsumers.keySet().forEach(consumer);
        if (!this.registeredModels) {
            this.registeredModels = true;
        }
    }

    public void onModelBake(class_1088 loader, Map<class_2960, class_1087> map) {
        if (!this.registeredModels) {
            ExtraBotanyAPI.LOGGER.error("Additional models failed to register! Aborting baking models to avoid early crashing.");
            return;
        }
        this.afterBakeModifiers.forEach((resourceLocation, afterBakeModifier) -> map.computeIfPresent((class_2960)resourceLocation, (resourceLoc, bakedModel) -> (class_1087)afterBakeModifier.apply(bakedModel)));
        this.modelConsumers.forEach((resourceLocation, bakedModelConsumer) -> bakedModelConsumer.accept((class_1087)map.get(resourceLocation)));
    }

    public class_1087 modifyModelAfterbake(class_1087 bakedModel, class_2960 id) {
        this.modelConsumers.getOrDefault(id, model -> {}).accept(bakedModel);
        return (class_1087)this.afterBakeModifiers.getOrDefault(id, Function.identity()).apply(bakedModel);
    }
}

