/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.core.handler;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.extrabotany.api.gaia.ColorfulBossBar;
import java.util.Collections;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.class_1259;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;

public final class BossBarHandler {
    public static final Set<class_1309> bosses = Collections.newSetFromMap(new WeakHashMap());
    private static final class_2960 BAR_TEXTURE = class_2960.method_12829((String)"botania:textures/gui/boss_bar.png");

    private BossBarHandler() {
    }

    public static OptionalInt onBarRender(class_332 gui, int x, int y, class_1259 bossEvent, boolean drawName) {
        for (class_1309 currentBoss : bosses) {
            int n;
            ColorfulBossBar bossBar;
            if (!(currentBoss instanceof ColorfulBossBar) || !(bossBar = (ColorfulBossBar)currentBoss).getBossInfoUuid().equals(bossEvent.method_5407())) continue;
            class_310 mc = class_310.method_1551();
            int frameU = 0;
            int frameV = 0;
            int frameWidth = 185;
            int frameHeight = 15;
            int healthU = 0;
            int healthV = frameV + frameHeight;
            int healthWidth = 181;
            int healthHeight = 7;
            int healthX = x + (frameWidth - healthWidth) / 2;
            int healthY = y + (frameHeight - healthHeight) / 2;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int playerCountHeight = 5;
            if (bossBar.displayPlayerCount()) {
                BossBarHandler.drawPlayerCount(bossBar.getPlayerCount(), gui, x, y);
            }
            RenderHelper.drawTexturedModalRect((class_332)gui, (class_2960)BAR_TEXTURE, (int)x, (int)y, (int)frameU, (int)frameV, (int)frameWidth, (int)frameHeight);
            BossBarHandler.drawHealthBar(gui, currentBoss, bossBar, healthX, healthY, healthU, healthV, (int)((float)healthWidth * bossEvent.method_5412()), healthHeight, false);
            if (drawName) {
                class_2561 name = bossEvent.method_5414();
                int centerX = mc.method_22683().method_4486() / 2;
                gui.method_27534(mc.field_1772, name, centerX, y - 10, 10617228);
            }
            if (drawName) {
                Objects.requireNonNull(mc.field_1772);
                n = 9;
            } else {
                n = 0;
            }
            return OptionalInt.of(frameHeight + playerCountHeight + n);
        }
        return OptionalInt.empty();
    }

    private static int drawPlayerCount(int playerCount, class_332 gui, int x, int y) {
        class_4587 ps = gui.method_51448();
        ps.method_22903();
        int px = x + 160;
        int py = y + 12;
        class_310 mc = class_310.method_1551();
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        gui.method_51427(stack, px, py);
        gui.method_25303(mc.field_1772, Integer.toString(playerCount), px + 15, py + 4, 0xFFFFFF);
        ps.method_22909();
        return 5;
    }

    private static void drawHealthBar(class_332 gui, class_1309 boss, ColorfulBossBar bossBar, int x, int y, int u, int v, int w, int h, boolean bg) {
        class_5944 shader = CoreShaders.dopplegangerBar();
        if (shader != null) {
            shader.method_35785("BotaniaGrainIntensity").method_1251(bossBar.getGrainIntensity());
            shader.method_35785("BotaniaHpFract").method_1251(boss.method_6032() / boss.method_6063());
        }
        float minU = (float)u / 256.0f;
        float maxU = (float)(u + w) / 256.0f;
        float minV = (float)v / 256.0f;
        float maxV = (float)(v + h) / 256.0f;
        Matrix4f matrix = gui.method_51448().method_23760().method_23761();
        RenderSystem.setShader(CoreShaders::dopplegangerBar);
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22913(minU, maxV).method_1344();
        builder.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22913(maxU, maxV).method_1344();
        builder.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22913(maxU, minV).method_1344();
        builder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(minU, minV).method_1344();
        class_289.method_1348().method_1350();
    }
}

