/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.gui;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.extrabotany.client.gui.GaiaLerpingBossEvent;
import io.github.lounode.extrabotany.common.bossevents.GaiaBossEvent;
import io.github.lounode.extrabotany.network.clientbound.ColorfulBossEventPacket;
import io.github.lounode.extrabotany.network.clientbound.GaiaBossEventPacket;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_4587;
import net.minecraft.class_5944;
import org.joml.Matrix4f;
import vazkii.botania.client.core.helper.CoreShaders;
import vazkii.botania.client.core.helper.RenderHelper;

public class ColorfulBossBarOverlay {
    public static final class_2960 BAR_TEXTURE = class_2960.method_12829((String)"botania:textures/gui/boss_bar.png");
    private static final class_2960 GUI_BARS_LOCATION = class_2960.method_12829((String)"textures/gui/bars.png");
    private static final int BAR_WIDTH = 182;
    private static final int BAR_HEIGHT = 5;
    private static final int OVERLAY_OFFSET = 80;
    private final class_310 minecraft;
    final Map<UUID, GaiaLerpingBossEvent> events = Maps.newLinkedHashMap();

    public ColorfulBossBarOverlay(class_310 minecraft) {
        this.minecraft = minecraft;
    }

    public void render(class_332 gui) {
        if (this.events.isEmpty()) {
            return;
        }
        int guiWidth = gui.method_51421();
        int x = guiWidth / 2 - 91;
        int y = 12;
        for (GaiaLerpingBossEvent event : this.events.values()) {
            int frameU = 0;
            int frameV = 0;
            int frameWidth = 185;
            int frameHeight = 15;
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_2561 name = event.method_5414();
            int centerX = this.minecraft.method_22683().method_4486() / 2;
            gui.method_27534(this.minecraft.field_1772, name, centerX, y - 10, 10617228);
            int healthU = 0;
            int healthV = frameV + frameHeight;
            int healthWidth = 181;
            int healthHeight = 7;
            int healthX = x + (frameWidth - healthWidth) / 2;
            int healthY = y + (frameHeight - healthHeight) / 2;
            RenderHelper.drawTexturedModalRect((class_332)gui, (class_2960)BAR_TEXTURE, (int)x, (int)y, (int)frameU, (int)frameV, (int)frameWidth, (int)frameHeight);
            ColorfulBossBarOverlay.drawHealthBar(gui, event, healthX, healthY, healthU, healthV, (int)((float)healthWidth * event.method_5412()), healthHeight);
            int px = x + 160;
            int py = y + 12;
            if (event.displayPlayerCount()) {
                ColorfulBossBarOverlay.drawPlayerCount(event.getPlayerCount(), gui, px, py);
            }
            if ((y += frameHeight * 2) < gui.method_51443() / 3) continue;
            break;
        }
    }

    public static void drawPlayerCount(int playerCount, class_332 gui, int x, int y) {
        class_4587 ps = gui.method_51448();
        ps.method_22903();
        class_310 mc = class_310.method_1551();
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        gui.method_51427(stack, x, y);
        gui.method_25303(mc.field_1772, Integer.toString(playerCount), x + 15, y + 4, 0xFFFFFF);
        ps.method_22909();
    }

    public static void drawBar(class_332 guiGraphics, int x, int y, class_1259 bossEvent) {
        ColorfulBossBarOverlay.drawBar(guiGraphics, x, y, bossEvent, 182, 0);
        int i = (int)(bossEvent.method_5412() * 183.0f);
        if (i > 0) {
            ColorfulBossBarOverlay.drawBar(guiGraphics, x, y, bossEvent, i, 5);
        }
    }

    public static void drawBar(class_332 guiGraphics, int x, int y, class_1259 bossEvent, int width, int height) {
        guiGraphics.method_25302(GUI_BARS_LOCATION, x, y, 0, bossEvent.method_5420().ordinal() * 5 * 2 + height, width, 5);
        if (bossEvent.method_5415() != class_1259.class_1261.field_5795) {
            RenderSystem.enableBlend();
            guiGraphics.method_25302(GUI_BARS_LOCATION, x, y, 0, 80 + (bossEvent.method_5415().ordinal() - 1) * 5 * 2 + height, width, 5);
            RenderSystem.disableBlend();
        }
    }

    public static void drawHealthBar(class_332 gui, GaiaBossEvent bossEvent, int x, int y, int u, int v, int w, int h) {
        class_1259 event = (class_1259)bossEvent;
        class_5944 shader = CoreShaders.dopplegangerBar();
        if (shader != null) {
            float grainIntensity = bossEvent.getGrainIntensity();
            shader.method_35785("BotaniaGrainIntensity").method_1251(grainIntensity);
            shader.method_35785("BotaniaHpFract").method_1251(event.method_5412());
        }
        float minU = (float)u / 256.0f;
        float maxU = (float)(u + w) / 256.0f;
        float minV = (float)v / 256.0f;
        float maxV = (float)(v + h) / 256.0f;
        Matrix4f matrix = gui.method_51448().method_23760().method_23761();
        RenderSystem.setShader(CoreShaders::dopplegangerBar);
        class_287 builder = class_289.method_1348().method_1349();
        builder.method_1328(class_293.class_5596.field_27382, class_290.field_1585);
        builder.method_22918(matrix, (float)x, (float)(y + h), 0.0f).method_22913(minU, maxV).method_1344();
        builder.method_22918(matrix, (float)(x + w), (float)(y + h), 0.0f).method_22913(maxU, maxV).method_1344();
        builder.method_22918(matrix, (float)(x + w), (float)y, 0.0f).method_22913(maxU, minV).method_1344();
        builder.method_22918(matrix, (float)x, (float)y, 0.0f).method_22913(minU, minV).method_1344();
        class_289.method_1348().method_1350();
    }

    public void update(ColorfulBossEventPacket packet) {
        packet.dispatch(new GaiaBossEventPacket.Handler(){

            @Override
            public void updatePlayerCount(UUID uuid, int playerCount) {
                ColorfulBossBarOverlay.this.events.get(uuid).setPlayerCount(playerCount);
            }

            @Override
            public void updateGrainTime(UUID uuid, int time) {
                ColorfulBossBarOverlay.this.events.get(uuid).setGrainTime(time);
            }

            @Override
            public void add(UUID uuid, class_2561 name, float progress, class_1259.class_1260 bossBarColor, class_1259.class_1261 overlay, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
                ColorfulBossBarOverlay.this.events.put(uuid, new GaiaLerpingBossEvent(uuid, name, progress, bossBarColor, overlay, darkenScreen, playMusic, createWorldFog));
            }

            @Override
            public void remove(UUID uuid) {
                ColorfulBossBarOverlay.this.events.remove(uuid);
            }

            @Override
            public void updateProgress(UUID uuid, float progress) {
                ColorfulBossBarOverlay.this.events.get(uuid).method_5408(progress);
            }

            @Override
            public void updateName(UUID uuid, class_2561 name) {
                ColorfulBossBarOverlay.this.events.get(uuid).method_5413(name);
            }

            @Override
            public void updateStyle(UUID uuid, class_1259.class_1260 bossBarColor, class_1259.class_1261 overlay) {
                class_345 lerpingbossevent = ColorfulBossBarOverlay.this.events.get(uuid);
                lerpingbossevent.method_5416(bossBarColor);
                lerpingbossevent.method_5409(overlay);
            }

            @Override
            public void updateProperties(UUID uuid, boolean darkenScreen, boolean playMusic, boolean createWorldFog) {
                class_345 lerpingbossevent = ColorfulBossBarOverlay.this.events.get(uuid);
                lerpingbossevent.method_5406(darkenScreen);
                lerpingbossevent.method_5410(playMusic);
                lerpingbossevent.method_5411(createWorldFog);
            }
        });
    }

    public void reset() {
        this.events.clear();
    }

    public boolean shouldPlayMusic() {
        if (!this.events.isEmpty()) {
            for (class_1259 class_12592 : this.events.values()) {
                if (!class_12592.method_5418()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldDarkenScreen() {
        if (!this.events.isEmpty()) {
            for (class_1259 class_12592 : this.events.values()) {
                if (!class_12592.method_5417()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldCreateWorldFog() {
        if (!this.events.isEmpty()) {
            for (class_1259 class_12592 : this.events.values()) {
                if (!class_12592.method_5419()) continue;
                return true;
            }
        }
        return false;
    }
}

