/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.gui;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.extrabotany.client.gui.ColorfulBossBarOverlay;
import io.github.lounode.extrabotany.common.item.relic.CameraItem;
import io.github.lounode.extrabotany.common.item.relic.void_archives.VoidArchivesItem;
import io.github.lounode.extrabotany.common.item.relic.void_archives.variants.Camera;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public final class HUD {
    public static HUD INSTANCE;
    private static final class_2960 manaBar;
    private final class_310 minecraft;
    private final ColorfulBossBarOverlay bossOverlay;
    private float scopeScale;

    public HUD(class_310 minecraft) {
        INSTANCE = this;
        this.minecraft = minecraft;
        this.bossOverlay = new ColorfulBossBarOverlay(minecraft);
    }

    public void onDrawScreenPost(class_332 gui, float partialTicks) {
        class_4587 ms = gui.method_51448();
        if (this.minecraft.field_1690.field_1842) {
            return;
        }
        class_3695 profiler = this.minecraft.method_16011();
        profiler.method_15396("extrabotany-hud");
        float f = this.minecraft.method_1534();
        this.scopeScale = class_3532.method_16439((float)(0.5f * f), (float)this.scopeScale, (float)1.125f);
        if (this.minecraft.field_1690.method_31044().method_31034()) {
            if (this.shouldRenderCameraGUI()) {
                profiler.method_15396("camera-hud");
                CameraItem.Hud.renderSpyglassOverlay(gui, this.scopeScale);
                profiler.method_15407();
            } else {
                this.scopeScale = 0.5f;
            }
        }
        profiler.method_15396("boss-bar");
        this.bossOverlay.render(gui);
        profiler.method_15407();
        profiler.method_15396("manaBar");
        this.renderManaBar(gui, partialTicks);
        profiler.method_15407();
        profiler.method_15407();
    }

    private void renderManaBar(class_332 gui, float partialTicks) {
        class_746 player = this.minecraft.field_1724;
        if (player.method_7325()) {
            return;
        }
        BigDecimal totalMana = BigDecimal.ZERO;
        BigDecimal totalMaxMana = BigDecimal.ZERO;
        boolean anyRequest = false;
        class_1661 mainInv = player.method_31548();
        class_1263 accInv = BotaniaAPI.instance().getAccessoriesInventory((class_1657)player);
        int invSize = mainInv.method_5439();
        int size = invSize + accInv.method_5439();
        for (int i = 0; i < size; ++i) {
            boolean useAccessories = i >= invSize;
            Object inv = useAccessories ? accInv : mainInv;
            class_1799 stack = inv.method_5438(i - (useAccessories ? invSize : 0));
            if (stack.method_7960()) continue;
            anyRequest = anyRequest || stack.method_31573(BotaniaTags.Items.MANA_USING_ITEMS);
        }
        List items = ManaItemHandler.instance().getManaItems((class_1657)player);
        List acc = ManaItemHandler.instance().getManaAccesories((class_1657)player);
        for (class_1799 stack : Iterables.concat((Iterable)items, (Iterable)acc)) {
            ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
            if (manaItem.isNoExport()) continue;
            totalMana = totalMana.add(BigDecimal.valueOf(manaItem.getMana()));
            totalMaxMana = totalMaxMana.add(BigDecimal.valueOf(manaItem.getMaxMana()));
        }
        if (anyRequest && !totalMaxMana.equals(BigDecimal.ZERO)) {
            HUD.renderManaInvBar(gui, totalMana.divide(totalMaxMana, 3, RoundingMode.HALF_UP).floatValue());
        }
    }

    private static void renderManaInvBar(class_332 gui, float progress) {
        class_310 mc = class_310.method_1551();
        int width = 182;
        int x = mc.method_22683().method_4486() / 2 - width / 2;
        int y = mc.method_22683().method_4502() - BotaniaConfig.client().manaBarHeight();
        if ((width = (int)((double)width * (double)progress)) == 0) {
            width = 1;
        }
        int color = class_3532.method_15369((float)0.55f, (float)((float)Math.min(1.0, Math.sin((double)class_156.method_658() / 200.0) * 0.5 + 1.0)), (float)1.0f);
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderSystem.setShaderColor((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)(1.0f - (float)r / 255.0f));
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        RenderHelper.drawTexturedModalRect((class_332)gui, (class_2960)manaBar, (int)x, (int)y, (int)0, (int)251, (int)width, (int)5);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private boolean shouldRenderCameraGUI() {
        class_1799 useItem = this.minecraft.field_1724.method_6030();
        if (useItem.method_7909() instanceof CameraItem) {
            return true;
        }
        class_1792 class_17922 = useItem.method_7909();
        if (class_17922 instanceof VoidArchivesItem) {
            VoidArchivesItem item = (VoidArchivesItem)class_17922;
            if (VoidArchivesItem.getVariant(useItem).getId().equals(Camera.INSTANCE.getId())) {
                return true;
            }
        }
        return false;
    }

    public static HUD getInstance() {
        return INSTANCE;
    }

    public ColorfulBossBarOverlay getBossOverlay() {
        return this.bossOverlay;
    }

    public static void onDisconnected() {
        HUD.getInstance().getBossOverlay().reset();
    }

    static {
        manaBar = class_2960.method_12829((String)"botania:textures/gui/mana_hud.png");
    }
}

