/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.client.integration.jei;

import io.github.lounode.extrabotany.api.recipe.ManaOutputRecipe;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.client.integration.jei.PedestalRecipeCategory;
import io.github.lounode.extrabotany.client.integration.jei.StonesiaRecipeCategory;
import io.github.lounode.extrabotany.common.block.ExtraBotanyBlocks;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.brew.BrewUtil;
import io.github.lounode.extrabotany.common.brew.ExtraBotanyBrews;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.item.ExtraBotanyItems;
import io.github.lounode.extrabotany.common.item.brew.ManaCocktailItem;
import io.github.lounode.extrabotany.common.item.relic.voidcore.CoreOfTheVoidItem;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import mezz.jei.api.runtime.IJeiRuntime;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3956;
import net.minecraft.class_7710;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.recipe.StateIngredient;
import vazkii.botania.client.integration.jei.ManaPoolRecipeCategory;
import vazkii.botania.client.integration.jei.PureDaisyRecipeCategory;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.brew.BaseBrewItem;

@JeiPlugin
public class JEIExtraBotanyPlugin
implements IModPlugin {
    private static final class_2960 ID = ResourceLocationHelper.prefix("main");
    private static final Comparator<class_1860<?>> BY_ID = Comparator.comparing(class_1860::method_8114);
    private static final Comparator<class_1860<?>> BY_GROUP = Comparator.comparing(class_1860::method_8112);
    private static final Comparator<PedestalRecipe> BY_SMASH_TOOLS = (l, r) -> {
        class_1856 left = l.getSmashTools();
        class_1856 right = r.getSmashTools();
        return left.toString().compareTo(right.toString());
    };

    public void registerItemSubtypes(@NotNull ISubtypeRegistration registry) {
        IIngredientSubtypeInterpreter interpreter = (stack, ctx) -> BaseBrewItem.getSubtype((class_1799)stack);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.manaCocktail, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.infiniteWine, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.holyWaterGrenade, interpreter);
        registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)ExtraBotanyItems.coreOfTheVoid, (stack, ctx) -> CoreOfTheVoidItem.getVariant(stack));
    }

    public void registerRecipes(@NotNull IRecipeRegistration registry) {
        registry.addRecipes(PedestalRecipeCategory.TYPE, JEIExtraBotanyPlugin.sortRecipes(ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE, BY_SMASH_TOOLS.thenComparing(BY_GROUP).thenComparing(BY_ID)));
        registry.addRecipes(StonesiaRecipeCategory.TYPE, JEIExtraBotanyPlugin.sortRecipes(ExtraBotanyRecipeTypes.STONESIA_RECIPE_TYPE, Comparator.comparing(ManaOutputRecipe::getManaOutput).thenComparing(BY_GROUP).thenComparing(BY_ID)).stream().filter(recipe -> {
            StateIngredient input = recipe.getInput();
            return !input.getDisplayed().isEmpty();
        }).collect(Collectors.toList()));
        this.registerCocktailRecipes(registry);
        this.registerInfiniteWineRecipes(registry);
        this.registerHolyWaterGrenadeRecipes(registry);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
    }

    public class_2960 getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new PedestalRecipeCategory(registry.getJeiHelpers().getGuiHelper()), new StonesiaRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        for (class_2248 pedestal : ExtraBotanyBlocks.ALL_PEDESTALS) {
            registry.addRecipeCatalyst(new class_1799((class_1935)pedestal), new RecipeType[]{PedestalRecipeCategory.TYPE});
        }
        registry.addRecipeCatalyst(new class_1799((class_1935)ExtrabotanyFlowerBlocks.stonesia), new RecipeType[]{StonesiaRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new class_1799((class_1935)ExtrabotanyFlowerBlocks.stonesiaFloating), new RecipeType[]{StonesiaRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new class_1799((class_1935)ExtraBotanyItems.pureDaisyPendant), new RecipeType[]{PureDaisyRecipeCategory.TYPE});
        registry.addRecipeCatalyst(new class_1799((class_1935)ExtraBotanyItems.lensSmelt), new RecipeType[]{RecipeTypes.SMELTING});
        registry.addRecipeCatalyst(new class_1799((class_1935)ExtraBotanyItems.lensMana), new RecipeType[]{ManaPoolRecipeCategory.TYPE});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        IRecipeManager manager = jeiRuntime.getRecipeManager();
        class_2960 recipeId = ResourceLocationHelper.prefix("das_rheingold_change_bind");
        List toHide = manager.createRecipeLookup(RecipeTypes.CRAFTING).get().filter(r -> r.method_8114().equals((Object)recipeId)).collect(Collectors.toList());
        if (!toHide.isEmpty()) {
            manager.hideRecipes(RecipeTypes.CRAFTING, toHide);
        }
    }

    private static <T extends class_1860<C>, C extends class_1263> List<T> sortRecipes(class_3956<T> type, Comparator<? super T> comparator) {
        Collection<T> recipes = ExtraBotanyRecipeTypes.getRecipes((class_1937)class_310.method_1551().field_1687, type).values();
        ArrayList<T> list = new ArrayList<T>(recipes);
        list.sort(comparator);
        return list;
    }

    private void registerCocktailRecipes(IRecipeRegistration registry) {
        ArrayList<class_1867> recipes = new ArrayList<class_1867>();
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == ExtraBotanyBrews.manaCocktail || brew == BotaniaBrews.fallbackBrew) continue;
            class_1799 cocktail = ManaCocktailItem.getDefaultCocktail();
            class_1799 flask = BotaniaItems.brewFlask.method_7854();
            BrewUtil.setBrew(flask, brew);
            class_2960 id = ResourceLocationHelper.prefix("mana_cocktail_change_brew");
            class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{class_1856.method_8101((class_1799[])new class_1799[]{cocktail}), class_1856.method_8101((class_1799[])new class_1799[]{flask})});
            class_1799 result = ExtraBotanyItems.manaCocktail.method_7854();
            BrewUtil.setBrew(result, brew);
            class_1867 compose = new class_1867(id, "mana_cocktail_change_brew", class_7710.field_40251, result, ingredients);
            recipes.add(compose);
        }
        registry.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    private void registerInfiniteWineRecipes(IRecipeRegistration registry) {
        ArrayList<class_1867> recipes = new ArrayList<class_1867>();
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == BotaniaBrews.fallbackBrew) continue;
            class_1799 cocktail = ExtraBotanyItems.manaCocktail.method_7854();
            BrewUtil.setBrew(cocktail, brew);
            if (brew == ExtraBotanyBrews.manaCocktail) {
                cocktail = ManaCocktailItem.getDefaultCocktail();
            }
            class_1799 medal = ExtraBotanyItems.heroMedal.method_7854();
            class_2960 id = ResourceLocationHelper.prefix("infinite_wine");
            class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{class_1856.method_8101((class_1799[])new class_1799[]{cocktail}), class_1856.method_8101((class_1799[])new class_1799[]{medal})});
            class_1799 result = ExtraBotanyItems.infiniteWine.method_7854();
            BrewUtil.setBrew(result, brew);
            class_1867 compose = new class_1867(id, "infinite_wine", class_7710.field_40251, result, ingredients);
            recipes.add(compose);
        }
        registry.addRecipes(RecipeTypes.CRAFTING, recipes);
    }

    private void registerHolyWaterGrenadeRecipes(IRecipeRegistration registry) {
        ArrayList<class_1867> recipes = new ArrayList<class_1867>();
        for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
            if (brew == BotaniaBrews.fallbackBrew) continue;
            class_1799 cocktail = ExtraBotanyItems.manaCocktail.method_7854();
            BrewUtil.setBrew(cocktail, brew);
            if (brew == ExtraBotanyBrews.manaCocktail) {
                cocktail = ManaCocktailItem.getDefaultCocktail();
            }
            class_1799 fruit = class_1802.field_8882.method_7854();
            class_2960 id = ResourceLocationHelper.prefix("holy_water_grenade");
            class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])new class_1856[]{class_1856.method_8101((class_1799[])new class_1799[]{cocktail}), class_1856.method_8101((class_1799[])new class_1799[]{fruit})});
            class_1799 result = ExtraBotanyItems.holyWaterGrenade.method_7854();
            BrewUtil.setBrew(result, brew);
            class_1867 compose = new class_1867(id, "holy_water_grenade", class_7710.field_40251, result, ingredients);
            recipes.add(compose);
        }
        registry.addRecipes(RecipeTypes.CRAFTING, recipes);
    }
}

