/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.block_entity;

import io.github.lounode.extrabotany.api.block.Charger;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.BellowsBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.xplat.BotaniaConfig;

public abstract class ChargerBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements Charger {
    public int tickCount;

    public ChargerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    protected class_1277 createItemHandler() {
        return new class_1277(1){

            public int method_5444() {
                return 1;
            }
        };
    }

    public class_1269 use(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (this.method_5442()) {
            class_1799 stack = player.method_5998(hand);
            if (!this.isValidItem(stack)) {
                return class_1269.field_5811;
            }
            class_1799 put = stack.method_7971(1);
            this.setItem(put);
            return class_1269.field_5812;
        }
        class_1799 get = this.getItem().method_7972();
        this.setItem(class_1799.field_8037);
        if (player.method_7270(get)) {
            this.playSound();
        } else {
            class_1264.method_5449((class_1937)world, (double)player.method_23317(), (double)player.method_23318(), (double)player.method_23321(), (class_1799)get);
        }
        return class_1269.field_5812;
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, ChargerBlockEntity self) {
        ManaPoolBlockEntity pool;
        if (self.tickCount % 10 == 0) {
            self.method_5431();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((class_2586)self);
        }
        if ((pool = self.getPool()) == null) {
            return;
        }
        class_2338 poolPos = pool.method_11016();
        ManaItem mana = EXplatAbstractions.INSTANCE.findManaItem(self.getItem());
        if (mana == null || !mana.canReceiveManaFromPool((class_2586)pool) && !mana.canExportManaToPool((class_2586)pool)) {
            return;
        }
        boolean didSomething = false;
        List<BellowsBlockEntity> bellows = self.getBellows(level, poolPos, pool);
        int bellowCount = bellows.size();
        int transferRate = 1000 * (bellowCount + 1);
        if (pool.isOutputtingPower() && mana.canReceiveManaFromPool((class_2586)pool)) {
            int output = pool.getCurrentMana();
            output = Math.min(output, mana.getMaxMana() - mana.getMana());
            if ((output = Math.min(output, transferRate)) > 0) {
                didSomething = true;
                mana.addMana(output);
                pool.receiveMana(-output);
            }
        } else if (mana.canExportManaToPool((class_2586)pool)) {
            int input = mana.getMana();
            input = Math.min(input, pool.getMaxMana() - pool.getCurrentMana());
            if ((input = Math.min(input, transferRate)) > 0) {
                didSomething = true;
                mana.addMana(-input);
                pool.receiveMana(input);
            }
        }
        if (didSomething) {
            if (self.tickCount % 10 == 0 && BotaniaConfig.common().chargingAnimationEnabled()) {
                self.chargeParticles();
            }
            for (BellowsBlockEntity bellow : bellows) {
                bellow.setActive(true);
            }
        }
        ++self.tickCount;
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, ChargerBlockEntity self) {
        ++self.tickCount;
    }

    public void chargeParticles() {
        ManaPoolBlockEntity pool = this.getPool();
        if (pool == null) {
            return;
        }
        class_2338 poolPos = pool.method_11016();
        this.field_11863.method_8427(poolPos, this.field_11863.method_8320(poolPos).method_26204(), pool.isOutputtingPower() ? 1 : 2, ChargerBlockEntity.encodeRelativeItemPosition(poolPos, (float)this.field_11867.method_10263() + 0.5f, this.field_11867.method_10264(), (float)this.field_11867.method_10260() + 0.5f));
    }

    @Override
    public void setItem(class_1799 stack) {
        this.method_5447(0, stack);
    }

    @Override
    public class_1799 getItem() {
        return this.method_5438(0);
    }

    @Override
    public float getChargeProcess() {
        ManaItem mana = EXplatAbstractions.INSTANCE.findManaItem(this.getItem());
        if (mana != null) {
            return (float)((double)mana.getMana() / (double)mana.getMaxMana());
        }
        return -1.0f;
    }

    public boolean method_5437(int index, class_1799 stack) {
        return this.isValidItem(stack);
    }

    private void playSound() {
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15248, 0.2f, ((this.field_11863.field_9229.method_43057() - this.field_11863.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
    }

    @Nullable
    public abstract ManaPoolBlockEntity getPool();

    public List<BellowsBlockEntity> getBellows(class_1937 level, class_2338 worldPosition, ManaPoolBlockEntity self) {
        ArrayList<BellowsBlockEntity> bellows = new ArrayList<BellowsBlockEntity>();
        for (class_2350 dir : class_2350.class_2353.field_11062) {
            BellowsBlockEntity bellow;
            class_2586 tile = level.method_8321(worldPosition.method_10093(dir));
            if (!(tile instanceof BellowsBlockEntity) || (bellow = (BellowsBlockEntity)tile).getLinkedTile() != self) continue;
            bellows.add(bellow);
        }
        return bellows;
    }

    private static int encodeRelativeItemPosition(class_2338 worldPosition, double x, double y, double z) {
        double relX = class_3532.method_15350((double)(x - (double)worldPosition.method_10263()), (double)0.0, (double)1.0);
        double relY = class_3532.method_15350((double)(0.125 + 0.875 * (y - (double)worldPosition.method_10264())), (double)0.125, (double)0.9);
        double relZ = class_3532.method_15350((double)(z - (double)worldPosition.method_10260()), (double)0.0, (double)1.0);
        int compressedX = (int)Math.round(7.0 * relX);
        int compressedY = 4 - class_3532.method_15342((int)(14 - (int)(14.0 * relY)));
        int compressedZ = (int)Math.round(7.0 * relZ);
        return compressedX | compressedY << 3 | compressedZ << 5;
    }
}

