/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.block_entity;

import com.google.common.base.Suppliers;
import io.github.lounode.extrabotany.api.block.Pedestal;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtend;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtendBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockTagPredicate;
import io.github.lounode.extrabotany.api.item.NatureEnergyItem;
import io.github.lounode.extrabotany.api.recipe.PedestalRecipe;
import io.github.lounode.extrabotany.common.block.PedestalBlock;
import io.github.lounode.extrabotany.common.block.block_entity.ExtraBotanyBlockEntities;
import io.github.lounode.extrabotany.common.crafting.ExtraBotanyRecipeTypes;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1303;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2715;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.block.block_entity.mana.ManaPoolBlockEntity;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.patchouli.api.IMultiblock;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.api.PatchouliAPI;

public class PedestalBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements Pedestal {
    public static final class_2338[] POOL_LOCATIONS = new class_2338[]{new class_2338(3, 0, 3), new class_2338(-3, 0, 3), new class_2338(3, 0, -3), new class_2338(-3, 0, -3)};
    public static final String[][] TIER1_PATTERN = new String[][]{{"P___P", "_____", "__0__", "_____", "P___P"}};
    public static final String[][] TIER2_PATTERN = new String[][]{{"P_____P", "_______", "_______", "_______", "_______", "_______", "P_____P"}, {"M_____M", "_P___P_", "_______", "___0___", "_______", "_P___P_", "M_____M"}, {"_______", "_SSSSS_", "_S___S_", "_S___S_", "_S___S_", "_SSSSS_", "_______"}};
    public static final Supplier<IMultiblock> TIER_1_PATCHOULI = Suppliers.memoize(() -> {
        IStateMatcher pedestal = PatchouliAPI.get().tagMatcher(ExtraBotanyTags.Blocks.PEDESTALS);
        return PatchouliAPI.get().makeMultiblock(TIER1_PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.naturaPylon, Character.valueOf('0'), pedestal});
    });
    public static final Supplier<IMultiblock> TIER_2_PATCHOULI = Suppliers.memoize(() -> {
        IStateMatcher pedestal = PatchouliAPI.get().tagMatcher(ExtraBotanyTags.Blocks.PEDESTALS);
        IStateMatcher manaPool = PatchouliAPI.get().tagMatcher(ExtraBotanyTags.Blocks.MANA_POOLS);
        IStateMatcher any = PatchouliAPI.get().anyMatcher();
        return PatchouliAPI.get().makeMultiblock(TIER2_PATTERN, new Object[]{Character.valueOf('P'), BotaniaBlocks.naturaPylon, Character.valueOf('0'), pedestal, Character.valueOf('S'), BotaniaBlocks.shimmerrock, Character.valueOf('M'), manaPool});
    });
    public static final Predicate<class_2694>[][][] TIER_1_PATTERN = BlockPatternExtendBuilder.start().aisle(TIER1_PATTERN[0]).where('_', class_2694.method_11678((Predicate)class_2715.field_12419)).where('0', class_2694.method_11678((Predicate)BlockTagPredicate.forTag(ExtraBotanyTags.Blocks.PEDESTALS))).where('P', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)BotaniaBlocks.naturaPylon))).createPattern();
    public static final Predicate<class_2694>[][][] TIER_2_PATTERN = BlockPatternExtendBuilder.start().aisle(TIER2_PATTERN[0]).aisle(TIER2_PATTERN[1]).aisle(TIER2_PATTERN[2]).where('_', class_2694.method_11678((Predicate)class_2715.field_12419)).where('0', class_2694.method_11678((Predicate)BlockTagPredicate.forTag(ExtraBotanyTags.Blocks.PEDESTALS))).where('P', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)BotaniaBlocks.naturaPylon))).where('S', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)BotaniaBlocks.shimmerrock))).where('M', class_2694.method_11678((Predicate)BlockTagPredicate.forTag(ExtraBotanyTags.Blocks.MANA_POOLS))).createPattern();
    public final int FINISH_CRAFT_STRIKE_FLAG = -1;
    public int tickCount;
    private int strikes;
    private int tier;
    private Map<class_1799, class_1533> automaticHammers = new HashMap<class_1799, class_1533>();

    public PedestalBlockEntity(class_2338 pos, class_2680 state) {
        this(ExtraBotanyBlockEntities.PEDESTAL, pos, state);
    }

    public PedestalBlockEntity(class_2591<? extends PedestalBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setStrikes(0);
    }

    protected class_1277 createItemHandler() {
        return new class_1277(1){

            public int method_5444() {
                return 1;
            }
        };
    }

    public class_1269 use(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        Function handler;
        if (hand == class_1268.field_5810) {
            return class_1269.field_5811;
        }
        List<Function> handlers = Arrays.asList(v -> this.handleExtractFinishItem(state, world, pos, player, hand, hit), v -> this.handleSmashNew(state, world, pos, player, hand, hit), v -> this.handleReversePlaceItem(state, world, pos, player, hand, hit), v -> this.handlePlaceItemNew(state, world, pos, player, hand, hit));
        Map.Entry<Object, Boolean> result = new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_21466, false);
        Iterator<Function> iterator = handlers.iterator();
        while (iterator.hasNext() && (result = (Map.Entry)(handler = iterator.next()).apply(null)).getKey() == class_1269.field_21466) {
        }
        player.method_6104((Boolean)result.getValue() != false ? class_1268.field_5810 : class_1268.field_5808);
        return (class_1269)result.getKey();
    }

    public Map.Entry<class_1269, Boolean> handleExtractFinishItem(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!this.method_5442() && this.strikes == -1) {
            class_1799 stack = this.extractPedestal();
            if (player.method_7270(stack)) {
                this.playSound();
            } else {
                class_1264.method_5449((class_1937)world, (double)player.method_23317(), (double)player.method_23318(), (double)player.method_23321(), (class_1799)stack);
            }
            return new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_33562, false);
        }
        return new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_21466, false);
    }

    public Map.Entry<class_1269, Boolean> handleSmashNew(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean swingOffHand = false;
        if (!this.method_5442()) {
            class_1799 mainHandItem = player.method_6047();
            class_1799 offHandItem = player.method_6079();
            boolean denyInteraction = false;
            for (class_1860 class_18602 : ExtraBotanyRecipeTypes.getRecipes(this.field_11863, ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE).values()) {
                PedestalRecipe recipe;
                if (!(class_18602 instanceof PedestalRecipe) || !(recipe = (PedestalRecipe)class_18602).getSmashTools().method_8093(mainHandItem) && !recipe.getSmashTools().method_8093(offHandItem)) continue;
                denyInteraction = true;
                if (!recipe.getInput().method_8093(this.getItem())) continue;
                class_1799 smashTools = null;
                if (recipe.getSmashTools().method_8093(mainHandItem)) {
                    smashTools = mainHandItem;
                } else if (recipe.getSmashTools().method_8093(offHandItem)) {
                    smashTools = offHandItem;
                    swingOffHand = true;
                }
                boolean finalSwingOffHand = swingOffHand;
                int expBoost = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)smashTools);
                int efficiency = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)smashTools);
                smashTools.method_7956(1, (class_1309)player, p -> p.method_20236(finalSwingOffHand ? class_1268.field_5810 : class_1268.field_5808));
                ++this.strikes;
                if (!this.field_11863.method_8608()) {
                    PlayerHelper.grantCriterion((class_3222)((class_3222)player), (class_2960)ResourceLocationHelper.prefix("main/goodtek"), (String)"code_triggered");
                }
                if (this.strikes > 0 && this.strikes < recipe.getStrike()) {
                    this.field_11863.method_8396(null, pos, class_3417.field_14658, class_3419.field_15248, 0.8f, ((player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
                    continue;
                }
                class_1799 output = recipe.getOutput().method_7972();
                this.setItem(output);
                this.field_11863.method_8396(null, pos, class_3417.field_15075, class_3419.field_15248, 0.8f, ((player.method_37908().field_9229.method_43057() - player.method_37908().field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
                if (!this.field_11863.method_8608()) {
                    PedestalBlockEntity.createExperience((class_3218)this.field_11863, player.method_19538(), recipe.getExp());
                }
                this.strikes = -1;
                break;
            }
            return denyInteraction ? new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_33562, swingOffHand) : new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_21466, swingOffHand);
        }
        return new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_21466, swingOffHand);
    }

    public Map.Entry<class_1269, Boolean> handleReversePlaceItem(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean swingOffHand = false;
        if (this.method_5442()) {
            boolean reversePriority = false;
            class_1799 mainHandItem = player.method_6047();
            if (!mainHandItem.method_7960()) {
                for (class_1860 class_18602 : ExtraBotanyRecipeTypes.getRecipes(this.field_11863, ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE).values()) {
                    PedestalRecipe recipe;
                    if (!(class_18602 instanceof PedestalRecipe) || !(recipe = (PedestalRecipe)class_18602).getSmashTools().method_8093(mainHandItem)) continue;
                    reversePriority = true;
                    break;
                }
            }
            if (reversePriority) {
                class_1799 offHandItem = player.method_6079();
                if (!offHandItem.method_7960()) {
                    this.insertPedestal(offHandItem);
                    this.playSound();
                    swingOffHand = true;
                } else if (!mainHandItem.method_7960()) {
                    this.insertPedestal(mainHandItem);
                    this.playSound();
                }
                return new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_33562, swingOffHand);
            }
        }
        return new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_21466, swingOffHand);
    }

    public Map.Entry<class_1269, Boolean> handlePlaceItemNew(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        boolean swingOffHand = false;
        if (this.method_5442()) {
            class_1799 mainHandItem = player.method_6047();
            class_1799 offHandItem = player.method_6079();
            if (!mainHandItem.method_7960()) {
                this.insertPedestal(mainHandItem);
                this.playSound();
            } else if (!offHandItem.method_7960()) {
                this.insertPedestal(offHandItem);
                this.playSound();
                swingOffHand = true;
            }
        } else {
            class_1799 stack = this.extractPedestal();
            if (player.method_7270(stack)) {
                this.playSound();
            } else {
                class_1264.method_5449((class_1937)world, (double)player.method_23317(), (double)player.method_23318(), (double)player.method_23321(), (class_1799)stack);
            }
        }
        return new AbstractMap.SimpleEntry<class_1269, Boolean>(class_1269.field_21466, swingOffHand);
    }

    private void playSound() {
        this.field_11863.method_8396(null, this.field_11867, class_3417.field_15197, class_3419.field_15248, 0.2f, ((this.field_11863.field_9229.method_43057() - this.field_11863.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
    }

    private static void createExperience(class_3218 world, class_243 pos, int amount) {
        class_1303.method_31493((class_3218)world, (class_243)pos, (int)amount);
    }

    public void insertPedestal(class_1799 itemStack) {
        class_1799 stack = itemStack.method_7971(1);
        this.setItem(stack);
    }

    public class_1799 extractPedestal() {
        class_1799 stack = this.getItem().method_7972();
        this.setItem(class_1799.field_8037);
        return stack;
    }

    @Override
    public class_1799 getItem() {
        return this.method_5438(0);
    }

    @Override
    public void setItem(class_1799 itemStack) {
        this.method_5447(0, itemStack);
    }

    public void method_5447(int index, class_1799 stack) {
        this.setStrikes(0);
        class_2680 state = this.method_11010();
        this.field_11863.method_8427(this.method_11016(), state.method_26204(), 0, 0);
        this.field_11863.method_43276(class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)PedestalBlock.HAS_ITEM, (Comparable)Boolean.valueOf(!stack.method_7960())), 3);
        super.method_5447(index, stack);
        this.markUpdated();
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public class_1799 method_5434(int index, int count) {
        this.setStrikes(0);
        class_2680 state = this.method_11010();
        this.field_11863.method_8427(this.method_11016(), state.method_26204(), 0, 0);
        this.field_11863.method_43276(class_5712.field_28733, this.method_11016(), class_5712.class_7397.method_43287((class_2680)this.method_11010()));
        this.field_11863.method_8652(this.method_11016(), (class_2680)state.method_11657((class_2769)PedestalBlock.HAS_ITEM, (Comparable)Boolean.valueOf(false)), 3);
        class_1799 superItemStack = super.method_5434(index, count);
        this.markUpdated();
        return superItemStack;
    }

    private void markUpdated() {
        this.method_5431();
        this.method_10997().method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, PedestalBlockEntity self) {
        NatureEnergyItem natureItem;
        if (self.tickCount % 10 == 0) {
            self.markUpdated();
        }
        if (self.tickCount % 100 == 0) {
            self.updateTier();
        }
        if ((natureItem = EXplatAbstractions.INSTANCE.findNatureEnergyItem(self.getItem())) != null) {
            int chargeAmount;
            if (self.tickCount % 20 == 0) {
                self.updateTier();
            }
            if ((chargeAmount = self.getChargeAmount()) > 0) {
                natureItem.addEnergy(chargeAmount);
                WispParticleData data = WispParticleData.wisp((float)0.5f, (float)0.15f, (float)0.8f, (float)0.15f);
                ((class_3218)level).method_14199((class_2394)data, (double)((float)pos.method_10263() + 0.5f), (double)((float)pos.method_10264() + 1.1f), (double)pos.method_10260() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        if (self.tickCount % 20 == 0) {
            class_1657 nearestPlayer;
            int lastHammers = self.automaticHammers.size();
            self.updateAutomaticHammers();
            if (lastHammers != self.automaticHammers.size() && self.automaticHammers.size() == 4 && (nearestPlayer = level.method_18459((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 10.0, false)) != null) {
                PlayerHelper.grantCriterion((class_3222)((class_3222)nearestPlayer), (class_2960)ResourceLocationHelper.prefix("main/kurukuru"), (String)"code_triggered");
            }
        }
        if (self.tickCount % 10 == 0 && !self.method_5442()) {
            class_1799 hammer;
            class_1533 frame;
            Iterator<class_1799> iterator = self.automaticHammers.keySet().iterator();
            while (!(!iterator.hasNext() || (frame = self.automaticHammers.get(hammer = iterator.next())) != null && frame.method_5805() && self.tryAutoSmash(hammer))) {
            }
        }
        ++self.tickCount;
    }

    public int getChargeAmount() {
        int amount = 0;
        if (this.getTier() >= 1) {
            amount += 4;
        }
        if (this.getTier() >= 2) {
            amount += 5;
            for (class_2338 pos : POOL_LOCATIONS) {
                ManaPoolBlockEntity pool;
                class_2586 tile = this.method_10997().method_8321(this.method_11016().method_10069(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                if (!(tile instanceof ManaPoolBlockEntity) || (pool = (ManaPoolBlockEntity)tile).getCurrentMana() < 10) continue;
                pool.receiveMana(-10);
                amount += 2;
            }
        }
        return amount;
    }

    public void updateTier() {
        this.setTier(0);
        if (new BlockPatternExtend(TIER_1_PATTERN).findFlat((class_4538)this.method_10997(), this.method_11016()) != null) {
            this.setTier(1);
        }
        if (new BlockPatternExtend(TIER_2_PATTERN).findFlat((class_4538)this.method_10997(), this.method_11016()) != null) {
            this.setTier(2);
        }
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public static void clientTick(class_1937 level, class_2338 worldPosition, class_2680 state, PedestalBlockEntity self) {
        ++self.tickCount;
    }

    public boolean tryAutoSmash(class_1799 hammer) {
        for (class_1860 class_18602 : ExtraBotanyRecipeTypes.getRecipes(this.field_11863, ExtraBotanyRecipeTypes.PEDESTAL_SMASH_TYPE).values()) {
            PedestalRecipe recipe;
            if (!(class_18602 instanceof PedestalRecipe) || !(recipe = (PedestalRecipe)class_18602).getSmashTools().method_8093(hammer)) continue;
            if (!recipe.getInput().method_8093(this.getItem())) {
                if (!class_1799.method_31577((class_1799)recipe.getOutput(), (class_1799)this.getItem())) continue;
                return false;
            }
            int expBoost = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)hammer);
            int efficiency = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)hammer);
            if (hammer.method_7963() && hammer.method_7970(1, this.field_11863.field_9229, null)) {
                this.automaticHammers.get(hammer).method_6935(class_1799.field_8037);
            }
            ++this.strikes;
            if (this.strikes > 0 && this.strikes < recipe.getStrike()) {
                this.field_11863.method_8396(null, this.field_11867, class_3417.field_14658, class_3419.field_15245, 0.8f, ((this.field_11863.field_9229.method_43057() - this.field_11863.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
                return true;
            }
            class_1799 output = recipe.getOutput().method_7972();
            this.setItem(output);
            this.field_11863.method_8396(null, this.field_11867, class_3417.field_15075, class_3419.field_15245, 0.8f, ((this.field_11863.field_9229.method_43057() - this.field_11863.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
            this.strikes = -1;
            return true;
        }
        return false;
    }

    public Map<class_1799, class_1533> getPerhapsHammers() {
        return this.field_11863.method_18467(class_1533.class, new class_238(this.field_11867).method_1014(2.0)).stream().filter(frame -> frame.method_6896().method_10093(frame.method_5735().method_10153()).equals((Object)this.field_11867)).filter(itemFrame -> !itemFrame.method_6940().method_7960()).collect(Collectors.toMap(class_1533::method_6940, itemFrame -> itemFrame, (oldFrame, newFrame) -> newFrame));
    }

    public void updateAutomaticHammers() {
        this.automaticHammers = this.getPerhapsHammers();
        if (this.automaticHammers == null) {
            this.automaticHammers = new HashMap<class_1799, class_1533>();
        }
    }

    @Override
    public int getStrikes() {
        return this.strikes;
    }

    @Override
    public void setStrikes(int strikes) {
        this.strikes = strikes;
    }

    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        this.setStrikes(tag.method_10550("strikes"));
    }

    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        tag.method_10569("strikes", this.strikes);
    }

    public int getAnalogOutputSignal() {
        return this.strikes == -1 ? 15 : 0;
    }

    public boolean method_5492(int i, class_1799 itemStack, @Nullable class_2350 direction) {
        return this.getItem().method_7960();
    }

    public boolean method_5493(int index, class_1799 stack, @Nullable class_2350 direction) {
        return this.strikes == -1;
    }

    public static class HUD {
    }
}

