/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import io.github.lounode.extrabotany.api.block.Pedestal;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_39;
import net.minecraft.class_47;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.PlayerHelper;

public class AnnoyingFlowerBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_FOOD = "food";
    private static final int RANGE = 3;
    public static final int MAX_MANA = 1000;
    public static final int FISHING_COST = 300;
    public static final int COOLDOWN_AFTER_WORK = 900;
    public static final int FOOD_BOOST_TIMES = 3;
    public static final double FOOD_BOOST_COOLDOWN_MULTIPLIER = 0.4;
    public static final int FOOD_BOOST_MAX = 12;
    @Nullable
    private class_2338 cachedPedestalPos;
    private int cooldown;
    private int boostLeft;

    public AnnoyingFlowerBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.ANNOYINGFLOWER, pos, state);
    }

    public void tickFlower() {
        boolean boosted;
        super.tickFlower();
        if (this.method_10997().method_8608()) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
        this.tryEatChicken();
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
            return;
        }
        if (this.getMaxMana() - this.getFishingCost() < 0) {
            return;
        }
        if (!this.hasWater()) {
            return;
        }
        boolean bl = boosted = this.getBoostLeft() > 0;
        if (boosted) {
            this.setBoostLeft(this.getBoostLeft() - 1);
        }
        class_5819 rand = this.method_10997().method_8409();
        class_1799 reward = this.getFishingLoot(boosted);
        int bound = 7;
        class_1542 entity = new class_1542(this.method_10997(), (double)(this.getEffectivePos().method_10263() - 3 + rand.method_43048(bound)), (double)(this.getEffectivePos().method_10264() + 2), (double)(this.getEffectivePos().method_10260() - 3 + rand.method_43048(bound)), reward);
        this.addMana(-this.getFishingCost());
        int cooldown = this.getCooldownAfterWork();
        if (boosted) {
            cooldown = (int)((double)cooldown * this.getFoodBoostCooldownMultiplier());
        }
        this.setCooldown(cooldown);
        this.method_10997().method_8649((class_1297)entity);
        this.method_10997().method_8396(null, this.getEffectivePos(), class_3417.field_14660, class_3419.field_15245, 1.0f, 1.0f);
        this.sync();
        if (boosted) {
            List players = PlayerHelper.getRealPlayersIn((class_1937)this.method_10997(), (class_238)new class_238(this.method_11016()).method_1014(16.0));
            for (class_1657 player : players) {
                if (PlayerHelper.hasAdvancement((class_3222)((class_3222)player), (class_2960)ResourceLocationHelper.prefix("main/muromi_san"))) continue;
                PlayerHelper.grantCriterion((class_3222)((class_3222)player), (class_2960)ResourceLocationHelper.prefix("main/muromi_san"), (String)"code_triggered");
            }
        }
    }

    public void tryEatChicken() {
        for (class_1542 item : this.method_10997().method_18467(class_1542.class, new class_238(this.getEffectivePos().method_10069(-3, -3, -3), this.getEffectivePos().method_10069(4, 4, 4)))) {
            class_1799 stack;
            if (!DelayHelper.canInteractWith((SpecialFlowerBlockEntity)this, (class_1542)item) || !(stack = item.method_6983()).method_31573(ExtraBotanyTags.Items.ANNOYING_FLOWER_EATABLE)) continue;
            EntityHelper.shrinkItem((class_1542)item);
            this.method_10997().method_8396(null, this.getEffectivePos(), class_3417.field_18060, class_3419.field_15245, 1.0f, SoundEventUtil.randomPitch(this.method_10997()));
            this.method_10997().method_33596(null, class_5712.field_28174, this.method_11016());
            int boostTime = Math.max(0, this.getBoostLeft() + this.getFoodBoostTimes());
            boostTime = Math.min(this.getFoodBoostMax(), boostTime);
            this.setBoostLeft(boostTime);
            this.sync();
            return;
        }
    }

    public class_1799 getFishingLoot(boolean boosted) {
        class_3218 level = (class_3218)this.method_10997();
        class_2338 pos = this.getEffectivePos();
        class_8567 params = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)class_1802.field_8378.method_7854()).method_51875(class_173.field_1176);
        class_47.class_48 builder = new class_47.class_48(params);
        class_2960 lootTable = boosted ? class_39.field_854 : class_39.field_353;
        ObjectArrayList loot = level.method_8503().method_3857().getLootTable(lootTable).method_51878(params);
        return loot.isEmpty() ? class_1799.field_8037 : (class_1799)loot.get(0);
    }

    public boolean hasWater() {
        class_2338 pos = this.getEffectivePos();
        if (this.cachedPedestalPos != null) {
            Pedestal pedestal;
            class_2586 tile = this.method_10997().method_8321(this.cachedPedestalPos);
            if (tile instanceof Pedestal && (pedestal = (Pedestal)tile).getItem().method_31574(class_1802.field_8705)) {
                return true;
            }
            this.cachedPedestalPos = null;
        }
        for (class_2338 pos_ : class_2338.method_10097((class_2338)pos.method_10069(-3, 0, -3), (class_2338)pos.method_10069(3, 3, 3))) {
            Pedestal pedestal;
            class_2586 tile = this.method_10997().method_8321(pos_);
            if (!(tile instanceof Pedestal) || !(pedestal = (Pedestal)tile).getItem().method_31574(class_1802.field_8705)) continue;
            this.cachedPedestalPos = pos_.method_10062();
            return true;
        }
        return false;
    }

    public double getFoodBoostCooldownMultiplier() {
        return ExtraBotanyConfig.common().annoyingflowerFoodBoostCooldownMultiplier();
    }

    public int getFoodBoostMax() {
        return ExtraBotanyConfig.common().annoyingflowerFoodBoostMax();
    }

    public int getFoodBoostTimes() {
        return ExtraBotanyConfig.common().annoyingflowerFoodBoostTimes();
    }

    public int getCooldownAfterWork() {
        return ExtraBotanyConfig.common().annoyingflowerCooldown();
    }

    public int getFishingCost() {
        return ExtraBotanyConfig.common().annoyingflowerFishingCost();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().annoyingflowerMaxMana();
    }

    public int getColor() {
        return 0;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((class_2338)this.getEffectivePos(), (int)3);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getBoostLeft() {
        return this.boostLeft;
    }

    public void setBoostLeft(int boostLeft) {
        this.boostLeft = boostLeft;
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_COOLDOWN, this.getCooldown());
        cmp.method_10569(TAG_FOOD, this.getBoostLeft());
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.setCooldown(cmp.method_10550(TAG_COOLDOWN));
        this.setBoostLeft(cmp.method_10550(TAG_FOOD));
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<AnnoyingFlowerBlockEntity> {
        public WandHud(AnnoyingFlowerBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(class_332 gui, class_310 mc) {
            class_5250 component = class_2561.method_43469((String)"message.extrabotany.gui.food_level", (Object[])new Object[]{((AnnoyingFlowerBlockEntity)this.flower).getBoostLeft()});
            int halfWidth = (mc.field_1772.method_27525((class_5348)component) + 24) / 2;
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
            gui.method_27535(mc.field_1772, (class_2561)component, centerX - halfWidth + 12, centerY + 34, 0xFFFFFF);
        }
    }
}

