/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;

public class EnchanterBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final String TAG_CONSUMED = "consumedMana";
    public static final int RANGE = 3;
    public static final int CONSUME_SPEED = 400;
    public static final int TRANSFORM_COST = 250000;
    private int consumedMana;

    public EnchanterBlockEntity(class_2591<? extends EnchanterBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public EnchanterBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.ENCHANTER, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().method_8608()) {
            return;
        }
        if (this.consumedMana < this.getTransformCost()) {
            int manaCanConsume = Math.min(this.getConsumeSpeed(), this.getMana());
            if (manaCanConsume > 0) {
                this.addMana(-manaCanConsume);
                this.setConsumedMana(this.getConsumedMana() + manaCanConsume);
                this.sync();
            }
            return;
        }
        if (this.ticksExisted % 20 != 0) {
            return;
        }
        class_2338 transformPos = this.getRandomPos();
        if (transformPos == null) {
            return;
        }
        this.method_10997().method_8501(transformPos, BotaniaBlocks.enchantedSoil.method_9564());
        this.setConsumedMana(0);
        this.sync();
    }

    @Nullable
    public class_2338 getRandomPos() {
        Object pos_2;
        HashMap<class_2338, Float> coordsMap = new HashMap<class_2338, Float>();
        Random rng = new Random();
        class_2338 pos = this.getEffectivePos();
        for (Object pos_2 : class_2338.method_10097((class_2338)pos.method_10069(-3, -3, -3), (class_2338)pos.method_10069(3, 3, 3))) {
            class_2680 state = this.method_10997().method_8320((class_2338)pos_2);
            class_2680 above = this.method_10997().method_8320(pos_2.method_10084());
            if (!state.method_27852(class_2246.field_10219) || !above.method_26215()) continue;
            coordsMap.put(pos_2.method_10062(), Float.valueOf(2.0f * rng.nextFloat()));
        }
        if (coordsMap.isEmpty()) {
            return null;
        }
        float maxDistance = 0.0f;
        pos_2 = coordsMap.values().iterator();
        while (pos_2.hasNext()) {
            float distance = ((Float)pos_2.next()).floatValue();
            maxDistance = Math.max(maxDistance, distance);
        }
        float finalMaxDistance = maxDistance;
        coordsMap.values().removeIf(dist -> dist.floatValue() < finalMaxDistance - 1.0f);
        ArrayList coords = new ArrayList(coordsMap.keySet());
        class_2338 breakCoords = (class_2338)coords.get(this.field_11863.method_8409().method_43048(coords.size()));
        return breakCoords;
    }

    public int getTransformCost() {
        return ExtraBotanyConfig.common().enchanterTransformCost();
    }

    public int getConsumeSpeed() {
        return ExtraBotanyConfig.common().enchanterConsumeSpeed();
    }

    public int getMaxMana() {
        return this.getConsumeSpeed() * 4;
    }

    public int getColor() {
        return 4915330;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((class_2338)this.getEffectivePos(), (int)3);
    }

    public int getConsumedMana() {
        return this.consumedMana;
    }

    public void setConsumedMana(int consumedMana) {
        this.consumedMana = consumedMana;
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_CONSUMED, this.getConsumedMana());
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.setConsumedMana(cmp.method_10550(TAG_CONSUMED));
    }

    public static class WandHUD
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<EnchanterBlockEntity> {
        public WandHUD(EnchanterBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(class_332 gui, class_310 mc, int minLeft, int minRight, int minDown) {
            String name = class_1074.method_4662((String)((EnchanterBlockEntity)this.flower).method_11010().method_26204().method_9539(), (Object[])new Object[0]);
            int color = ((EnchanterBlockEntity)this.flower).getColor();
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            int left = (Math.max(102, mc.field_1772.method_1727(name)) + 4) / 2;
            int right = left + 20;
            left = Math.max(left, minLeft);
            right = Math.max(right, minRight);
            RenderHelper.renderHUDBox((class_332)gui, (int)(centerX - left), (int)(centerY + 8), (int)(centerX + right), (int)(centerY + Math.max(30, minDown + 52)));
            BotaniaAPIClient.instance().drawComplexManaHUD(gui, color, ((EnchanterBlockEntity)this.flower).getConsumedMana(), ((EnchanterBlockEntity)this.flower).getTransformCost(), name, ((EnchanterBlockEntity)this.flower).getHudIcon(), ((EnchanterBlockEntity)this.flower).isValidBinding());
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)771);
            int arrowU = 0;
            int arrowV = 38;
            RenderHelper.drawTexturedModalRect((class_332)gui, (class_2960)HUDHandler.manaBar, (int)(centerX - 11), (int)(centerY + 34), (int)arrowU, (int)arrowV, (int)22, (int)15);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_1799 grass = new class_1799((class_1935)class_1802.field_8270);
            class_1799 enchanted = new class_1799((class_1935)BotaniaBlocks.enchantedSoil);
            gui.method_51427(grass, centerX - 31, centerY + 34);
            gui.method_51427(enchanted, centerX + 15, centerY + 34);
        }
    }
}

