/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtend;
import io.github.lounode.extrabotany.api.gaia.BlockPatternExtendBuilder;
import io.github.lounode.extrabotany.api.gaia.BlockTagPredicate;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_2715;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;
import net.minecraft.class_3481;
import net.minecraft.class_4208;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_6862;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.mana.ManaPool;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.xplat.XplatAbstractions;

public class ManalinkBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    public static final String[][] PATTERN = new String[][]{{"QQQQQ", "QLOLQ", "QODOQ", "QLOLQ", "QQQQQ"}};
    public static final String[][] PATCHOULI_PATTERN = new String[][]{{"AAAAA", "AAAAA", "AA0AA", "AAAAA", "AAAAA"}, {"QQQQQ", "QLOLQ", "QODOQ", "QLOLQ", "QQQQQ"}};
    public static final BlockPatternExtend PATTERN_BUILTIN = new BlockPatternExtend(BlockPatternExtendBuilder.start().aisle(PATTERN[0]).where('D', class_2694.method_11678((Predicate)BlockTagPredicate.forTag((class_6862<class_2248>)class_3481.field_29822))).where('Q', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10153))).where('L', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10441))).where('O', class_2694.method_11678((Predicate)class_2715.method_11758((class_2248)class_2246.field_10540))).createPattern());
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String TAG_LINK_POS = "linkPos";
    public static final int TRANSFER_SPEED = 400;
    @Nullable
    private class_4208 linkPos = null;

    public ManalinkBlockEntity(class_2591<? extends ManalinkBlockEntity> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public ManalinkBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.MANALINK, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().method_8608()) {
            return;
        }
        if (this.getMana() <= 0) {
            return;
        }
        class_4208 pos = this.linkPos;
        if (pos == null) {
            return;
        }
        ManaPool pool = this.getManaPool(this.method_10997().method_8503(), pos);
        if (pool == null) {
            return;
        }
        if (this.findBoundTile() != null && this.findBoundTile() == pool) {
            return;
        }
        if (PATTERN_BUILTIN.findFlat((class_4538)this.method_10997(), this.method_11016().method_10074()) == null) {
            return;
        }
        int transferMana = Math.min(this.getTransferSpeed(), this.getMana());
        int poolCanReceiveMana = pool.getMaxMana() - pool.getCurrentMana();
        if ((transferMana = Math.min(transferMana, poolCanReceiveMana)) > 0) {
            this.addMana(-transferMana);
            pool.receiveMana(transferMana);
            this.sync();
        }
    }

    @Nullable
    private ManaPool getManaPool(@Nullable MinecraftServer server, class_4208 pos) {
        ManaReceiver receiver;
        if (server == null) {
            return null;
        }
        class_5321 type = pos.method_19442();
        class_3218 world = server.method_3847(type);
        if (world != null && (receiver = XplatAbstractions.INSTANCE.findManaReceiver((class_1937)world, pos.method_19446(), null)) instanceof ManaPool) {
            ManaPool pool = (ManaPool)receiver;
            return pool;
        }
        return null;
    }

    public int getTransferSpeed() {
        return ExtraBotanyConfig.common().manalinkTransferSpeed();
    }

    public int getMaxMana() {
        return this.getTransferSpeed() * 2;
    }

    public int getColor() {
        return 65535;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return null;
    }

    public Optional<class_4208> getLinkPos() {
        return Optional.ofNullable(this.linkPos);
    }

    public void setLinkPos(class_4208 pos) {
        this.linkPos = pos;
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        if (this.linkPos != null) {
            class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.linkPos).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> cmp.method_10566(TAG_LINK_POS, tag));
        }
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)cmp.method_10580(TAG_LINK_POS)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(this::setLinkPos);
    }

    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        return false;
    }

    public static class WandHUD
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<ManalinkBlockEntity> {
        public WandHUD(ManalinkBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(class_332 gui, class_310 mc, int minLeft, int minRight, int minDown) {
            float scale = 0.8f;
            class_4208 pos = ((ManalinkBlockEntity)this.flower).linkPos;
            if (pos == null) {
                super.renderHUD(gui, mc, minLeft, minRight, minDown);
                return;
            }
            class_5250 levelComponent = class_2561.method_43469((String)"message.extrabotany.actionbar.bind_to_pos", (Object[])new Object[]{String.valueOf(pos.method_19442().method_29177()) + String.format(" %d, %d, %d", pos.method_19446().method_10263(), pos.method_19446().method_10264(), pos.method_19446().method_10260())});
            int halfWidth = (int)((float)(mc.field_1772.method_27525((class_5348)levelComponent) + 24) / 2.0f * scale);
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
            gui.method_51448().method_22903();
            gui.method_51448().method_22905(scale, scale, 1.0f);
            gui.method_27535(mc.field_1772, (class_2561)levelComponent, (int)((float)(centerX - halfWidth + 12) / scale), (int)((float)(centerY + 34) / scale), class_124.field_1060.method_532().intValue());
            gui.method_51448().method_22909();
        }
    }
}

