/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.functional;

import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.util.PlayerUtil;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.xplat.BotaniaConfig;

public class WoodieniaBlockEntity
extends FunctionalFlowerBlockEntity {
    public static final String TAG_COOLDOWN = "cooldown";
    public static final String TAG_OWNER_UUID = "ownerUUID";
    private int cooldown;
    @Nullable
    private UUID ownerUUID;

    public WoodieniaBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.WOODIENIA, pos, state);
    }

    public boolean acceptsRedstone() {
        return true;
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().method_8608()) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
        if (this.redstoneSignal > 0) {
            return;
        }
        if (this.getCooldown() > 0) {
            --this.cooldown;
            return;
        }
        if (this.getMana() < this.getManaPerUse()) {
            return;
        }
        class_2338 breakCoords = this.getValidBreakPos();
        if (breakCoords == null) {
            return;
        }
        class_1657 player = null;
        if (this.getOwnerUUID().isPresent()) {
            player = PlayerUtil.createFakePlayer((class_3218)this.method_10997(), this.getOwnerUUID().get());
        }
        WoodieniaBlockEntity.breakBlock(this.method_10997(), breakCoords, player);
        this.setCooldown(this.getAfterEatCooldown());
        this.addMana(-this.getManaPerUse());
        this.sync();
    }

    @Nullable
    public class_2338 getValidBreakPos() {
        Object pos_2;
        HashMap<class_2338, Float> coordsMap = new HashMap<class_2338, Float>();
        Random rng = new Random();
        class_2338 pos = this.getEffectivePos();
        for (Object pos_2 : class_2338.method_10097((class_2338)pos.method_10069(-this.getRange().method_10263(), 0, -this.getRange().method_10260()), (class_2338)pos.method_10069(this.getRange().method_10263(), this.getRange().method_10264(), this.getRange().method_10260()))) {
            class_2680 state = this.method_10997().method_8320((class_2338)pos_2);
            if (!state.method_26164(class_3481.field_15475)) continue;
            coordsMap.put(pos_2.method_10062(), Float.valueOf(2.0f * rng.nextFloat()));
        }
        if (coordsMap.isEmpty()) {
            return null;
        }
        float maxDistance = 0.0f;
        pos_2 = coordsMap.values().iterator();
        while (pos_2.hasNext()) {
            float distance = ((Float)pos_2.next()).floatValue();
            maxDistance = Math.max(maxDistance, distance);
        }
        float finalMaxDistance = maxDistance;
        coordsMap.values().removeIf(dist -> dist.floatValue() < finalMaxDistance - 1.0f);
        ArrayList coords = new ArrayList(coordsMap.keySet());
        class_2338 breakCoords = (class_2338)coords.get(this.field_11863.method_8409().method_43048(coords.size()));
        return breakCoords;
    }

    protected static void breakBlock(class_1937 level, class_2338 pos, @Nullable class_1657 player) {
        class_2680 state = level.method_8320(pos);
        if (player != null) {
            ToolCommons.removeBlockWithDrops((class_1657)player, (class_1799)class_1799.field_8037, (class_1937)level, (class_2338)pos, b -> true);
        } else {
            level.method_22352(pos, true);
        }
        if (BotaniaConfig.common().blockBreakParticles()) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        }
        level.method_33596(null, class_5712.field_28165, pos);
    }

    public void setPlacedBy(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        if (placer instanceof class_1657) {
            class_1657 player = (class_1657)placer;
            this.setOwnerUUID(player.method_7334().getId());
        }
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int ticks) {
        this.cooldown = ticks;
    }

    public int getAfterEatCooldown() {
        return ExtraBotanyConfig.common().woodieniaCooldown();
    }

    public int getManaPerUse() {
        return ExtraBotanyConfig.common().woodieniaWorkManaCost();
    }

    public class_2382 getRange() {
        int[] range = ExtraBotanyConfig.common().woodieniaRange();
        return new class_2382(range[0], range[1], range[2]);
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().woodieniaMaxMana();
    }

    public int getColor() {
        return 0x664422;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Rectangle(this.getEffectivePos(), new class_238(this.getEffectivePos().method_10069(-this.getRange().method_10263(), 0, -this.getRange().method_10260()), this.getEffectivePos().method_10069(this.getRange().method_10263() + 1, 0, this.getRange().method_10260() + 1)));
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_COOLDOWN, this.getCooldown());
        this.getOwnerUUID().ifPresent(uuid -> cmp.method_25927(TAG_OWNER_UUID, uuid));
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.cooldown = cmp.method_10550(TAG_COOLDOWN);
        if (cmp.method_10545(TAG_OWNER_UUID)) {
            this.setOwnerUUID(cmp.method_25926(TAG_OWNER_UUID));
        }
    }

    public Optional<UUID> getOwnerUUID() {
        return this.ownerUUID == null ? Optional.empty() : Optional.of(this.ownerUUID);
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
    }
}

