/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.block.PassiveFlower;
import io.github.lounode.extrabotany.api.level.Wind;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.common.lib.ExtraBotanyTags;
import io.github.lounode.extrabotany.common.lib.ResourceLocationHelper;
import io.github.lounode.extrabotany.common.sounds.ExtraBotanySounds;
import io.github.lounode.extrabotany.common.util.SoundEventUtil;
import io.github.lounode.extrabotany.mixin.accessor.DaffomillBlockEntityAccessor;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.flower.functional.DaffomillBlockEntity;
import vazkii.botania.common.helper.PlayerHelper;

public class BellflowerBlockEntity
extends GeneratingFlowerBlockEntity
implements PassiveFlower {
    public static final String TAG_DYING = "dying";
    public static int MAX_MANA = 300;
    public static final double GENERATE_MODIFY = 1.0;
    private static final int SPACE_REQUIRE = 2;
    private static final double WIND_LEVEL_MODIFY = 0.5;
    private int passiveDecayTicks;
    private boolean dying;
    private int dyingTicks;

    public BellflowerBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.BELLFLOWER, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.isDying()) {
            this.sync();
            this.dyingAnime();
            ++this.dyingTicks;
            return;
        }
        if (this.method_10997().method_8608()) {
            return;
        }
        this.checkToDecay((SpecialFlowerBlockEntity)this);
        if (!this.method_10997().method_8311(this.getEffectivePos())) {
            return;
        }
        if (this.ticksExisted % 5 != 0) {
            return;
        }
        if (this.ticksExisted % 100 == 0 && this.method_10997().method_8409().method_43048(2) == 0) {
            this.method_10997().method_8396(null, this.getEffectivePos(), ExtraBotanySounds.BELL_FLOWER_RING, class_3419.field_15245, 0.5f, SoundEventUtil.randomPitch(this.method_10997()));
        }
        this.addMana(Math.max(0, this.getGenerateMana()));
        this.sync();
    }

    private void dyingAnime() {
        if (this.dyingTicks < 60) {
            if (this.dyingTicks % 10 == 0) {
                for (int i = 0; i < 3; ++i) {
                    double offsetX = this.method_10997().method_8409().method_43058() * 2.0 - 1.0;
                    double offsetY = this.method_10997().method_8409().method_43058() * 0.5;
                    double offsetZ = this.method_10997().method_8409().method_43058() * 2.0 - 1.0;
                    class_243 particlePos = class_243.method_24953((class_2382)this.method_11016()).method_1031(offsetX, offsetY, offsetZ);
                    this.method_10997().method_8406((class_2394)class_2398.field_11231, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.05, 0.0);
                }
            }
            return;
        }
        if (this.method_10997().method_8608()) {
            return;
        }
        this.method_10997().method_22352(this.method_11016(), false);
        if (class_2246.field_10428.method_9564().method_26184((class_4538)this.method_10997(), this.method_11016())) {
            this.method_10997().method_8501(this.method_11016(), class_2246.field_10428.method_9564());
        }
        List players = PlayerHelper.getRealPlayersIn((class_1937)this.method_10997(), (class_238)new class_238(this.method_11016()).method_1014(16.0));
        for (class_1657 player : players) {
            if (PlayerHelper.hasAdvancement((class_3222)((class_3222)player), (class_2960)ResourceLocationHelper.prefix("main/a_baldrupt"))) continue;
            PlayerHelper.grantCriterion((class_3222)((class_3222)player), (class_2960)ResourceLocationHelper.prefix("main/a_baldrupt"), (String)"code_triggered");
        }
    }

    public int getGenerateMana() {
        double windLevel = Wind.instance().getWindLevel(this.method_10997(), new class_243((double)this.getEffectivePos().method_10263(), (double)this.getEffectivePos().method_10264(), (double)this.getEffectivePos().method_10260()));
        double negativeBlockModify = this.countNegativeBlocks();
        return (int)((windLevel - negativeBlockModify) * this.getWindLevelModify() * this.getGenerateModify());
    }

    public int countNegativeBlocks() {
        int negative = 0;
        class_2338 pos = this.getEffectivePos();
        for (class_2338 pos_ : class_2338.method_10097((class_2338)pos.method_10069(-this.getSpaceRequire(), 0, -this.getSpaceRequire()), (class_2338)pos.method_10069(this.getSpaceRequire(), this.getSpaceRequire(), this.getSpaceRequire()))) {
            if (pos_.equals((Object)pos)) continue;
            class_2680 state = this.method_10997().method_8320(pos_);
            if (state.method_27852(ExtrabotanyFlowerBlocks.bellflower) || state.method_27852(ExtrabotanyFlowerBlocks.bellflowerFloating)) {
                ++negative;
            }
            if (!state.method_26215() && !state.method_26164(ExtraBotanyTags.Blocks.BELLFLOWER_IGNORE)) {
                ++negative;
            }
            if (!state.method_27852(BotaniaFlowerBlocks.daffomill) && !state.method_27852(BotaniaFlowerBlocks.daffomillFloating)) continue;
            this.checkBeBlew(pos_);
        }
        return negative;
    }

    public void checkBeBlew(class_2338 daffomillPos) {
        class_243 posVec;
        class_2586 tile = this.method_10997().method_8321(daffomillPos);
        if (!(tile instanceof DaffomillBlockEntity)) {
            return;
        }
        DaffomillBlockEntity daffomill = (DaffomillBlockEntity)tile;
        if (daffomill.redstoneSignal > 0) {
            return;
        }
        if (((DaffomillBlockEntityAccessor)daffomill).getWindTicks() <= 0) {
            return;
        }
        class_238 aabb = ((DaffomillBlockEntityAccessor)daffomill).extrabotany_aabbForOrientation();
        if (!aabb.method_1006(posVec = class_243.method_24953((class_2382)this.method_11016()))) {
            return;
        }
        this.dying = true;
    }

    public int getSpaceRequire() {
        return 2;
    }

    public double getWindLevelModify() {
        return 0.5;
    }

    public double getGenerateModify() {
        return ExtraBotanyConfig.common().bellflowerGenerateModify();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().bellflowerMaxMana();
    }

    public int getColor() {
        return 0xFFFF99;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return null;
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.setPassiveDecayTicks(cmp.method_10550("passiveDecayTicks"));
        this.dying = cmp.method_10577(TAG_DYING);
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569("passiveDecayTicks", this.getPassiveDecayTicks());
        cmp.method_10556(TAG_DYING, this.dying);
    }

    @Override
    public int getPassiveDecayTicks() {
        return this.passiveDecayTicks;
    }

    @Override
    public void setPassiveDecayTicks(int ticks) {
        this.passiveDecayTicks = ticks;
    }

    public boolean isDying() {
        return this.dying;
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<BellflowerBlockEntity> {
        public WandHud(BellflowerBlockEntity flower) {
            super((BindableSpecialFlowerBlockEntity)flower);
        }

        public void renderHUD(class_332 gui, class_310 mc) {
            double windLevel = Wind.instance().getWindLevel(((BellflowerBlockEntity)this.flower).method_10997(), new class_243((double)((BellflowerBlockEntity)this.flower).getEffectivePos().method_10263(), (double)((BellflowerBlockEntity)this.flower).getEffectivePos().method_10264(), (double)((BellflowerBlockEntity)this.flower).getEffectivePos().method_10260()));
            if (((BellflowerBlockEntity)this.flower).isDying()) {
                windLevel = 999.0;
            }
            class_5250 component = class_2561.method_43469((String)"message.extrabotany.chat.wind_level", (Object[])new Object[]{String.format("%.2f", windLevel)});
            int halfWidth = (mc.field_1772.method_27525((class_5348)component) + 24) / 2;
            int centerX = mc.method_22683().method_4486() / 2;
            int centerY = mc.method_22683().method_4502() / 2;
            super.renderHUD(gui, mc, halfWidth + 2, halfWidth + 2, 48);
            gui.method_27535(mc.field_1772, (class_2561)component, centerX - halfWidth + 12, centerY + 34, !((BellflowerBlockEntity)this.flower).isDying() ? 0xFFFFFF : class_124.field_1079.method_532());
        }
    }
}

