/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class BloodEnchantressBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final String TAG_BURN_TIME = "burnTime";
    private static final int RANGE = 1;
    public static final int MAX_MANA = 800;
    public static final int DENY_PRODUCE_LEVEL = 35;
    public static final int PRODUCE_MANA = 22;
    private int burnTime;
    private final LoadingCache<UUID, Integer> inhibitionEntityMap = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build(CacheLoader.from(() -> 0));

    public BloodEnchantressBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.BLOOD_ENCHANTRESS, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().method_8608()) {
            return;
        }
        if (this.getBurnTime() > 0) {
            this.generateTick();
            this.setBurnTime(this.getBurnTime() - 1);
            return;
        }
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        int inhibitionLevel = this.getInhibition();
        if (inhibitionLevel > 35) {
            return;
        }
        List<class_1309> entities = this.method_10997().method_18467(class_1309.class, new class_238(this.getEffectivePos()).method_1014(1.0)).stream().filter(class_1309::method_5805).toList();
        if (entities.isEmpty()) {
            return;
        }
        for (class_1309 entity : entities) {
            int entityDamagedTime = (Integer)this.inhibitionEntityMap.getUnchecked((Object)entity.method_5667());
            if (entityDamagedTime > 4 && entity.method_6051().method_43056()) continue;
            if (entityDamagedTime > 10) break;
            if (!entity.method_5643(this.method_10997().method_48963().method_48830(), 3.0f)) continue;
            this.addMana((int)(264.0f * (1.0f - 0.04f * (float)entityDamagedTime - 0.02f * (float)inhibitionLevel)));
            this.inhibitionEntityMap.put((Object)entity.method_5667(), (Object)(entityDamagedTime + 1));
            this.setBurnTime(this.getBurnTime() + 20);
            this.sync();
        }
    }

    public void generateTick() {
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        this.addMana(this.getProduceMana());
        this.sync();
    }

    public int getInhibition() {
        List<class_1309> entities = this.method_10997().method_18467(class_1309.class, new class_238(this.getEffectivePos()).method_1014(1.0)).stream().filter(class_1309::method_5805).toList();
        int inhibitionLevel = 0;
        for (class_1309 entity : entities) {
            int entityDamagedTime = (Integer)this.inhibitionEntityMap.getUnchecked((Object)entity.method_5667());
            inhibitionLevel += entityDamagedTime;
        }
        return inhibitionLevel;
    }

    public int getProduceMana() {
        return ExtraBotanyConfig.common().bloodEnchantressProduceMana();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().bloodEnchantressMaxMana();
    }

    public int getColor() {
        return 0x8B0000;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((class_2338)this.getEffectivePos(), (int)1);
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_BURN_TIME, this.getBurnTime());
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.setBurnTime(cmp.method_10550(TAG_BURN_TIME));
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }
}

