/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.mixin.accessor.LightningBoltAccessor;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class ReikarlilyBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_COOLDOWN = "cooldown";
    private static final String TAG_RESIDUAL_HEAT = "residualHeat";
    private static final String TAG_SPAWN_LIGHTNING_COOLDOWN = "spawnLightningCooldown";
    private static final int RANGE = 4;
    public static final int MAX_MANA = 12000;
    public static final int COOLDOWN = 3600;
    public static final int PRODUCE_MANA = 12000;
    public static final int RESIDUAL_HEAT_AFTER_PRODUCE = 1500;
    public static final int RESIDUAL_HEAT_PRODUCE_MANA = 45;
    public static final int SPAWN_LIGHTNING_COOLDOWN = 3600;
    private static final int INITIAL_SPAWN_LIGHTNING_COOLDOWN = 3600;
    private int cooldown;
    private int residualHeat;
    private int spawnLightningCooldown;

    public ReikarlilyBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.REIKARLILY, pos, state);
    }

    public void setPlacedBy(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.setPlacedBy(level, pos, state, placer, stack);
        this.setSpawnLightningCooldown(3600 + this.method_10997().method_8409().method_43048(400));
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().method_8608()) {
            return;
        }
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
        if (this.getResidualHeat() > 0) {
            this.addMana(this.getResidualHeatProduceMana());
            this.setResidualHeat(this.getResidualHeat() - 1);
        }
        if (this.getSpawnLightningCooldown() > 0) {
            this.setSpawnLightningCooldown(this.getSpawnLightningCooldown() - 1);
        }
        if (this.getCooldown() > 0) {
            this.setCooldown(this.getCooldown() - 1);
            return;
        }
        if (this.getSpawnLightningCooldown() <= 0 && this.trySpawnLightningBolt()) {
            this.setSpawnLightningCooldown(this.getAfterSpawnLightningCooldown());
        }
        if (this.resolveActiveProduce()) {
            this.setCooldown(this.getAfterWorkCooldown());
            this.setResidualHeat(this.getResidualHeatAfterProduce());
            this.addMana(this.getProduceMana());
        }
    }

    public boolean trySpawnLightningBolt() {
        if (!this.method_10997().method_8520(this.getEffectivePos())) {
            return false;
        }
        class_1538 lightningBolt = (class_1538)class_1299.field_6112.method_5883(this.method_10997());
        double xOffset = (this.method_10997().method_8409().method_43058() - 0.5) * 0.5;
        double zOffset = (this.method_10997().method_8409().method_43058() - 0.5) * 0.5;
        lightningBolt.method_24203((double)this.getEffectivePos().method_10263() + xOffset, (double)(this.getEffectivePos().method_10264() + 1), (double)this.getEffectivePos().method_10260() + zOffset);
        this.method_10997().method_8649((class_1297)lightningBolt);
        return true;
    }

    public boolean resolveActiveProduce() {
        boolean produce = false;
        List lightnings = this.method_10997().method_18467(class_1538.class, new class_238(this.getEffectivePos()).method_1014(4.0));
        for (class_1538 lightning : lightnings) {
            if (this.getMana() >= this.getMaxMana() || ((LightningBoltAccessor)lightning).isVisualOnly() || !lightning.method_5805()) continue;
            lightning.method_29498(true);
            produce = true;
            break;
        }
        return produce;
    }

    public int getAfterWorkCooldown() {
        return ExtraBotanyConfig.common().reikarlilyProduceCooldown();
    }

    public int getAfterSpawnLightningCooldown() {
        return ExtraBotanyConfig.common().reikarlilySpawnLightningCooldown();
    }

    public int getProduceMana() {
        return ExtraBotanyConfig.common().reikarlilyProduceMana();
    }

    public int getResidualHeatAfterProduce() {
        return ExtraBotanyConfig.common().reikarlilyPassiveGenerateTime();
    }

    public int getResidualHeatProduceMana() {
        return ExtraBotanyConfig.common().reikarlilyPassiveGenerateMana();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().reikarlilyMaxMana();
    }

    public int getColor() {
        return 205;
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_COOLDOWN, this.getCooldown());
        cmp.method_10569(TAG_RESIDUAL_HEAT, this.getResidualHeat());
        cmp.method_10569(TAG_SPAWN_LIGHTNING_COOLDOWN, this.getSpawnLightningCooldown());
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.setCooldown(cmp.method_10550(TAG_COOLDOWN));
        this.setResidualHeat(cmp.method_10550(TAG_RESIDUAL_HEAT));
        this.setSpawnLightningCooldown(cmp.method_10550(TAG_SPAWN_LIGHTNING_COOLDOWN));
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((class_2338)this.getEffectivePos(), (int)4);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setCooldown(int cooldown) {
        this.cooldown = cooldown;
    }

    public int getResidualHeat() {
        return this.residualHeat;
    }

    public void setResidualHeat(int heat) {
        this.residualHeat = heat;
    }

    public int getSpawnLightningCooldown() {
        return this.spawnLightningCooldown;
    }

    public void setSpawnLightningCooldown(int cooldown) {
        this.spawnLightningCooldown = cooldown;
    }
}

