/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import io.github.lounode.eventwrapper.EventsWrapper;
import io.github.lounode.eventwrapper.event.PlayLevelSoundEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;

public class ResoncundBlockEntity
extends GeneratingFlowerBlockEntity {
    public static final String TAG_SOUND_HEARD = "soundHeard";
    private static final int RANGE = 4;
    private static final int CACHE_SIZE = 32;
    private static final int MAX_PRODUCE = 500;
    private static final int MIN_PRODUCE = 0;
    public static final int MAX_MANA = 1200;
    public static final int MANA_LOSS_PER_HEARD = 50;
    private final LoadingCache<class_3414, Integer> SOUND_HEARD = CacheBuilder.newBuilder().maximumSize((long)this.getCacheSize()).expireAfterAccess(30L, TimeUnit.SECONDS).build(CacheLoader.from(() -> 0));

    public ResoncundBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ExtrabotanyFlowerBlocks.RESONCUND, pos, blockState);
        EventsWrapper.register((Object)((Object)this));
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.ticksExisted % 20 == 0) {
            this.sync();
        }
    }

    public void onSoundHeard(class_3414 soundEvent) {
        int count = (Integer)this.SOUND_HEARD.getUnchecked((Object)soundEvent);
        if (count > 0x7FFFFFFE) {
            count = 0;
        }
        int produce = this.getMaxProduce();
        produce -= this.getSoundHeard().get(soundEvent) * this.getLossPerHeard();
        produce = Math.max(this.getMinProduce(), produce);
        this.addMana(produce);
        this.SOUND_HEARD.put((Object)soundEvent, (Object)(count + 1));
    }

    public int getLossPerHeard() {
        return ExtraBotanyConfig.common().resoncundLossPerHeard();
    }

    public int getMinProduce() {
        return 0;
    }

    public int getMaxProduce() {
        return 500;
    }

    public int getCacheSize() {
        return 32;
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().resoncundMaxMana();
    }

    public int getColor() {
        return 16076207;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((class_2338)this.getEffectivePos(), (int)4);
    }

    public Map<class_3414, Integer> getSoundHeard() {
        return this.SOUND_HEARD.asMap();
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        class_2487 sounds = new class_2487();
        for (Map.Entry<class_3414, Integer> entry : this.getSoundHeard().entrySet()) {
            class_3414 sound = entry.getKey();
            int heards = entry.getValue();
            sounds.method_10569(sound.method_14833().toString(), heards);
        }
        cmp.method_10566(TAG_SOUND_HEARD, (class_2520)sounds);
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        class_2487 sounds = cmp.method_10562(TAG_SOUND_HEARD);
        ConcurrentHashMap soundHeard = new ConcurrentHashMap();
        for (String key : sounds.method_10541()) {
            if (soundHeard.size() >= this.getCacheSize()) break;
            class_2960 res = class_2960.method_12829((String)key);
            int heards = sounds.method_10550(key);
            if (heards < 0) continue;
            class_7923.field_41172.method_17966(res).ifPresent(soundEvent -> soundHeard.put(soundEvent, heards));
        }
        this.SOUND_HEARD.invalidateAll();
        this.SOUND_HEARD.putAll(soundHeard);
    }

    @SubscribeEventWrapper
    public void onPlayLevelSound(PlayLevelSoundEventWrapper.AtPosition event) {
        if (this.method_10997() == null) {
            return;
        }
        if (this.method_10997().method_8608()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (this.method_11015()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (event.getSound() == null) {
            return;
        }
        class_238 aabb = new class_238(this.getEffectivePos()).method_1014(4.0);
        if (aabb.method_1006(event.getPosition())) {
            this.onSoundHeard((class_3414)event.getSound().comp_349());
        }
    }

    @SubscribeEventWrapper
    public void onPlayLevelSound(PlayLevelSoundEventWrapper.AtEntity event) {
        if (this.method_10997() == null) {
            return;
        }
        if (this.method_10997().method_8608()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (this.method_11015()) {
            EventsWrapper.unregister((Object)((Object)this));
            return;
        }
        if (event.getSound() == null) {
            return;
        }
        class_238 aabb = new class_238(this.getEffectivePos()).method_1014(4.0);
        if (aabb.method_1006(event.getEntity().method_19538())) {
            this.onSoundHeard((class_3414)event.getSound().comp_349());
        }
    }
}

