/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.block.flower.generating;

import io.github.lounode.extrabotany.api.block.PassiveFlower;
import io.github.lounode.extrabotany.common.block.flower.ExtrabotanyFlowerBlocks;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import io.github.lounode.extrabotany.xplat.ExtraBotanyConfig;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.api.block_entity.SpecialFlowerBlockEntity;

public class TwinstarBlockEntity
extends GeneratingFlowerBlockEntity
implements PassiveFlower {
    public static final int RANGE = 1;
    public static final int MAX_MANA = 1000;
    public static final int TEMPERATURE_MIN = 0;
    public static final int TEMPERATURE_MAX = Integer.MAX_VALUE;
    public static final int COOLDOWN = 8;
    private int passiveDecayTicks;

    public TwinstarBlockEntity(class_2338 pos, class_2680 state) {
        super(ExtrabotanyFlowerBlocks.TWINSTAR, pos, state);
    }

    public void tickFlower() {
        super.tickFlower();
        if (this.method_10997().method_8608()) {
            return;
        }
        this.checkToDecay((SpecialFlowerBlockEntity)this);
        if (this.getMana() >= this.getMaxMana()) {
            return;
        }
        if (this.ticksExisted % 8 != 0) {
            return;
        }
        int mana = this.getGenerateMana();
        if (mana <= 0) {
            return;
        }
        this.addMana(mana);
        this.sync();
    }

    public int getGenerateMana() {
        int thermoelectric = this.getThermoelectric();
        return (int)((float)thermoelectric / 100.0f);
    }

    public int getThermoelectric() {
        class_2338 _pos = this.getEffectivePos();
        int tempMax = 0;
        int tempMin = Integer.MAX_VALUE;
        for (class_2338 pos : class_2338.method_10097((class_2338)_pos.method_10069(-1, 0, -1), (class_2338)_pos.method_10069(1, 0, 1))) {
            class_3611 fluid = this.method_10997().method_8316(pos).method_15772();
            if (fluid.method_15780(class_3612.field_15906)) continue;
            int temp = EXplatAbstractions.INSTANCE.getFluidTemperature(fluid);
            tempMax = Math.max(tempMax, temp);
            tempMin = Math.min(tempMin, temp);
        }
        if (tempMax == 0 && tempMin == Integer.MAX_VALUE) {
            return 0;
        }
        return Math.min(this.getTemperatureMax(), tempMax) - Math.min(this.getTemperatureMin(), tempMin);
    }

    public int getTemperatureMax() {
        return ExtraBotanyConfig.common().twinstarMaxTemperature();
    }

    public int getTemperatureMin() {
        return ExtraBotanyConfig.common().twinstarMinTemperature();
    }

    public int getMaxMana() {
        return ExtraBotanyConfig.common().twinstarMaxMana();
    }

    public int getColor() {
        return 16575580;
    }

    @Nullable
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square((class_2338)this.getEffectivePos(), (int)1);
    }

    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.setPassiveDecayTicks(cmp.method_10550("passiveDecayTicks"));
    }

    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569("passiveDecayTicks", this.getPassiveDecayTicks());
    }

    @Override
    public int getPassiveDecayTicks() {
        return this.passiveDecayTicks;
    }

    @Override
    public void setPassiveDecayTicks(int ticks) {
        this.passiveDecayTicks = ticks;
    }
}

