/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.bossevents;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.lounode.extrabotany.common.bossevents.ColorfulBossEvent;
import io.github.lounode.extrabotany.network.clientbound.ColorfulBossEventPacket;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1259;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3532;

public class ServerColorfulBossEvent
extends ColorfulBossEvent {
    private final Set<class_3222> players = Sets.newHashSet();
    private boolean visible = true;

    public ServerColorfulBossEvent(class_2561 name, class_1259.class_1260 color, class_1259.class_1261 overlay) {
        super(class_3532.method_15394(), name, color, overlay);
    }

    public void method_5408(float progress) {
        if (progress != this.field_5774) {
            super.method_5408(progress);
            this.broadcast(ColorfulBossEventPacket::createUpdateProgressPacket);
        }
    }

    public void method_5416(class_1259.class_1260 color) {
        if (color != this.field_5778) {
            super.method_5416(color);
            this.broadcast(ColorfulBossEventPacket::createUpdateStylePacket);
        }
    }

    public void method_5409(class_1259.class_1261 overlay) {
        if (overlay != this.field_5779) {
            super.method_5409(overlay);
            this.broadcast(ColorfulBossEventPacket::createUpdateStylePacket);
        }
    }

    public class_1259 method_5406(boolean darkenSky) {
        if (darkenSky != this.field_5776) {
            super.method_5406(darkenSky);
            this.broadcast(ColorfulBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    public class_1259 method_5410(boolean playEndBossMusic) {
        if (playEndBossMusic != this.field_5775) {
            super.method_5410(playEndBossMusic);
            this.broadcast(ColorfulBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    public class_1259 method_5411(boolean createFog) {
        if (createFog != this.field_5773) {
            super.method_5411(createFog);
            this.broadcast(ColorfulBossEventPacket::createUpdatePropertiesPacket);
        }
        return this;
    }

    public void method_5413(class_2561 name) {
        if (!Objects.equal((Object)name, (Object)this.field_5777)) {
            super.method_5413(name);
            this.broadcast(ColorfulBossEventPacket::createUpdateNamePacket);
        }
    }

    protected void broadcast(Function<class_1259, ColorfulBossEventPacket> packetGetter) {
        if (this.visible) {
            ColorfulBossEventPacket packet = packetGetter.apply(this);
            for (class_3222 serverplayer : this.players) {
                EXplatAbstractions.INSTANCE.sendToPlayer(serverplayer, packet);
            }
        }
    }

    public void addPlayer(class_3222 player) {
        if (this.players.add(player) && this.visible) {
            EXplatAbstractions.INSTANCE.sendToPlayer(player, ColorfulBossEventPacket.createAddPacket(this));
        }
    }

    public void removePlayer(class_3222 player) {
        if (this.players.remove(player) && this.visible) {
            EXplatAbstractions.INSTANCE.sendToPlayer(player, ColorfulBossEventPacket.createRemovePacket(this.method_5407()));
        }
    }

    public void removeAllPlayers() {
        if (!this.players.isEmpty()) {
            for (class_3222 serverplayer : Lists.newArrayList(this.players)) {
                this.removePlayer(serverplayer);
            }
        }
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            for (class_3222 serverplayer : this.players) {
                EXplatAbstractions.INSTANCE.sendToPlayer(serverplayer, visible ? ColorfulBossEventPacket.createAddPacket(this) : ColorfulBossEventPacket.createRemovePacket(this.method_5407()));
            }
        }
    }

    public Set<class_3222> getPlayers() {
        return this.players;
    }
}

