/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.brew;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1292;
import net.minecraft.class_1293;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;

public class BrewUtil {
    public static final Brew EMPTY = BotaniaBrews.fallbackBrew;
    public static final String TAG_BREW_KEY = "brewKey";

    public static Brew getBrew(class_1799 stack) {
        String key = ItemNBTHelper.getString((class_1799)stack, (String)TAG_BREW_KEY, (String)"");
        class_2378 registry = BotaniaAPI.instance().getBrewRegistry();
        if (registry == null) {
            return BotaniaBrews.fallbackBrew;
        }
        class_2960 location = class_2960.method_12829((String)key);
        if (location == null) {
            return BotaniaBrews.fallbackBrew;
        }
        Brew brew = (Brew)registry.method_10223(location);
        return brew != null ? brew : BotaniaBrews.fallbackBrew;
    }

    public static void setBrew(class_1799 stack, Brew brew) {
        class_2960 id = Objects.requireNonNull(BotaniaAPI.instance().getBrewRegistry()).method_10221((Object)brew);
        ItemNBTHelper.setString((class_1799)stack, (String)TAG_BREW_KEY, (String)id.toString());
    }

    public static boolean hasInstantEffects(Brew brew) {
        if (!BrewUtil.getPotionEffects(brew).isEmpty()) {
            for (class_1293 mobeffectinstance : BrewUtil.getPotionEffects(brew)) {
                if (!mobeffectinstance.method_5579().method_5561()) continue;
                return true;
            }
        }
        return false;
    }

    public static List<class_1293> getPotionEffects(Brew brew) {
        if (!brew.getPotionEffects(new class_1799((class_1935)class_1802.field_8162)).isEmpty()) {
            return brew.getPotionEffects(new class_1799((class_1935)class_1802.field_8162));
        }
        return new ArrayList<class_1293>();
    }

    public static int getColor(Brew brew) {
        return brew.getColor(new class_1799((class_1935)class_1802.field_8162));
    }

    public static void addPotionTooltip(Brew brew, List<class_2561> lores, float durationFactor, int amplifierAddition) {
        List<class_1293> list = BrewUtil.getPotionEffects(brew);
        ArrayList list1 = Lists.newArrayList();
        if (list.isEmpty()) {
            lores.add((class_2561)class_2561.method_43471((String)"effect.none").method_27692(class_124.field_1080));
        } else {
            for (class_1293 effectinstance : list) {
                class_5250 iformattabletextcomponent = class_2561.method_43471((String)effectinstance.method_5586());
                class_1291 effect = effectinstance.method_5579();
                Map map = effect.method_5565();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        class_1322 attributemodifier = (class_1322)entry.getValue();
                        class_1322 attributemodifier1 = new class_1322(attributemodifier.method_6185(), effect.method_5563(effectinstance.method_5578() + amplifierAddition, attributemodifier), attributemodifier.method_6182());
                        list1.add(new Pair((Object)((class_1320)entry.getKey()), (Object)attributemodifier1));
                    }
                }
                if (effectinstance.method_5578() + amplifierAddition > 0) {
                    iformattabletextcomponent = class_2561.method_43469((String)"potion.withAmplifier", (Object[])new Object[]{iformattabletextcomponent, class_2561.method_43471((String)("potion.potency." + (effectinstance.method_5578() + amplifierAddition)))});
                }
                if (effectinstance.method_5584() > 20) {
                    iformattabletextcomponent = class_2561.method_43469((String)"potion.withDuration", (Object[])new Object[]{iformattabletextcomponent, class_1292.method_5577((class_1293)effectinstance, (float)durationFactor)});
                }
                lores.add((class_2561)iformattabletextcomponent.method_27692(effect.method_18792().method_18793()));
            }
        }
        if (!list1.isEmpty()) {
            lores.add((class_2561)class_2561.method_43473());
            lores.add((class_2561)class_2561.method_43471((String)"potion.whenDrank").method_27692(class_124.field_1064));
            for (Pair pair : list1) {
                class_1322 attributemodifier2 = (class_1322)pair.getSecond();
                double d0 = attributemodifier2.method_6186();
                double d1 = attributemodifier2.method_6182() != class_1322.class_1323.field_6330 && attributemodifier2.method_6182() != class_1322.class_1323.field_6331 ? attributemodifier2.method_6186() : attributemodifier2.method_6186() * 100.0;
                if (d0 > 0.0) {
                    lores.add((class_2561)class_2561.method_43469((String)("attribute.modifier.plus." + attributemodifier2.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1078));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                lores.add((class_2561)class_2561.method_43469((String)("attribute.modifier.take." + attributemodifier2.method_6182().method_6191()), (Object[])new Object[]{class_1799.field_8029.format(d1 *= -1.0), class_2561.method_43471((String)((class_1320)pair.getFirst()).method_26830())}).method_27692(class_124.field_1061));
            }
        }
    }
}

