/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.crafting;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.lounode.extrabotany.api.recipe.EntityIngredient;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_2540;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class EntityTypeIngredient
implements EntityIngredient {
    protected final ImmutableSet<class_1299<?>> entityTypes;

    public EntityTypeIngredient(Collection<class_1299<?>> entityTypes) {
        this.entityTypes = ImmutableSet.copyOf(entityTypes);
    }

    @Override
    public boolean test(class_1299<?> entityType) {
        return this.entityTypes.contains(entityType);
    }

    @Override
    public class_1299<?> pick(class_5819 random) {
        return (class_1299)this.entityTypes.asList().get(random.method_43048(this.entityTypes.size()));
    }

    @Override
    public JsonObject serialize() {
        JsonObject object = new JsonObject();
        object.addProperty("type", "entities");
        JsonArray array = new JsonArray();
        for (class_1299 type : this.entityTypes) {
            array.add(class_7923.field_41177.method_10221((Object)type).toString());
        }
        object.add("entities", (JsonElement)array);
        return object;
    }

    @Override
    public void write(class_2540 buffer) {
        List<class_1299<?>> entities = this.getEntities();
        buffer.method_10804(0);
        buffer.method_10804(entities.size());
        for (class_1299<?> type : entities) {
            buffer.method_10804(class_7923.field_41177.method_10206(type));
        }
    }

    @Override
    public List<class_1299<?>> getDisplayed() {
        return this.entityTypes.stream().toList();
    }

    public List<class_1299<?>> getEntities() {
        return this.entityTypes.asList();
    }

    public String toString() {
        return "EntityTypeIngredient{" + String.valueOf(this.entityTypes) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.entityTypes.equals(((EntityTypeIngredient)o).entityTypes);
    }

    public int hashCode() {
        return Objects.hash(this.entityTypes);
    }
}

