/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity;

import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1937;
import net.minecraft.class_2261;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.helper.VecHelper;

public class SkullMissileEntity
extends class_1682 {
    public static final int MAX_LIVING_TIME = 100;
    private static final String TAG_FIRE = "Fire";
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_TARGET = "Target";
    private boolean fire;
    private int _ticksExisted = 0;
    private double lockX;
    private double lockY = -2.147483648E9;
    private double lockZ;
    @Nullable
    private UUID targetUUID;
    @Nullable
    private class_1297 cachedTarget;

    public SkullMissileEntity(class_1299<? extends SkullMissileEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public SkullMissileEntity(class_1937 level, double x, double y, double z) {
        super(ExtraBotanyEntityType.SKULL_MISSILE, x, y, z, level);
    }

    public SkullMissileEntity(class_1937 level, class_1309 shooter) {
        super(ExtraBotanyEntityType.SKULL_MISSILE, shooter, level);
    }

    public void method_5773() {
        super.method_5773();
        this.particle();
        if (this.method_37908().method_8608()) {
            return;
        }
        if (this.getTarget().isEmpty() || this.getTicksExisted() > 100) {
            this.method_31472();
            return;
        }
        this.getTarget().ifPresent(target -> {
            if (this.lockY == -2.147483648E9) {
                this.lockX = target.method_23317();
                this.lockY = target.method_23318();
                this.lockZ = target.method_23321();
            }
            class_243 thisVec = VecHelper.fromEntityCenter((class_1297)this);
            class_243 targetVec = new class_243(this.lockX, this.lockY, this.lockZ);
            class_243 diffVec = targetVec.method_1020(thisVec);
            class_243 motionVec = diffVec.method_1029().method_1021(0.6);
            this.method_18799(motionVec);
            if (this.getTicksExisted() < 10) {
                this.method_18800(this.method_18798().method_10216(), Math.abs(this.method_18798().method_10214()), this.method_18798().method_10215());
            }
        });
        this.setTicksExisted(this.getTicksExisted() + 1);
    }

    public boolean findTarget() {
        Optional<class_1297> target = this.getTarget();
        if (target.isPresent()) {
            class_1297 entity = target.get();
            if (entity.method_5805()) {
                return true;
            }
            this.setTarget(null);
        }
        double range = 15.0;
        class_238 bounds = new class_238(this.method_23312()).method_1014(range);
        class_1282 source = this.getDamageSource();
        Predicate<class_1297> vulnerableTo = e -> !e.method_5679(source);
        List entities = this.method_37908().method_8390(class_1657.class, bounds, class_1301.field_6157.and(vulnerableTo));
        class_1297 found = null;
        if (!entities.isEmpty()) {
            found = (class_1297)entities.get(this.method_37908().field_9229.method_43048(entities.size()));
            this.setTarget(found);
        }
        return found != null;
    }

    protected void method_24920(class_3965 hit) {
        super.method_24920(hit);
        if (this.method_37908().method_8608()) {
            return;
        }
        class_2680 state = this.method_37908().method_8320(hit.method_17777());
        if (state.method_26204() instanceof class_2261) {
            return;
        }
        if (state.method_26164(class_3481.field_15503)) {
            return;
        }
        this.method_31472();
    }

    protected void method_7454(class_3966 hit) {
        super.method_7454(hit);
        if (this.method_37908().method_8608()) {
            return;
        }
        this.getTarget().ifPresent(target -> {
            if (hit.method_17782() == target) {
                target.method_5643(this.getDamageSource(), 12.0f);
                this.method_31472();
            }
        });
    }

    protected class_1282 getDamageSource() {
        class_1297 owner = this.method_24921();
        if (owner instanceof class_1309) {
            class_1282 class_12822;
            class_1309 livingOwner = (class_1309)owner;
            if (owner instanceof class_1657) {
                class_1657 playerOwner = (class_1657)owner;
                class_12822 = this.method_48923().method_48802(playerOwner);
            } else {
                class_12822 = this.method_48923().method_48812(livingOwner);
            }
            return class_12822;
        }
        return this.method_48923().method_48830();
    }

    public void setTarget(@Nullable class_1297 target) {
        this.cachedTarget = target;
        this.targetUUID = target == null ? null : target.method_5667();
    }

    public Optional<class_1297> getTarget() {
        class_1937 class_19372;
        if (this.cachedTarget != null && !this.cachedTarget.method_31481()) {
            return Optional.of(this.cachedTarget);
        }
        if (this.targetUUID != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.cachedTarget = serverLevel.method_14190(this.targetUUID);
            return this.cachedTarget != null ? Optional.of(this.cachedTarget) : Optional.empty();
        }
        return Optional.empty();
    }

    protected void particle() {
        if (!this.method_37908().method_8608()) {
            return;
        }
        double lastTickPosX = this.field_6038;
        double lastTickPosY = this.field_5971;
        double lastTickPosZ = this.field_5989;
        class_243 thisVec = VecHelper.fromEntityCenter((class_1297)this);
        class_243 oldPos = new class_243(lastTickPosX, lastTickPosY, lastTickPosZ);
        class_243 diff = thisVec.method_1020(oldPos);
        class_243 step = diff.method_1029().method_1021(0.05);
        int steps = (int)(diff.method_1033() / step.method_1033());
        class_243 particlePos = oldPos;
        SparkleParticleData data = SparkleParticleData.corrupt((float)0.8f, (float)1.0f, (float)0.0f, (float)1.0f, (int)2);
        for (int i = 0; i < steps; ++i) {
            this.method_37908().method_8406((class_2394)data, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 0.0, 0.0, 0.0);
            if (this.method_37908().field_9229.method_43048(steps) <= 1) {
                this.method_37908().method_8406((class_2394)data, particlePos.field_1352 + (Math.random() - 0.5) * 0.4, particlePos.field_1351 + (Math.random() - 0.5) * 0.4, particlePos.field_1350 + (Math.random() - 0.5) * 0.4, 0.0, 0.0, 0.0);
            }
            particlePos = particlePos.method_1019(step);
        }
    }

    protected void method_5693() {
    }

    protected void method_5652(class_2487 cmp) {
        super.method_5652(cmp);
        cmp.method_10556(TAG_FIRE, this.isFire());
        cmp.method_10569(TAG_TICKS_EXISTED, this.getTicksExisted());
        this.getTarget().ifPresent(target -> cmp.method_25927(TAG_TARGET, target.method_5667()));
    }

    protected void method_5749(class_2487 cmp) {
        super.method_5749(cmp);
        this.setFire(cmp.method_10577(TAG_FIRE));
        this.setTicksExisted(cmp.method_10550(TAG_TICKS_EXISTED));
        if (cmp.method_25928(TAG_TARGET)) {
            this.targetUUID = cmp.method_25926(TAG_TARGET);
            this.cachedTarget = null;
        }
    }

    public void setFire(boolean fire) {
        this.fire = fire;
    }

    public boolean isFire() {
        return this.fire;
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    public int getTicksExisted() {
        return this._ticksExisted;
    }

    public boolean method_30948() {
        return false;
    }

    public boolean method_5810() {
        return false;
    }

    public boolean method_5675() {
        return false;
    }
}

