/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.github.lounode.extrabotany.api.gaia.GaiaArena;
import io.github.lounode.extrabotany.common.bossevents.ServerGaiaBossEvent;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.gaia.GaiaAI;
import io.github.lounode.extrabotany.common.proxy.Proxy;
import io.github.lounode.extrabotany.common.telemetry.ExtraBotanyTelemetry;
import io.github.lounode.extrabotany.network.clientbound.SpawnGaiaPacket;
import io.github.lounode.extrabotany.xplat.EXplatAbstractions;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1101;
import net.minecraft.class_1113;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4208;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.helper.VecHelper;

public class Gaia
extends class_1588 {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final float MAX_HP = 320.0f;
    public static final float DAMAGE_CAP = 32.0f;
    private static final String TAG_INVUL_TIME = "InvulTime";
    private static final String TAG_HOME = "Home";
    private static final String TAG_PLAYER_COUNT = "PlayerCount";
    private static final String TAG_ARENA = "Arena";
    private static final String TAG_PLAYER_ATTACKED = "PlayersAttacked";
    private static final class_2940<Integer> INVUL_TIME = class_2945.method_12791(Gaia.class, (class_2941)class_2943.field_13327);
    protected int playerCount = 0;
    protected ServerGaiaBossEvent bossEvent;
    private final Set<UUID> playersWhoAttacked = new HashSet<UUID>();
    @NotNull
    private class_4208 home;
    @Nullable
    private GaiaArena arena;

    public Gaia(class_1299<? extends Gaia> type, class_1937 world) {
        super(type, world);
        this.field_6194 = 825;
        this.method_6033(this.method_6063());
        this.setHome(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)ManaBurst.NO_SOURCE));
        this.bossEvent = (ServerGaiaBossEvent)new ServerGaiaBossEvent(type.method_5897(), class_1259.class_1260.field_5788, class_1259.class_1261.field_5795).method_5411(true);
        if (world.field_9236) {
            Proxy.INSTANCE.addBoss((class_1309)this);
        }
    }

    public Gaia(class_1299<? extends Gaia> type, class_1937 world, class_2338 source) {
        this(type, world);
        this.setHome(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)source));
    }

    public Gaia(class_1937 world, class_2338 source) {
        this(ExtraBotanyEntityType.GAIA_LEGACY, world, source);
    }

    public static class_5132.class_5133 createGaiaAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23719, 0.4).method_26868(class_5134.field_23716, 320.0).method_26868(class_5134.field_23718, 1.0);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return GaiaAI.makeBrain(this, dynamic);
    }

    public class_4095<Gaia> method_18868() {
        return super.method_18868();
    }

    public static boolean spawn(class_1657 player, class_1799 stack, class_1937 world, class_2338 pos) {
        GaiaArena arena = GaiaArena.of(class_4208.method_19443((class_5321)world.method_27983(), (class_2338)pos));
        if (!arena.checksVanilla(player, world, pos)) {
            return false;
        }
        if (!world.method_8608()) {
            int playerCount;
            stack.method_7934(1);
            Gaia gaia = new Gaia(world, pos);
            gaia.setArena(arena);
            gaia.method_5814((double)pos.method_10263() + 0.5, pos.method_10264() + 3, (double)pos.method_10260() + 0.5);
            gaia.method_18868().method_24525(class_4140.field_38112, (Object)class_3902.field_17274, 160L);
            gaia.setInvulTime(160);
            gaia.bossEvent.method_5408(0.0f);
            gaia.method_6033(1.0f);
            List<class_1657> playersAround = arena.getPlayersAround(world);
            gaia.playerCount = playerCount = playersAround.size();
            gaia.bossEvent.setPlayerCount(playerCount);
            float healthMultiplier = 1.0f;
            if (playerCount > 1) {
                healthMultiplier += (float)playerCount * 0.25f;
            }
            gaia.method_5996(class_5134.field_23716).method_6192((double)(320.0f * healthMultiplier));
            gaia.method_5996(class_5134.field_23724).method_6192(15.0);
            gaia.method_5783(BotaniaSounds.gaiaSummon, 0.1f, 1.0f);
            gaia.method_5943((class_5425)world, world.method_8404(gaia.method_24515()), class_3730.field_16467, null, null);
            world.method_8649((class_1297)gaia);
            for (class_1657 nearbyPlayer : playersAround) {
                if (!(nearbyPlayer instanceof class_3222)) continue;
                class_3222 serverPlayer = (class_3222)nearbyPlayer;
                class_174.field_1182.method_9124(serverPlayer, (class_1297)gaia);
            }
        }
        return true;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        if (this.getHome().method_19446() == ManaBurst.NO_SOURCE) {
            this.setHome(class_4208.method_19443((class_5321)level.method_8410().method_27983(), (class_2338)this.findSafeHomePos()));
        }
        this.initMemories(level, difficulty, reason, spawnData, dataTag);
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    private class_2338 findSafeHomePos() {
        class_2338 spawnPos = this.method_23312();
        class_1937 level = this.method_37908();
        for (int i = 0; i <= 10; ++i) {
            class_2338 checkPos = spawnPos.method_10087(i);
            if (!level.method_8320(checkPos).method_51367()) continue;
            return checkPos.method_10084();
        }
        return spawnPos;
    }

    protected void initMemories(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        GaiaAI.initMemories(this, level.method_8410(), this.getHome().method_19446());
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1361((class_1308)this, class_1657.class, this.getArenaRange() * 1.5f));
    }

    protected void method_5958() {
        class_3218 serverlevel = (class_3218)this.method_37908();
        serverlevel.method_16107().method_15396("gaiaBrain");
        this.method_18868().method_19542(serverlevel, (class_1309)this);
        this.method_37908().method_16107().method_15407();
        super.method_5958();
        this.updateAI();
        int invul = this.getInvulTime();
        if (invul > 0) {
            this.setInvulTime(invul - 1);
        }
        this.bossEvent.method_5408(this.method_6032() / this.method_6063());
        if (this.method_5765()) {
            this.method_5848();
        }
        List<class_1657> players = this.getPlayersAround();
        for (class_1657 player : players) {
            if (player.method_6113()) {
                player.method_18400();
            }
            if (player.method_5765()) {
                player.method_5848();
            }
            this.getArena().ifPresent(arena -> player.method_31549().field_7479 &= player.method_31549().field_7477);
        }
    }

    protected void updateAI() {
        GaiaAI.updateActivity(this);
    }

    public void method_6007() {
        super.method_6007();
        if (this.arena != null && this.method_5805() && !this.method_5987()) {
            this.arena.tick(this);
        }
    }

    public boolean method_5643(@NotNull class_1282 source, float amount) {
        class_1297 e = source.method_5529();
        if (e instanceof class_1657) {
            class_1657 player = (class_1657)e;
            if (PlayerHelper.isTruePlayer((class_1297)e) && this.getInvulTime() == 0) {
                this.markPlayerAttacked(player);
                return super.method_5643(source, Math.min(this.getDamageCap(), amount));
            }
        }
        return false;
    }

    protected void method_6074(@NotNull class_1282 source, float amount) {
        super.method_6074(source, Math.min(this.getDamageCap(), amount));
        class_1297 attacker = source.method_5526();
        if (attacker != null) {
            class_243 thisVector = VecHelper.fromEntityCenter((class_1297)this);
            class_243 playerVector = VecHelper.fromEntityCenter((class_1297)attacker);
            class_243 motionVector = thisVector.method_1020(playerVector).method_1029().method_1021(0.75);
            if (this.method_6032() > 0.0f) {
                this.method_18800(-motionVector.field_1352, 0.5, -motionVector.field_1350);
            }
        }
        this.field_6008 = Math.max(this.field_6008, 20);
    }

    public void method_6078(@NotNull class_1282 source) {
        super.method_6078(source);
        class_1309 lastAttacker = this.method_6124();
        this.getArena().ifPresent(arena -> {
            arena.cleanup(this.method_37908());
            ExtraBotanyTelemetry.Event.onGaiaBattleFinish(this);
        });
        if (!this.method_37908().field_9236) {
            for (UUID u : this.getPlayersWhoAttacked()) {
                class_1282 currSource;
                class_1657 player = this.method_37908().method_18470(u);
                if (!PlayerHelper.isTruePlayer((class_1297)player)) continue;
                class_1282 class_12822 = currSource = player == lastAttacker ? source : player.method_48923().method_48802(player);
                if (player == lastAttacker) continue;
                class_174.field_1192.method_8990((class_3222)player, (class_1297)this, currSource);
            }
        }
        this.method_5783(BotaniaSounds.gaiaDeath, 1.0f, (1.0f + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2f) * 0.7f);
        this.method_37908().method_8406((class_2394)class_2398.field_11221, this.method_23317(), this.method_23318(), this.method_23321(), 1.0, 0.0, 0.0);
    }

    protected void method_16077(@NotNull class_1282 source, boolean wasRecentlyHit) {
        for (UUID u : this.playersWhoAttacked) {
            class_1657 player = this.method_37908().method_18470(u);
            if (!PlayerHelper.isTruePlayer((class_1297)player)) continue;
            class_1657 saveLastAttacker = this.field_6258;
            class_243 savePos = this.method_19538();
            this.field_6258 = player;
            this.method_5814(player.method_23317(), player.method_23318(), player.method_23321());
            super.method_16077(player.method_48923().method_48802(player), wasRecentlyHit);
            this.method_5814(savePos.method_10216(), savePos.method_10214(), savePos.method_10215());
            this.field_6258 = saveLastAttacker;
        }
    }

    protected float method_6132(class_1282 source, float damage) {
        return super.method_6132(source, Math.min(32.0f, damage));
    }

    public void method_6025(float amount) {
        if (this.getInvulTime() == 0) {
            super.method_6025(amount);
        }
    }

    public void method_5768() {
        this.method_6033(0.0f);
        this.bossEvent.method_5408(0.0f);
        this.getArena().ifPresent(arena -> arena.cleanup(this.method_37908()));
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (this.method_37908().field_9236) {
            Proxy.INSTANCE.removeBoss((class_1309)this);
        }
        super.method_5650(reason);
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossEvent.addPlayer(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossEvent.removePlayer(player);
    }

    protected void method_6070() {
        if (this.getInvulTime() == 0) {
            super.method_6070();
        }
    }

    public boolean method_5974(double dist) {
        return false;
    }

    public boolean method_5822() {
        return false;
    }

    public boolean method_5810() {
        return super.method_5810() && this.getInvulTime() == 0;
    }

    public boolean method_5931(class_1657 player) {
        return false;
    }

    protected boolean method_5860(class_1297 vehicle) {
        return false;
    }

    public boolean method_42149() {
        return true;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        this.bossEvent.method_5413(this.method_5476());
    }

    public List<class_1657> getPlayersAround() {
        return PlayerHelper.getRealPlayersIn((class_1937)this.method_37908(), (class_238)this.getArenaBB());
    }

    @NotNull
    private class_238 getArenaBB() {
        double range = this.getArena().map(GaiaArena::radius).orElse(Float.valueOf(this.getArenaRange())).floatValue() + 3.0f;
        class_2338 source = this.getHome().method_19446();
        return new class_238((double)source.method_10263() + 0.5, (double)source.method_10264() + 0.5, (double)source.method_10260() + 0.5, (double)source.method_10263() + 0.5, (double)source.method_10264() + 0.5, (double)source.method_10260() + 0.5).method_1014(range);
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public Optional<GaiaArena> getArena() {
        return Optional.ofNullable(this.arena);
    }

    protected void setArena(@Nullable GaiaArena arena) {
        this.arena = arena;
    }

    public void setInvulTime(int time) {
        this.field_6011.method_12778(INVUL_TIME, (Object)time);
        this.bossEvent.setGrainTime(time);
    }

    public int getInvulTime() {
        return (Integer)this.field_6011.method_12789(INVUL_TIME);
    }

    @NotNull
    public class_4208 getHome() {
        return this.home;
    }

    protected void setHome(@NotNull class_4208 pos) {
        this.home = pos;
    }

    public Set<UUID> getPlayersWhoAttacked() {
        return this.playersWhoAttacked;
    }

    public void markPlayerAttacked(class_1657 player) {
        if (PlayerHelper.isTruePlayer((class_1297)player)) {
            this.playersWhoAttacked.add(player.method_5667());
        }
    }

    public float getArenaRange() {
        return this.getArena().map(GaiaArena::radius).orElse(Float.valueOf(12.0f)).floatValue();
    }

    public float getDamageCap() {
        return 32.0f;
    }

    public int getEmergeTime() {
        return 160;
    }

    public void syncDataFormServer(GaiaSpawnData data) {
        this.playerCount = data.getPlayerCount();
        this.setHome(data.getHome());
        if (!ManaBurst.NO_SOURCE.equals((Object)data.getArena().center().method_19446())) {
            this.setArena(data.getArena());
            Proxy.INSTANCE.runOnClient(() -> () -> DopplegangerMusic.play(this));
        }
    }

    public class_2596<class_2602> method_18002() {
        GaiaSpawnData spawnData = new GaiaSpawnData();
        spawnData.setHome(this.getHome());
        spawnData.setPlayerCount(this.getPlayerCount());
        spawnData.setArena(this.getArena().orElse(GaiaArena.of(class_4208.method_19443((class_5321)this.method_37908().method_27983(), (class_2338)ManaBurst.NO_SOURCE))));
        return EXplatAbstractions.INSTANCE.toVanillaClientboundPacket(new SpawnGaiaPacket(new class_2604((class_1297)this), spawnData));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(INVUL_TIME, (Object)0);
    }

    public void method_5652(class_2487 cmp) {
        super.method_5652(cmp);
        cmp.method_10569(TAG_INVUL_TIME, this.getInvulTime());
        class_4208.field_25066.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getHome()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> cmp.method_10566(TAG_HOME, tag));
        this.getArena().flatMap(arena -> GaiaArena.CODEC.encodeStart((DynamicOps)class_2509.field_11560, arena).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0))).ifPresent(tag -> cmp.method_10566(TAG_ARENA, tag));
        cmp.method_10569(TAG_PLAYER_COUNT, this.playerCount);
        if (!this.getPlayersWhoAttacked().isEmpty()) {
            class_2499 players = new class_2499();
            for (UUID uuid : this.getPlayersWhoAttacked()) {
                players.add((Object)class_2512.method_25929((UUID)uuid));
            }
            cmp.method_10566(TAG_PLAYER_ATTACKED, (class_2520)players);
        }
    }

    public void method_5749(class_2487 cmp) {
        super.method_5749(cmp);
        this.setInvulTime(cmp.method_10550(TAG_INVUL_TIME));
        if (cmp.method_10545(TAG_HOME)) {
            this.setHome(class_4208.field_25066.parse((DynamicOps)class_2509.field_11560, (Object)cmp.method_10580(TAG_HOME)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(class_4208.method_19443((class_5321)this.method_37908().method_27983(), (class_2338)ManaBurst.NO_SOURCE)));
        } else {
            this.setHome(class_4208.method_19443((class_5321)this.method_37908().method_27983(), (class_2338)ManaBurst.NO_SOURCE));
        }
        if (cmp.method_10545(TAG_ARENA)) {
            this.setArena(GaiaArena.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)cmp.method_10580(TAG_ARENA)).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null));
        }
        this.playerCount = cmp.method_10545(TAG_PLAYER_COUNT) ? cmp.method_10550(TAG_PLAYER_COUNT) : 1;
        if (cmp.method_10573(TAG_PLAYER_ATTACKED, 9)) {
            class_2499 uuids = cmp.method_10554(TAG_PLAYER_ATTACKED, 9);
            this.getPlayersWhoAttacked().clear();
            for (class_2520 uuid : uuids) {
                this.playersWhoAttacked.add(class_2512.method_25930((class_2520)uuid));
            }
        }
        if (this.method_16914()) {
            this.bossEvent.method_5413(this.method_5476());
        }
    }

    public class_3414 getBGM() {
        return BotaniaSounds.gaiaMusic2;
    }

    public static class GaiaSpawnData {
        private int playerCount;
        private class_4208 home;
        private UUID bossInfoUUID;
        private GaiaArena arena;

        public GaiaArena getArena() {
            return this.arena;
        }

        public void setArena(GaiaArena arena) {
            this.arena = arena;
        }

        public int getPlayerCount() {
            return this.playerCount;
        }

        public void setPlayerCount(int playerCount) {
            this.playerCount = playerCount;
        }

        public class_4208 getHome() {
            return this.home;
        }

        public void setHome(class_4208 home) {
            this.home = home;
        }

        public UUID getBossInfoUUID() {
            return this.bossInfoUUID;
        }

        public void setBossInfoUUID(UUID bossInfoUUID) {
            this.bossInfoUUID = bossInfoUUID;
        }
    }

    private static class DopplegangerMusic
    extends class_1101 {
        private final Gaia guardian;

        private DopplegangerMusic(Gaia guardian) {
            super(guardian.getBGM(), class_3419.field_15247, class_1113.method_43221());
            this.guardian = guardian;
            this.field_5439 = guardian.getHome().method_19446().method_10263();
            this.field_5450 = guardian.getHome().method_19446().method_10264();
            this.field_5449 = guardian.getHome().method_19446().method_10260();
            this.field_5446 = true;
        }

        public static void play(Gaia guardian) {
            class_310.method_1551().method_1483().method_4873((class_1113)new DopplegangerMusic(guardian));
        }

        public void method_16896() {
            if (!this.guardian.method_5805()) {
                this.method_24876();
            }
        }
    }
}

