/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.Dynamic;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaCleanPlayerUnstableEffects;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaEmerging;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSmashBlocksAround;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnLandMine;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnMissile;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnMob;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaSpawnPixies;
import io.github.lounode.extrabotany.common.entity.gaia.behavior.GaiaTeleport;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;

public class GaiaAI {
    public static final int EMERGE_TIME = 160;
    protected static final int TELEPORT_DELAY_INITIAL = 30;
    protected static final int TELEPORT_DELAY = 35;
    protected static final float TELEPORT_RANGE = 12.0f;
    protected static final int LANDMINE_COUNTS = 6;
    protected static final int PIXIES_PRE_SPAWN_MAX = 6;
    protected static final float MOB_SPAWN_THRESHOLD = 0.2f;
    public static final int MOB_SPAWN_START_TICKS = 20;
    public static final int MOB_SPAWN_END_TICKS = 80;
    protected static final int MOB_SPAWN_BASE_TICKS = 800;
    public static final int MOB_SPAWN_TICKS = 900;
    public static final int MOB_SPAWN_WAVES = 10;
    public static final int MOB_SPAWN_WAVE_TIME = 80;
    protected static final List<class_4149<? extends class_4148<? super Gaia>>> SENSOR_TYPES = List.of(class_4149.field_18467, class_4149.field_18469);
    protected static final List<class_4140<?>> MEMORY_TYPES = List.of(class_4140.field_18441, class_4140.field_38112, class_4140.field_18445, class_4140.field_18446, ExtraBotanyMemoryType.TELEPORT_RANGE, ExtraBotanyMemoryType.TELEPORT_DELAY, ExtraBotanyMemoryType.TELEPORT_DELAY_BASE, ExtraBotanyMemoryType.LANDMINE_COUNT, ExtraBotanyMemoryType.PIXIES_MAX, ExtraBotanyMemoryType.MOB_SPAWN_TICKS, class_4140.field_18443, class_4140.field_18444, class_4140.field_22354, class_4140.field_18451);

    public static void updateActivity(Gaia gaia) {
        boolean isNotEmerging = !gaia.method_18868().method_18906(class_4168.field_38202);
        boolean lowHealth = gaia.method_6032() / gaia.method_6063() <= 0.2f;
        boolean hasSpawnTicks = gaia.method_18868().method_18896(ExtraBotanyMemoryType.MOB_SPAWN_TICKS);
        if (isNotEmerging && lowHealth && hasSpawnTicks) {
            gaia.method_18868().method_24526(class_4168.field_19041);
        } else {
            gaia.method_18868().method_24531((List)ImmutableList.of((Object)class_4168.field_38202, (Object)class_4168.field_22396));
        }
    }

    protected static class_4095<?> makeBrain(Gaia gaia, Dynamic<?> ops) {
        class_4095.class_5303 provider = class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
        class_4095 brain = provider.method_28335(ops);
        GaiaAI.initCoreActivity((class_4095<? extends Gaia>)brain);
        GaiaAI.initSpawnActivity((class_4095<? extends Gaia>)brain, 160);
        GaiaAI.initMobSpawnActivity((class_4095<? extends Gaia>)brain, 900);
        GaiaAI.initFightActivity((class_4095<? extends Gaia>)brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_38202);
        brain.method_24536();
        return brain;
    }

    protected static void initMemories(Gaia gaia, class_3218 level, class_2338 pos) {
        GaiaTeleport.initMemories(gaia.method_18868(), 12.0f, 35, 30);
        GaiaSpawnLandMine.initMemories(gaia.method_18868(), 6);
        GaiaSpawnPixies.initMemories(gaia.method_18868(), 6);
        gaia.method_18868().method_24525(ExtraBotanyMemoryType.MOB_SPAWN_TICKS, (Object)900, 900L);
    }

    protected static void initCoreActivity(class_4095<? extends Gaia> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f)));
    }

    protected static void initSpawnActivity(class_4095<? extends Gaia> brain, int emergeTime) {
        brain.method_24527(class_4168.field_38202, 1, ImmutableList.of(new GaiaEmerging(emergeTime)), class_4140.field_38112);
    }

    private static void initFightActivity(class_4095<? extends Gaia> brain) {
        brain.method_18882(class_4168.field_22396, 10, ImmutableList.of(new GaiaTeleport(), new GaiaSpawnMissile(), new GaiaSpawnLandMine(), new GaiaSpawnPixies(), new GaiaSmashBlocksAround(), new GaiaCleanPlayerUnstableEffects()));
    }

    private static void initMobSpawnActivity(class_4095<? extends Gaia> brain, int spawnTicks) {
        brain.method_24527(class_4168.field_19041, 5, ImmutableList.of(new GaiaSpawnMob(spawnTicks)), ExtraBotanyMemoryType.MOB_SPAWN_TICKS);
    }
}

