/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyEntityType;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.MagicLandMineEntity;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;

public class GaiaSpawnLandMine<E extends Gaia>
extends class_4097<E> {
    public static final int LANDMINE_COUNTS = 6;

    public GaiaSpawnLandMine() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18443, (Object)class_4141.field_18456, ExtraBotanyMemoryType.LANDMINE_COUNT, (Object)class_4141.field_18458, ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)class_4141.field_18458));
    }

    public static void initMemories(class_4095<? extends Gaia> brain, int mineCount) {
        brain.method_18878(ExtraBotanyMemoryType.LANDMINE_COUNT, (Object)mineCount);
    }

    protected boolean checkExtraStartConditions(class_3218 level, E gaia) {
        return this.getTeleportDelay((Gaia)((Object)gaia)) == 0;
    }

    protected void start(class_3218 level, E gaia, long gameTime) {
        this.spawnLandMines((Gaia)((Object)gaia));
    }

    protected void spawnLandMines(Gaia gaia) {
        int count = this.getLandMineCount(gaia);
        class_2338 source = gaia.getHome().method_19446();
        List<class_1657> players = this.getPlayers(gaia);
        if (players.isEmpty()) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            int x = source.method_10263() - 10 + gaia.method_6051().method_43048(20);
            int y = (int)players.get(gaia.method_6051().method_43048(players.size())).method_23318();
            int z = source.method_10260() - 10 + gaia.method_6051().method_43048(20);
            MagicLandMineEntity landmine = (MagicLandMineEntity)ExtraBotanyEntityType.MAGIC_LANDMINE.method_5883(gaia.method_37908());
            landmine.method_5814((double)x + 0.5, y, (double)z + 0.5);
            landmine.setOwner((class_1297)gaia);
            gaia.method_37908().method_8649((class_1297)landmine);
        }
    }

    protected int getTeleportDelay(Gaia gaia) {
        return gaia.method_18868().method_18904(ExtraBotanyMemoryType.TELEPORT_DELAY).orElse(35);
    }

    protected int getLandMineCount(Gaia gaia) {
        return gaia.method_18868().method_18904(ExtraBotanyMemoryType.LANDMINE_COUNT).orElse(6);
    }

    protected List<class_1657> getPlayers(Gaia gaia) {
        return gaia.method_18868().method_18904(class_4140.field_18443).orElse(new ArrayList());
    }
}

