/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.entity.gaia.behavior;

import com.google.common.collect.ImmutableMap;
import io.github.lounode.extrabotany.common.entity.ExtraBotanyMemoryType;
import io.github.lounode.extrabotany.common.entity.gaia.Gaia;
import java.util.Map;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_5819;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.MathHelper;

public class GaiaTeleport<E extends Gaia>
extends class_4097<E> {
    public static final int TELEPORT_DELAY = 35;
    public static final float TELEPORT_RANGE = 12.0f;

    public GaiaTeleport() {
        super((Map)ImmutableMap.of(ExtraBotanyMemoryType.TELEPORT_DELAY_BASE, (Object)class_4141.field_18458, ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)class_4141.field_18458, ExtraBotanyMemoryType.TELEPORT_RANGE, (Object)class_4141.field_18458, (Object)class_4140.field_18451, (Object)class_4141.field_18458));
    }

    public static void initMemories(class_4095<? extends Gaia> brain, float range, int delay, int initDelay) {
        brain.method_18878(ExtraBotanyMemoryType.TELEPORT_RANGE, (Object)Float.valueOf(range));
        brain.method_18878(ExtraBotanyMemoryType.TELEPORT_DELAY_BASE, (Object)delay);
        brain.method_18878(ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)initDelay);
    }

    protected boolean canStillUse(class_3218 level, E entity, long gameTime) {
        return true;
    }

    protected void start(class_3218 level, E gaia, long gameTime) {
    }

    protected void tick(class_3218 level, E gaia, long gameTime) {
        int delay = this.getTeleportDelay((Gaia)((Object)gaia));
        if (this.isHurt((Gaia)((Object)gaia))) {
            this.resolveHurt((Gaia)((Object)gaia));
        }
        if (delay > 0) {
            this.setTeleportDelay((Gaia)((Object)gaia), delay - 1);
            return;
        }
        this.randomTeleport((Gaia)((Object)gaia), this.getHome((Gaia)((Object)gaia)).method_19446(), this.getTeleportRange((Gaia)((Object)gaia)));
    }

    protected void randomTeleport(Gaia gaia, class_2338 source, float range) {
        double newZ;
        double newX;
        double oldX = gaia.method_23317();
        double oldY = gaia.method_23318();
        double oldZ = gaia.method_23321();
        double newY = source.method_10264();
        int tries = 0;
        do {
            newX = (double)source.method_10263() + (gaia.method_6051().method_43058() - 0.5) * (double)range;
            newZ = (double)source.method_10260() + (gaia.method_6051().method_43058() - 0.5) * (double)range;
        } while (++tries < 50 && MathHelper.pointDistanceSpace((double)newX, (double)newY, (double)newZ, (double)source.method_10263(), (double)source.method_10264(), (double)source.method_10260()) > range - 2.0f);
        if (tries == 50) {
            newX = (double)source.method_10263() + 0.5;
            newY = (double)source.method_10264() + 1.6;
            newZ = (double)source.method_10260() + 0.5;
        }
        class_2338 tentativeFloorPos = class_2338.method_49637((double)newX, (double)(newY - 1.0), (double)newZ);
        if (gaia.method_37908().method_8320(tentativeFloorPos).method_26220((class_1922)gaia.method_37908(), tentativeFloorPos).method_1110()) {
            newY -= 1.0;
        }
        gaia.method_5859(newX, newY, newZ);
        this.setTeleportDelay(gaia, this.getTeleportDelayBase(gaia));
        gaia.method_37908().method_43128(null, oldX, oldY, oldZ, BotaniaSounds.gaiaTeleport, gaia.method_5634(), 1.0f, 1.0f);
        gaia.method_5783(BotaniaSounds.gaiaTeleport, 1.0f, 1.0f);
        this.particles(gaia, new class_243(oldX, oldY, oldZ), new class_243(newX, newY, newZ));
    }

    protected void particles(Gaia gaia, class_243 oldPos, class_243 newPos) {
        class_5819 random = class_5819.method_43047();
        int particleCount = 128;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            float vx = (random.method_43057() - 0.5f) * 0.2f;
            float vy = (random.method_43057() - 0.5f) * 0.2f;
            float vz = (random.method_43057() - 0.5f) * 0.2f;
            double px = oldPos.method_10216() + (newPos.method_10216() - oldPos.method_10216()) * progress + (random.method_43058() - 0.5) * (double)gaia.method_17681() * 2.0;
            double py = oldPos.method_10214() + (newPos.method_10214() - oldPos.method_10214()) * progress + random.method_43058() * (double)gaia.method_17682();
            double pz = oldPos.method_10215() + (newPos.method_10215() - oldPos.method_10215()) * progress + (random.method_43058() - 0.5) * (double)gaia.method_17681() * 2.0;
            gaia.method_37908().method_8406((class_2394)class_2398.field_11214, px, py, pz, (double)vx, (double)vy, (double)vz);
        }
    }

    public class_4208 getHome(Gaia gaia) {
        return gaia.getHome();
    }

    public void setTeleportDelay(Gaia gaia, int tpDelay) {
        gaia.method_18868().method_18878(ExtraBotanyMemoryType.TELEPORT_DELAY, (Object)tpDelay);
    }

    public int getTeleportDelay(Gaia gaia) {
        return gaia.method_18868().method_18904(ExtraBotanyMemoryType.TELEPORT_DELAY).orElse(35);
    }

    public float getTeleportRange(Gaia gaia) {
        return gaia.method_18868().method_18904(ExtraBotanyMemoryType.TELEPORT_RANGE).orElse(Float.valueOf(12.0f)).floatValue();
    }

    public int getTeleportDelayBase(Gaia gaia) {
        return gaia.method_18868().method_18904(ExtraBotanyMemoryType.TELEPORT_DELAY_BASE).orElse(35);
    }

    public boolean isHurt(Gaia gaia) {
        return gaia.method_18868().method_18896(class_4140.field_18451);
    }

    protected void resolveHurt(Gaia gaia) {
        this.setTeleportDelay(gaia, 4);
        gaia.method_18868().method_18875(class_4140.field_18451);
    }
}

