/*
 * Decompiled with CFR 0.152.
 */
package io.github.lounode.extrabotany.common.impl;

import io.github.lounode.eventwrapper.event.level.LevelEventWrapper;
import io.github.lounode.eventwrapper.eventbus.api.EventBusSubscriberWrapper;
import io.github.lounode.eventwrapper.eventbus.api.SubscribeEventWrapper;
import io.github.lounode.extrabotany.api.level.Wind;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_243;

public class WindImpl
implements Wind {
    private static final Map<class_1937, LevelWind> WIND_MAP = new Reference2ReferenceOpenHashMap();

    @Override
    public double getWindLevel(class_1937 level, class_243 position) {
        return WIND_MAP.computeIfAbsent(level, LevelWind::new).getWindLevel(position);
    }

    public static class LevelWind {
        protected final class_1937 level;
        public int ticksExisted;
        private int baseStrength;
        private double peakHeight;
        private static final double CENTER_OFFSET_RANGE = 10.0;
        private static final int UPDATE_PEAK_HEIGHT_INTERVAL = 36000;
        private static final int UPDATE_STRENGTH_INTERVAL = 200;

        public LevelWind(class_1937 level) {
            this.level = level;
            this.baseStrength = 5 + level.field_9229.method_43048(10);
            this.updatePeakHeight();
        }

        public void tick() {
            if (this.ticksExisted % 200 == 0) {
                int delta = this.level.field_9229.method_43048(3) - 1;
                this.baseStrength = Math.max(1, Math.min(20, this.baseStrength + delta));
            }
            if (this.ticksExisted % 36000 == 0) {
                this.updatePeakHeight();
            }
            ++this.ticksExisted;
        }

        private void updatePeakHeight() {
            double seaLevel = this.level.method_8615();
            double maxHeight = this.level.method_31600();
            double center = (seaLevel + maxHeight) / 2.0;
            this.peakHeight = center + (this.level.field_9229.method_43058() * 2.0 - 1.0) * 10.0;
        }

        public double getWindLevel(class_243 position) {
            double height = position.method_10214();
            double seaLevel = this.level.method_8615();
            double maxHeight = this.level.method_31600();
            double range = maxHeight - seaLevel;
            double delta = height - this.peakHeight;
            double sigma = 20.0;
            double heightMultiplier = Math.exp(-Math.pow(delta / sigma, 2.0));
            double result = (double)this.baseStrength * (0.5 + heightMultiplier * 1.5);
            double rainOffset = 1.0;
            if (this.level.method_8419()) {
                rainOffset += 0.25;
            }
            if (this.level.method_8546()) {
                rainOffset += 0.25;
            }
            return result * rainOffset;
        }
    }

    @EventBusSubscriberWrapper
    public static class EventHandler {
        @SubscribeEventWrapper
        public static void onLevelLoad(LevelEventWrapper.Load event) {
            class_1937 level = (class_1937)event.getLevel();
            WIND_MAP.computeIfAbsent(level, LevelWind::new);
        }

        @SubscribeEventWrapper
        public static void onLevelUnLoad(LevelEventWrapper.Unload event) {
            class_1937 level = (class_1937)event.getLevel();
            WIND_MAP.remove(level);
        }

        public static void onLevelTick(class_1937 level) {
            LevelWind wind = WIND_MAP.get(level);
            if (wind != null) {
                wind.tick();
            }
        }
    }
}

